#include <stdio.h>
#include <string.h>
#include <allegro.h>
#include "sh_alleg.h"
#include "sh_sprit.h"
#include "my_sprit.h"
#include "game.h"
#include "jj_main.h"
#include "jj_safc.h"
#include "jj_music.h"

//externals
extern CAllegro myGame;  //allegro details
extern volatile int fps; //actual fps
extern volatile int frame_count; //updated every frame to keep fps in sync
extern volatile int digipurge;
extern BITMAP* gbuffer;
extern int gbufw; //quick access to gbuffer height/width
extern int gbufh;
extern int gbufw_c;
extern int gbufh_c;
extern int logo_shown;
extern int extradat;
extern int musicdat;

//globals
int gapcount=0;
int animation_level=ANIM_NORMAL;
DATAFILE* dat_main;
DATAFILE* dat_safc;
DATAFILE* dat_music;

int cheatmode=FALSE;
RGB* pal_logo;
int leftmostpos;

//note changing this requires all externs to be updated also
int player[][7]=     { { 8,SK_WLKL1_BMP,SK_WLKL2_BMP,SK_WLKL3_BMP,SK_WLKL2_BMP,-1,-1 }, //walking left
                       { 8,SK_WLKR1_BMP,SK_WLKR2_BMP,SK_WLKR3_BMP,SK_WLKR2_BMP,-1,-1 }, //walking right
                       { 20,SK_STND1_BMP,SK_STND2_BMP,SK_STND3_BMP,SK_STND2_BMP,-1,-1}, //standing
                       { 3,SK_JMP1_BMP,SK_JMP2_BMP,SK_JMP3_BMP,SK_JMP2_BMP,-1,-1}, //jumping
                       { 12,SK_DIZ1_BMP,SK_DIZ2_BMP,SK_DIZ3_BMP,SK_DIZ4_BMP,-1,-1}, //dizzy
                       { 3,SK_JMP1_BMP,SK_JMP2_BMP,SK_JMP3_BMP,SK_JMP2_BMP,-1,-1}, //fall down gap after hit
                       { 3,SK_JMP1_BMP,SK_JMP2_BMP,SK_JMP3_BMP,SK_JMP2_BMP,-1,-1}, //fall down gap
                       { 300,SK_DEAD1_BMP,SK_DEAD2_BMP,SK_DEAD3_BMP,SK_DEAD4_BMP,SK_DEAD5_BMP,-5} //dead
                     };
//auto-geordies only differ when walking and standing
//no real need to change when jumping or dizzy as difference is seen only when standing/walking
//auto-geordies are smaller than would-be mackems due to a generic gene
//that only pure geordies get which stunts their growth and reduces intelligence
//as opposed to those who knew something was wrong when they were young
//when they were bigger and brighter and new they weren't geordie :)
int autogeordie[][7]={ { 8,AG_WLKL1_BMP,AG_WLKL2_BMP,AG_WLKL3_BMP,AG_WLKL2_BMP,-1,-1 }, //walking left
                       { 8,AG_WLKR1_BMP,AG_WLKR2_BMP,AG_WLKR3_BMP,AG_WLKR2_BMP,-1,-1 }, //walking right
                       { 20,AG_STND1_BMP,AG_STND2_BMP,AG_STND3_BMP,AG_STND2_BMP,-1,-1}, //standing
                       { 3,SK_JMP1_BMP,SK_JMP2_BMP,SK_JMP3_BMP,SK_JMP2_BMP,-1,-1}, //jumping
                       { 12,SK_DIZ1_BMP,SK_DIZ2_BMP,SK_DIZ3_BMP,SK_DIZ4_BMP,-1,-1}, //dizzy
                       { 3,SK_JMP1_BMP,SK_JMP2_BMP,SK_JMP3_BMP,SK_JMP2_BMP,-1,-1}, //fall down gap after hit
                       { 3,SK_JMP1_BMP,SK_JMP2_BMP,SK_JMP3_BMP,SK_JMP2_BMP,-1,-1}, //fall down gap
                       { 300,SK_DEAD1_BMP,SK_DEAD2_BMP,SK_DEAD3_BMP,SK_DEAD4_BMP,SK_DEAD5_BMP,-5} //dead
                     };

int playersafe[6]={12,SK_DUGF1_BMP,SK_DUGF2_BMP,SK_DUGF3_BMP,SK_DUGF2_BMP,-1};

int playerkeys[4][4]={ {KEY_LEFT, KEY_RIGHT, KEY_UP, KEY_DOWN},
                       {KEY_Z, KEY_X, KEY_Q, KEY_A},
                       {KEY_N, KEY_M, KEY_U, KEY_J},
                       {KEY_1, KEY_3, KEY_5, KEY_2}
                       };

int showplayernumber=FALSE; //show position until player moves
int autoshownumber=TRUE; //show number on startup
int playersleft=0;
int computersleft=0;

int game_level=1;       //default level
int levelsafeavailable[8]; //player can go into safety zone - bottom layer included to make code simpler

//module level global control variables
static int difficulty_level=GAME_NORMAL;
static int spec_level=SPEC_ALL;
static int player_level=1;
static int computer_level=0;
static int music_level=MUSIC_ALL;
static int shearerthere;

//single player game carry over to next level
static int carryscore=0;
static int carrylives=MAX_LIVES_NORMAL; //as opposed to deathmatch
static int carrysafes=0;
static int carrybombs=0;

static char passwords[][11]={
"iluvsafc",
"superkev",
"mightyq",
"pennywell",
"stephen",
"redarmy",
"onemore",
"theend"
};


static const int hazstartnum=6; //how many of the below hazards there are
static int hazstartsprites[][12]= {
           { 2, HAZBALL1_BMP, HAZBALL2_BMP, HAZBALL3_BMP, HAZBALL4_BMP, HAZBALL5_BMP, HAZBALL5_BMP, HAZBALL4_BMP, HAZBALL3_BMP, HAZBALL2_BMP, HAZBALL1_BMP, -1},
           { 10, HAZCAR1_BMP , HAZCAR2_BMP , HAZCAR3_BMP , -1,-1,-1,-1,-1,-1,-1},
           { 3, HAZSPID1_BMP, HAZSPID2_BMP, -1,-1,-1,-1,-1,-1,-1,-1,-1},
           { 10, HAZTRUK1_BMP, HAZTRUK2_BMP, HAZTRUK3_BMP,-1,-1,-1,-1,-1,-1,-1,-1},
           { 15, HAZUFO1_BMP , HAZUFO2_BMP , HAZUFO3_BMP , HAZUFO4_BMP, -1,-1,-1,-1,-1,-1,-1},
           { 10, HAZVAN1_BMP , HAZVAN2_BMP , -1,-1,-1,-1,-1,-1,-1,-1,-1 },
};

static int fireball[12]={5,HAZFIR01_BMP,HAZFIR02_BMP,HAZFIR03_BMP,HAZFIR04_BMP,HAZFIR05_BMP,HAZFIR06_BMP,HAZFIR07_BMP,HAZFIR08_BMP,HAZFIR09_BMP,HAZFIR10_BMP,-1};

static int hazshearershearer[4]={10,HAZPOP1_BMP,HAZPOP2_BMP,-1};
static int gapsprites[3]={0,HAZGAP_BMP,-1}; //no animation
int bob=gapsprites[1];
static int showfps=FALSE;
static int autoshowfps=TRUE;
static int noplayersshown=FALSE; //message box when all humans are dead
//colours
static int fg1=250; //main title text (green)
static int fg2=251; //main title text (yellow)
static int fg3=254; //cyan (For boxes/lines)
static int fgdark=252; //dar text colour
static int bg1=255; //white

static BITMAP* road; //area to draw the road and gaps onto road


//memory locks
volatile int game_time;
void game_timer()
{
 game_time++;
}
END_OF_FUNCTION(game_timer);


int position_logo(BITMAP* dest,BITMAP* src,int redr)
{
 int xoffset=80;
 if(redr==TRUE) blit(src,dest,0,0,xoffset,SCREEN_H/2-(src->h/2),src->w,src->h);
 return xoffset;
}

//these functions
//called by user in options screen
void difficulty()
{
 switch(difficulty_level) {
   case GAME_NUTTER:
        difficulty_level=GAME_EASY;
        break;
   case GAME_EASY:
        difficulty_level=GAME_NORMAL;
        break;
   case GAME_NORMAL:
        difficulty_level=GAME_HARD;
        break;
   case GAME_HARD:
        difficulty_level=GAME_NUTTER;
        break;
 }
}

void difficulty_string(char* ret)
{
 if(difficulty_level==GAME_EASY) sprintf(ret,"%s",STR_EASY);
 if(difficulty_level==GAME_NORMAL) sprintf(ret,"%s",STR_NORMAL);
 if(difficulty_level==GAME_HARD) sprintf(ret,"%s",STR_HARD);
 if(difficulty_level==GAME_NUTTER) sprintf(ret,"%s",STR_NUTTER);
 if(*ret==0) sprintf(ret,"%s","You've found a bug!!!");
}

void spec()
{
 switch(spec_level) {
   case SPEC_ALL:
        spec_level=SPEC_NONE;
        break;
   case SPEC_NONE:
        spec_level=SPEC_ALL;
        break;
 }
 //if no extra file then only none or transparency allowed
 if(extradat==FALSE) {
   spec_level=SPEC_NONE;
 }
}

void spec_string(char* ret)
{
 if(spec_level==SPEC_ALL) sprintf(ret,"%s",STR_ALL);
 if(spec_level==SPEC_NONE) sprintf(ret,"%s",STR_NONE);
 if(*ret==0) sprintf(ret,"%s","You've found a bug!!!");
}

void music()
{
 if(musicdat==FALSE) music_level=MUSIC_NONE;
 else {
   switch(music_level) {
     case MUSIC_ALL:
        music_level=MUSIC_MUSIC;
        myGame.noDigi();
        myGame.yesMusic();
        //no need to play music as just come from all
        break;
     case MUSIC_MUSIC:
        music_level=MUSIC_SOUND;
        myGame.stopmidi();
        myGame.noMusic();
        myGame.yesDigi();
        break;
     case MUSIC_SOUND:
        music_level=MUSIC_NONE;
        myGame.stopmidi();
        myGame.noMusic();
        myGame.noDigi();
        break;
     case MUSIC_NONE:
        music_level=MUSIC_ALL;
        myGame.yesDigi();
        myGame.yesMusic();
        GazzaPlay();
        break;
   }
 }
}

void music_string(char* ret)
{
 if(music_level==MUSIC_ALL) sprintf(ret,"%s",STR_MUSIC_ALL);
 if(music_level==MUSIC_MUSIC) sprintf(ret,"%s",STR_MUSIC_MUSIC);
 if(music_level==MUSIC_SOUND) sprintf(ret,"%s",STR_MUSIC_SOUND);
 if(music_level==MUSIC_NONE) sprintf(ret,"%s",STR_MUSIC_NONE);
 if(*ret==0) sprintf(ret,"%s","You've found a bug!!!");
}

void computerset(int direction)
{
 computer_level+=direction;
 if(computer_level>200) computer_level=0;
 if(computer_level<0) computer_level=200;

 //reset game level
 if(player_level==1 && computer_level==0) game_level=1;

}

void playerset()
{
 player_level++;
 if(player_level>4) player_level=0;

 //reset game level
 if(player_level==1 && computer_level==0) game_level=1;
}

void computer_string(char* ret)
{
 if (computer_level==1) sprintf(ret,"1 Auto-Geordie");
 else sprintf(ret,"%d Auto-Geordies",computer_level);
}

void player_string(char* ret)
{
 if(player_level==1) sprintf(ret,"1 Pretend Mackem");
 else sprintf(ret,"%d Pretend Mackems",player_level);
}

void animation()
{
 switch(animation_level) {
   case ANIM_NORMAL:
        animation_level=ANIM_SMOOTH;
        break;
   case ANIM_SMOOTH:
        animation_level=ANIM_NORMAL;
        break;
 }
}

void animation_string(char* ret)
{
 if(animation_level==ANIM_SMOOTH) sprintf(ret,"%s",STR_ANIM_SMOOTH);
 if(animation_level==ANIM_NORMAL) sprintf(ret,"%s",STR_ANIM_NORMAL);
 if(*ret==0) sprintf(ret,"%s","You've found a bug!!!");
}

void instructions(BITMAP* buf)
{
 char ins1[][75]={  "Can you guide Skunk McGeordie through",
                    "9 levels of increasing difficulty?",
                    "",
                    "It is more that life or death,",
                    "it is a matter of football." };
 char ins2[][75]={  "Skunk McGeordie has a problem.",
                    "He supports Newcastle United.",
                    "",
                    "Born in a den of depravity,",
                    "Reared in the slums,",
                    "Supporting the Toon wasn't a choice.",
                    "",
                    "Pretending to support them through the numerous",
                    "bad patches was intrinsic.  In times of low",
                    "turnouts everyone was expected to say",
                    "they were there.",
                    "",
                    "Yet come matchday he dreams of Sunderland.",
                    "Of turning the bleak black into vibrant red." };
 char ins3[][75]= { "Each new level presents one more obstacle,",
                    "and a new backdrop of Eutopia.",
                    "Finish all 9 levels and you will turn",
                    "Skunk McGeordie into pure Mackem.",
                    "",
                    "Objectives - Normal Game",
                    "Jump through the holes and reach the top.",
                    "Complete all 9 levels and finish the game.",
                    "A password is given on finishing a level.",
                    "",
                    "Objectives - Deathmatch",
                    "First to reach the top of the level you select,",
                    "Higher the level the more obstacles.",
                    "Use your bombs wisely!"};
 char ins4[][75]= { "Keys - Left, Right, Jump, Action",
                    "Player 1 - cursors",
                    "Player 2 - ZXQA",
                    "Player 3 - NMUJ",
                    "Player 4 - 1352",
                    "Hit Action to go into a safe area of level,",
                    "Hit Action again to let off fireball.",
                    "F1 - HELP on all other keys while in the game.",
                    "",
                    "Obstacles",
                    "Hitting obstacles/roof makes Skunk very dizzy,",
                    "Falling down holes make Skunk dizzy a little.",
                    "Skunk cannot be hit when in the dug-outs.",
                    "",
                    "Other",
                    "You are given a new safe pass and life",
                    "Every new level in normal game.",
                    "If the game runs too slow try turning off",
                    "Backdrops, Smoothness or some auto-geordies."};


 do {
    subdisp(ins1,5,buf,TRUE,TRUE,fg1,WIPE_DOWN);
    if(!key[KEY_ESC]) subdisp(ins2,14,buf,FALSE,TRUE,fg1,WIPE_UP);
    if(!key[KEY_ESC]) subdisp(ins3,14,buf,FALSE,TRUE,fg1,WIPE_DOWN);
    if(!key[KEY_ESC]) subdisp(ins4,19,buf,FALSE,TRUE,fg1,WIPE_UP);
    //clear buffer if not escape
    if(key[KEY_ESC]==FALSE) clear_keybuf();
 } while(!key[KEY_ESC]);

}

void credits(BITMAP* buf)
{
 //display credits
 char credits1[][75]={ "Programming",
                       "Neil Walker",
                       "",
                       "Graphics",
                       "John Blythe",
                       "Imagine (Original Logo)",
                       "",
                       "Sound Effects",
                       "www.hollywoodedge.com",
                       "",
                       "Music",
                       "Rossinni - The Thieving Magpie",
                       "MIDI conversion unknown",
                       "",
                       "Testing",
                       "Retrospec",
                       "Aleksander Lukic"};
 char credits2[][75]={ "Mackems throughout the world",
                       "",
                       "Special Thanks to Welsh Mackem",
                       "For compiling the SAFC media",
                       "(Sorry forgot your name!)"};
 char credits3[][75]= { "Retrospec",
                        "Providing a place at the Scrabble Table",
                        "",
                        "Shawn Hargreaves",
                        "Producing the lovely Allegro Library",
                        "",
                        "Imagine",
                        "For the original game",
                        };

 do {
    //clear buffer if not escape
    if(!key[KEY_ESC]) subdisp(credits1,17,buf,TRUE,TRUE,fg1,WIPE_RIGHT);
    if(!key[KEY_ESC]) subdisp(credits2,5,buf,TRUE,TRUE,fg1,WIPE_LEFT);
    if(!key[KEY_ESC]) subdisp(credits3,8,buf,TRUE,TRUE,fg1,WIPE_RIGHT);
    //clear buffer if not escape
    if(key[KEY_ESC]==FALSE) clear_keybuf();
 } while(!key[KEY_ESC]);

}


void subdisp(char list[][75],int rows,BITMAP* buf,int hcentreflag,int vcentreflag,int colour,int wipetype)
{
 //draw list to buf with horizontal/vertical centreing
 BITMAP* newdisplay;
 int y=0;
 int loop=0;
 newdisplay=create_bitmap(buf->w,buf->h);

 //draw on hidden buffer
 if(vcentreflag==TRUE) y=newdisplay->h/2-(text_height(font)*rows/2);
 clear(newdisplay);
 while(loop<rows) {
   if(hcentreflag) textout_centre(newdisplay,font,list[loop],newdisplay->w/2,y,colour);
   else textout(newdisplay,font,list[loop],0,y,colour);
   y+=text_height(font);
   loop++;
 }

 //add bottom caption
 textout(newdisplay,font,"Press A Key. ESC Exits.",0,newdisplay->h-text_height(font),fg2);
 //flash it on screen
 acquire_screen();
 wipe(newdisplay,buf,wipetype);
 blit(newdisplay,buf,0,0,0,0,buf->w,buf->h);
 release_screen();
 clear_keybuf();
 readkey();
 destroy_bitmap(newdisplay);
}

void wipe(BITMAP* src,BITMAP* dst, int wipetype)
{
 //wipe from src to dst
 //(assumes dest is a visible bitmap - otherwise its pointless ;)
 //(assumes both bitmaps are the same)
 int dx=0;
 int dy=0;
 int x=0;
 int y=0;
 int width=0;
 int height=0;
 int loop=0;
 BITMAP* temp=create_bitmap(dst->w,dst->h);

 switch(wipetype) {
   case WIPE_UP:
        dx=0;
        dy=-1;
        x=0;
        loop=y=dst->h;
        width=dst->w;
        height=0;
        break;
   case WIPE_DOWN:
        dx=0;
        dy=1;
        x=0;
        y=0;
        width=dst->w;
        height=0;
        loop=dst->h;
        break;
   case WIPE_LEFT:
        dx=-1;
        dy=0;
        loop=x=dst->w;
        y=0;
        width=0;
        height=dst->h;
        break;
   case WIPE_RIGHT:
        dx=1;
        dy=0;
        x=0;
        y=0;
        width=0;
        height=dst->h;
        loop=dst->w;
        break;
 }

 while(loop>0){
   blit(src,temp,0,0,0,0,temp->w,temp->h);
   //clear the correct area
   switch(wipetype) {
     case WIPE_LEFT:
          //wipe full height, x to end
          rectfill(temp,0,0,x,height,0);
          break;
     case WIPE_RIGHT:
          //wipe full height, start to x
          rectfill(temp,x,0,dst->w,height,0);
          break;
     case WIPE_UP:
          //wipe full width, start to y
          rectfill(temp,0,0,width,y,0);
          break;
     case WIPE_DOWN:
          //wipe full width, y to end
          rectfill(temp,0,y,width,dst->h,0);
          break;
   }
   line(temp,x,y,x+width,y+height,fg3);
   x+=dx;
   y+=dy;
   loop--;
   //vsync();
   blit(temp,dst,0,0,0,0,temp->w,temp->h);
 }
 //remove line by simply replacing image
 blit(src,dst,0,0,0,0,dst->w,dst->h);

 destroy_bitmap(temp);
}

int quit()
{
 //create faded palette
 //draw translucent box
 //wait for resonse
 return -1; //quit
}

void play_game()
{
//game loop proper

  //initialisation
  //set palette and install game timer
  set_palette((RGB*)dat_main[PALMAIN_BMP].dat);
  game_time=0;
  int req_fps=animation_level*FRAME_FPS_TARGET;
  install_int_ex(game_timer,BPS_TO_TIMER(req_fps));

  //reset control flags
  int done=FALSE;
  int draw=TRUE;
  int leveldone=FALSE;
  game_time=0;
  char name[20];
  noplayersshown=FALSE;

  //start a new game
  clear(screen);
  //if there is a hack in the game, the line below is it
  //for some reason in deatmatch mode effects (nodigi) gets set to TRUE (effects off) after every level
  if(music_level==MUSIC_SOUND || music_level==MUSIC_ALL) myGame.yesDigi();
  else myGame.noDigi();

  newlevel(&gapcount,FALSE);    //start the game with the current level poem
  do {
    //target is 30fps normal (double for smooth)
	//this first loop should take minimal time
	//so if the blit/drawing section below takes one 1/30 of second then target
	//will just be 1 so loop is called just once
	//then if this loop is nothing then we have 30fps
	//if blit/drawing takes 2/30 second then on entry to the loop below
	//target will be 2 and screen will not update fast enough - player will move more

	//therefore can control speed by required speed per second and fps
	//if we want 10 pixels per second and target is 30fps then
	//if we increase x by 10/30 (i.e. 0.3 per frame) then we move 10 pixels in one second
	//if fps is 100 then x is increased by  10/100 (ie. .1 per frame)
	//if achieve 60fps when we require just 30 then
	//loop is ignored twice and same screen left

    //update items if a frame is up
    //if not then system is too fast so don'd do anything
    //this variable is in an interrupt timer every FPS (30 or 60)
    while(game_time) {
      //first get any game keys
      done=gameInput(); //read game keys (not player movement) - done set to TRUE if abort by user
      //if not quit then update player and computer players
      if(done==FALSE) done=playerUpdate();
      else break; //exit if quit
      //if not game over then update the rest
      if(done==FALSE) {
        hazardUpdate();   //as above for hazards
        //this method updates all CSprite (and subclasses)
        //movements, animations and collisions
        CSprite::NextFrame();
        draw=TRUE;
      } else {
        //no point redrawing if quitting
        draw=FALSE;
        break; //exit
      }
      //decrement game count for next loop
      game_time--;
    }
    //should exit loop every FRAMERATE/second second if on time
    //update display if frame has been drawn
    //if not then system is too fast so don't do anything
    if(draw) {
      //function call order is z order
      gameDraw(); //background and platforms
      hazardDraw(); //hazards first
      otherDraw();  //other stuff, i.e. sideline, etc.
      playerDraw(&leveldone,name); //now player last, always top
      lastDraw(); //on top stuff

      //now update the screen
      //this is the simple double buffer technique
	  acquire_screen();
	  //vsync();
      blit(gbuffer, screen, 0, 0, 0, 0,gbuffer->w,gbuffer->h);
	  release_screen();
      frame_count++; //update every drawn screen - should match fps which is required FPS or less, cannot be higher
      draw=FALSE;
    }

    //check if finished level
    if(leveldone==TRUE) {
      playsample(ENDLEVEL_WAV,HIGH,LOUD);
      if(player_level==1 && computer_level==0) {
        //single player end of level - start a new one
        done=newlevel(&gapcount,TRUE);   //if finished level start new level
        leveldone=FALSE; //reset level to not being completed
      } else {
        //multi-player finish if >1 player or no human
        transmsgbox(screen,SCREEN_W,SCREEN_H,"And the winner is (press SPACE when finished):",name,fg3,fgdark);
        waitF7();
        done=TRUE;
      }
    }
    //clear up any finished samples.  This may be better inside the processing loop to only clear up when free time.
    if(digipurge==TRUE) {
      digipurge=FALSE;
      myGame.purgedigi();
    }

  } while(done==FALSE);
  //global buffer bitmap is destroyed on exit
  remove_int(game_timer); //stop timer and remove it
  CSprite::KillAll();      //remove any objects
  myGame.killdigi(); //stop all known samples

  //set music menu to what it is now
  if(myGame.getMusic()==TRUE && myGame.getDigi()==TRUE) music_level=MUSIC_ALL;
  else if(myGame.getMusic()==TRUE && myGame.getDigi()==FALSE) music_level=MUSIC_MUSIC;
  else if(myGame.getMusic()==FALSE && myGame.getDigi()==TRUE) music_level=MUSIC_SOUND;
  else music_level=MUSIC_NONE;

}

int gameInput()
{
 //generic key presses, i.e. not player related
 //show fps
 if(key[KEY_F1]) gamehelp();

 if(key[KEY_F2]) {
   if(showfps==FALSE) showfps=TRUE;
   else showfps=FALSE;
 }
 //auto frame warning on/off
 if(key[KEY_F3]) {
   if(autoshowfps==FALSE) autoshowfps=TRUE;
   else autoshowfps=FALSE;
 }

 //save current screen
 if(key[KEY_F4]) {
   BITMAP* tmp=create_sub_bitmap(screen,0,0,SCREEN_W,SCREEN_H);
   save_bitmap("jackdump.bmp",tmp,(RGB*)dat_main[PALMAIN_BMP].dat);
   destroy_bitmap(tmp);

 }

 //pause mode
 if(key[KEY_F5]) {
   gamepause();
 }

 //show playerpos
 if(key[KEY_F6]) {
   (showplayernumber==TRUE || autoshownumber==TRUE) ? showplayernumber=FALSE : showplayernumber=TRUE;
 }

 //F7 allocated to restore from pause, etc.

 //toggle music
 if(key[KEY_F8]) {
   if(myGame.getMusic()==TRUE)        {
     myGame.noMusic();
     myGame.stopmidi();
     transmsgbox(screen,SCREEN_W,SCREEN_H,"Music Is Off","press SPACE.",fg3,fgdark);
   }
   else {
     myGame.yesMusic();
     GazzaPlay();
     transmsgbox(screen,SCREEN_W,SCREEN_H,"Music Is On","press SPACE.",fg3,fgdark);
   }
   waitF7();
   game_time=1; //reset interrupt timer

 }
 //toggle digi
 if(key[KEY_F9]) {
   if(myGame.getDigi()==TRUE) {
     myGame.killdigi();
     myGame.noDigi();
     transmsgbox(screen,SCREEN_W,SCREEN_H,"Effects Are Off","press SPACE.",fg3,fgdark);
   }
   else {
     myGame.yesDigi();
     transmsgbox(screen,SCREEN_W,SCREEN_H,"Effects Are On","press SPACE.",fg3,fgdark);
   }
   waitF7();
   game_time=1; //reset interrupt timer
 }

 if(key[KEY_F10]) myGame.abortsystem("Quick quit selected");

 if(key[KEY_F12]) {
   debugitems();
 }

 //escape
 if(key[KEY_ESC]) {
   return gamequit();
 }


 //if all else fails return as no quit
 return FALSE;
}

void debugitems()
{
 /*
 CSprite* item;
 item=CSprite::first;
 int i=0;
 while(item) {
   textprintf(screen,font,100,100+i*10,252,"%d %d %d",item->num,item->prev->num,item->next->num);
   item=item->next;
   i++;
 }
 textprintf(screen,font,200,200,252,"%d",i);
 waitF7();
 game_time=1;
 */
}

int playerUpdate()
{
 //player only related key presses not part of sprite routine (i.e. not movement)
 //dont call nextframe as called in main loop
 int ret=FALSE;
 char plev[11];
 int thescore=0;

 playersleft=computersleft=0;
 //update player counts
 CSprite* players=CSprite::first;
 while(players) {
   if(players->type==MAN) 
   {
	   if(((CPlayer*)players)->isdead()==FALSE) playersleft++;
	   thescore=((CPlayer*)players)->score;
   }
   if(players->type==COMPUTER) if(((CPlayer*)players)->isdead()==FALSE) computersleft++;
   players=players->next;
 }

 //check if game over
 //if no players at all left, exit
 //if only computers left, leave
 //if players left, leave
 if(player_level==1 && computer_level==0) {
   //1 player game
   //i.e. player is playing full game
   if(playersleft==0) {
     if(game_level==1) {
       transmsgbox(screen,SCREEN_W,SCREEN_H,"Game over.  press SPACE to continue.","Your game was that poor you are resigned to being a Geordie!",fg3,fgdark);
       waitF7();
     }
     else {
       sprintf(plev,passwords[game_level-2]);
       clear_keybuf();
       transmsgbox(screen,SCREEN_W,SCREEN_H,"Game over.  Your password for the level is below.  press SPACE to Continue.",plev,fg3,fgdark);
       waitF7();
     }

	 clear_keybuf();
   transmsgbox(screen,SCREEN_W,SCREEN_H,"Game over.  press SPACE to continue.","",fg3,fgdark);
   waitF7();
   char code[256]="ZX81";
   int scores[1]={thescore};
   int sizes[1]={4};
   uuencode_generic();
   char message1[50];
   clear(screen);
   clear_keybuf();
   sprintf(message1,"High Score code: %s",code);
   transmsgbox(screen,SCREEN_W,SCREEN_H,message1,"Go to retrospec.sgn.net to enter code",fg3,fgdark);
   waitF7();
	set_config_file("score.txt");
	set_config_string("Code", "Key", code);
	set_config_file(CONFIG_FILE);
	clear_keybuf();
	clear(screen);
   transmsgbox(screen,SCREEN_W,SCREEN_H,"The code has been written to score.txt","Press SPACE",fg3,fgdark);
   waitF7();

     ret=TRUE; //exit
   }
 } else {
   //multi-player game
   //player is playing deathmatch
   if(playersleft==0 && computersleft==0) {
     clear_keybuf();
     transmsgbox(screen,SCREEN_W,SCREEN_H,"All players are dead.","press SPACE.",fg3,fgdark);
     waitF7();
     ret=TRUE;
   } else {
     //someone is still there
     if(playersleft==0 && noplayersshown==FALSE && computersleft>0) {
       //if computers are there then let user exit
       noplayersshown=TRUE;
       clear_keybuf();
       transmsgbox(screen,SCREEN_W,SCREEN_H,"How sad.  Computers are still alive!","You can wait to watch or abort.  press SPACE to continue.",fg3,fgdark);
       waitF7();
     } else {
       moveComputers();
     }
   }
 }
 return ret;

}

void moveComputers()
{
 //automove computers
 CSprite* item=CSprite::first;
 CSprite* check;
 int x,y;
 int gapx,gapy;
 int nohaz;
 int offset;
 int diff;
 //loop through all computers
 while(item) {
   if(item->type==COMPUTER) {
    //loop through all hazards to check if need to move
    check=CSprite::first;
     //only need to update if available to move (i.e. not being hit)
    if(((CPlayer*)item)->direction!=PM_HIT && ((CPlayer*)item)->direction!=PM_FALLHIT && ((CPlayer*)item)->direction!=PM_FALLGAP && ((CPlayer*)item)->direction!=PM_DEAD) {
      while(check) {
       nohaz=TRUE;

       //check if need to move
       if(check->type==HAZARD || check->type==POPPINS || check->type==GAP || check->type==FIREBALL) {
         //move computer if hazard is close
         //use slight randomness to ease the monotiny
         if(check->type==GAP) {
           //get positions of gap to see if it on same level or above
           CHazard::PosToxy(((CHazard*)item)->position,&x,&y);
           CHazard::PosToxy(((CHazard*)check)->position,&gapx,&gapy);
           //either move or jump
           if(y==gapy) {
             //level above jump - its just the way it works
             if( ((CGap*)check)->gapdirection==GAP_LEFT) {
               //if moving left wait till middle to jump
               if(gapx-x<-50 && gapx-x>-62) {
				 ((CPlayer*)item)->movementoverride=PM_JUMP;
                 nohaz=FALSE;
                 check=NULL;
               }


             } else {
               //gap moving right
               if(x-gapx<70 && x-gapx>62) {
                 ((CPlayer*)item)->movementoverride=PM_JUMP;
                 nohaz=FALSE;
                 check=NULL;
               }
             }
           } else {
             //on same level - run away
             if(y==gapy-1) {
               offset=20+(-5+rand()%10);
               if( ((CGap*)check)->gapdirection==GAP_LEFT) {
                 if(gapx-(x+item->width)<=offset && gapx-x>0) { // && gapx-(x+item->width)>check->width+1) {
                   ((CPlayer*)item)->movementoverride=PM_LEFT;
                   nohaz=FALSE;
                   check=NULL;
                 }
               } else {  //right gap
                 if(x-(gapx+check->width)<=offset && x-(gapx+check->width)>0) { // && x-gapx+check->width>=offset) {
                   ((CPlayer*)item)->movementoverride=PM_RIGHT;
                   nohaz=FALSE;
                   check=NULL;
                 }
               }
             }
           }
         }

		 if(check!=NULL) {
			 if(check->type==HAZARD || check->type==POPPINS || check->type==FIREBALL) {
			   //poppins or hazard
			   if(abs( ((CHazard*)check)->position-((CHazard*)item)->position )<=(50*(difficulty_level+2)+(-10+rand()%20))) {
				 //start moving - left or right
				 nohaz=FALSE;
				 if(check->type==HAZARD) ((CPlayer*)item)->movementoverride=PM_LEFT;
				 if(check->type==POPPINS || check->type==FIREBALL) ((CPlayer*)item)->movementoverride=PM_RIGHT;
				 check=NULL;
			   }
			 }
		 }
       }
       //here
       if(nohaz==TRUE) {
        //nothing to worry about as no hazards near
        //need to move though if at edge to make it visible
        //move if at edge and default is to stand still
        //if it always moves then move it
        switch(((CPlayer*)item)->defaultdirection) {
          case PM_FIXED:
               //move or stay
               //allow slight variance for pixel movement
               CHazard::PosToxy(((CHazard*)item)->position,&x,&y);
               diff=x-( ((CPlayer*)item)->defaultposition%639 );
               if(diff<-2) ((CPlayer*)item)->movementoverride=PM_RIGHT;
               else if(diff>2) ((CPlayer*)item)->movementoverride=PM_LEFT;
               else ((CPlayer*)item)->movementoverride=PM_STILL;
               break;
          case PM_LEFT:
          case PM_RIGHT:
               ((CPlayer*)item)->movementoverride=((CPlayer*)item)->defaultdirection;
               break;
          default:
               //still
               CHazard::PosToxy(((CHazard*)item)->position,&x,&y);
               if((x<(item->width*2) || x>(638-(item->width*2)))) ((CPlayer*)item)->movementoverride=PM_LEFT;
               else ((CPlayer*)item)->movementoverride=PM_STILL;
               break;
        }

       }

       if(check!=NULL) check=check->next; //get next if not set by auto-move
     }
    }
   }
   item=item->next;
 }
}

void hazardUpdate()
{
 //hazard related update
 //dont call nextframe as called in main loop

 //delete any that need deleting - i.e. fireballs
 //will also delete any other flagged, but is only fireballs in this game
 CSprite* item=CSprite::first;
 CSprite* next=item;
 while(item) {
   next=item->next;
   if(item->flagdelete) CSprite::KillItem(item);
   item=next;
 }

}

void gameDraw()
{
 //do backdrop first
 clear_to_color(gbuffer,bg1);
 drawbackdrop();

 //draw platforms
 drawplatforms();

 //draw score lines, men, etc.

 //draw fps is required
 //if only 70% then show it anyway (i.e. 21 or 42 for 30/60 fps)
 if((fps<(FRAME_FPS_TARGET*animation_level)*.7) && autoshowfps==TRUE) textprintf(gbuffer,font,0,SCREEN_H-text_height(font),fgdark,"FPS (Max %d): ONLY %d!",FRAME_FPS_TARGET*animation_level,fps);
 else {
   if(showfps==TRUE) textprintf(gbuffer,font,0,SCREEN_H-text_height(font),fgdark,"FPS (Max %d): %s %d",FRAME_FPS_TARGET*animation_level,(fps<(FRAME_FPS_TARGET*animation_level)*.7) ? "ONLY" : "",fps);
 }
 if(cheatmode==TRUE) textout(gbuffer,font,"You cheating bastard!",SCREEN_W-text_length(font,"You cheating bastard!"),SCREEN_H-text_height(font),fgdark);
}

void hazardDraw()
{
 //loop through the hazards and just place them
 //include all sprites, excluding players/computer and gaps
 CSprite* item=CSprite::first;
 BITMAP* ptr;
 int x,y;
 while(item) {
   //get x,y co-ordinates and place sprite
   //must be of type hazard or a sub class of hazard
   //gaps are controlled seperately
   if(item->type==HAZARD || item->type==POPPINS || item->type==FIREBALL) {
     CHazard::PosToxy(((CHazard*)item)->position,&x,&y);  //get row, column
     y*=60; //get pixel position of platform
     ptr=(BITMAP*)dat_main[((CHazard*)item)->animseq[((CHazard*)item)->shownsprite]].dat; //current sprite
     masked_blit(ptr,gbuffer,0,0,x,y-ptr->h+60,ptr->w,ptr->h); //60 is offset for level
   }
   item=item->next;
 }
}

void playerDraw(int* leveldone,char* name)
{
 //loop through the players and just place them
 //include computer and players only
 CSprite* item=CSprite::first;
 BITMAP* ptr;
 int x,y;
 while(item) {
   //get x,y co-ordinates and place sprite
   //must be of type hazard or a sub class of hazard
   if(item->type==MAN || item->type==COMPUTER) {
     if(((CPlayer*)item)->position<0) {
       //reached the top
       *leveldone=TRUE;
       strcpy(name,((CPlayer*)item)->username());
       return;
     } else {
       if( ((CPlayer*)item)->lives<1) {
         //no point rekilling him
         if( ((CPlayer*)item)->isdead()==FALSE) ((CPlayer*)item)->dead();
       }
     }
     CHazard::PosToxy(((CHazard*)item)->position,&x,&y);  //get row, column
     y*=60; //get pixel position of platform
     ptr=(BITMAP*)dat_main[((CHazard*)item)->animseq[((CHazard*)item)->shownsprite]].dat; //current sprite
     //take into account jumping/falling
     masked_blit(ptr,gbuffer,0,0,x,y-ptr->h+60-((CPlayer*)item)->vertical,ptr->w,ptr->h);

     if(item->type==MAN && (showplayernumber==TRUE || autoshownumber==TRUE)) {
       textprintf(gbuffer,font,x+(item->width/2)-(text_length(font,"X")/2),y-ptr->h+60-((CPlayer*)item)->vertical-text_height(font)-2,fgdark,"%d",item->num);
     }
   }
   item=item->next;
 }
}

void otherDraw()
{
 //draw scoreline
 //comes after baddy to hide it and before player

 //draw scores/lives/bombs/safes
 int pcount=0;
 CSprite* players=CSprite::first;
 BITMAP* men=(BITMAP*)dat_main[SK_LIFE_BMP].dat;
 BITMAP* bomb=(BITMAP*)dat_main[SK_BOMBS_BMP].dat;
 BITMAP* safe=(BITMAP*)dat_main[SK_SAFES_BMP].dat;
 int iconleft;
 int offset;
 //set score only if 1 player
 if(player_level==1 && computer_level==0) iconleft=text_length(font,"PLAYER X: XXXXX ");
 else iconleft=text_length(font,"PLAYER X ");

 //max 4 players
 while(players) {
   if(players->type==MAN) {
    pcount++;
    //show scores and lives (or just lives if deathmatch)
    if(player_level==1 && computer_level==0) textprintf(gbuffer,font,1,gbuffer->h-pcount*men->h-text_height(font),fgdark,"Player %d: %5d",pcount,((CPlayer*)players)->score);
    else textprintf(gbuffer,font,1,gbuffer->h-pcount*men->h-text_height(font),fgdark,"Player %d ",pcount);
    if( ((CPlayer*)players)->lives<1) {
      textout(gbuffer,font,"Never a Mackem",iconleft,gbuffer->h-pcount*men->h-text_height(font),fgdark);
    }
    else {
      //draw lives, safes, bombs
      for(int i=1;i<((CPlayer*)players)->lives;i++) draw_sprite(gbuffer,men,iconleft+(i-1)*men->w,gbuffer->h-pcount*men->h-text_height(font));
      offset=( ((CPlayer*)players)->lives-1 )*men->w;
      {for(int i=1;i<=((CPlayer*)players)->safes;i++) draw_sprite(gbuffer,safe,offset+iconleft+(i-1)*safe->w,gbuffer->h-pcount*men->h-text_height(font));}
      offset=(((CPlayer*)players)->lives-1)*men->w +(((CPlayer*)players)->safes*safe->w);
      {for(int i=1;i<=((CPlayer*)players)->bombs;i++) draw_sprite(gbuffer,bomb,offset+iconleft+(i-1)*bomb->w,gbuffer->h-pcount*men->h-text_height(font));}
    }
   }
   players=players->next;
 }


}

void lastDraw()
{
 //draw everything that goes on top of everything else
 //sidelines - only drawn if not occupied by player
 BITMAP* ptr=(BITMAP*)dat_main[SK_DUGEM_BMP].dat;
 for(int i=1;i<=7;i++) {
    if(levelsafeavailable[i-1]==TRUE) {
      masked_blit(ptr,gbuffer,0,0,1,(i*60)-ptr->h,ptr->w,ptr->h);
    }
 }

}

void drawbackdrop()
{
 //draw level backdrop if available
 BITMAP* ptr;
 if(extradat==TRUE && spec_level==SPEC_ALL) {
   ptr=(BITMAP*)dat_safc[BACK1_BMP+game_level-1].dat;  //assumes contiguous
   blit(ptr,gbuffer,0,0,gbufw_c-ptr->w/2,gbufh_c-ptr->h/2,ptr->w,ptr->h);
 }
}

void drawplatforms()
{
 //set current level with a new random line
 BITMAP* ptr;
 CSprite* item;
 BITMAP* gap=(BITMAP*)dat_main[HAZGAP_BMP].dat;
 int x,y;
 ptr=(BITMAP*)dat_main[HAZROAD_BMP].dat;

 //draw the levels
 //the lines are 10 pixels high (not including 3D bit)
 //there are 9 lines in 480 pixels so there is a gap of 50
 for(int i=0;i<9;i++) {
    blit(ptr,road,0,0,0,0,ptr->w,ptr->h);

    //now draw gaps if any
    item=CSprite::first;
    while(item) {
      if(item->type==GAP) {
       CHazard::PosToxy(((CHazard*)item)->position,&x,&y);  //get row, column
       y*=60; //get pixel position of platform
       //only draw gap if on platform we are doing
       if(y==i*60) blit(gap,road,0,0,x,0,ptr->w,ptr->h);
      }
      item=item->next;
    }
    //now draw road on screen
    masked_blit(road,gbuffer,0,0,0,i*60-ptr->h+10,ptr->w,ptr->h);
 }

}

int newlevel(int* gapcount,int flag)
{
 //start a new level
 //set level variables
 //set game variables
 //set new sprites
 //if flag TRUE then a level has been completed
 //if flag FALSE then game start
 //multi-player end of level is trapped prior to this call

 //start a new level
 int exit=FALSE;
 shearerthere=FALSE;
 for(int i=0;i<8;i++) levelsafeavailable[i]=TRUE;

 autoshownumber=TRUE;   //set to show number on new level
 exit=showpoem(flag);  //end of the current level (or first one): exit set if finished game
 autoshownumber=TRUE;   //set to show number on new level
 if(flag==FALSE) {
   //new game so reset score and lives
   //as each new level deletes everything, this resets it
   //never valid for deathmatch
   carryscore=0;
   if(player_level!=1 || computer_level!=0) {
     //deathmatch
     carrylives=MAX_LIVES_DEATH;
     carrybombs=2;
     carrysafes=2;
     if(cheatmode==TRUE) { carrybombs=10;carrysafes=5;}
   } else {
     //single game
     carrylives=MAX_LIVES_NORMAL;
     carrysafes=4;
     carrybombs=0;
     if(cheatmode==TRUE) {carrybombs=3;carrysafes=10;}
   }
 } else {
   //new level so carry over the scores/lives
   //linked list is always sequential so first man is player 1
   //scores are only used for 1 player game
   //give a new safe
   CSprite* players=CSprite::first;
   //populate first score/lives only as first is player 1
   //populate bombs and safe zones
   //here only available in single player mode
   while(players) {
     if(players->type==MAN) {
       carryscore=((CPlayer*)players)->score;
       carrylives=((CPlayer*)players)->lives;
       carrysafes=((CPlayer*)players)->safes+1;
       carrybombs=((CPlayer*)players)->bombs;
       players=NULL;
     } else players=players->next;
   }
 }


 if(exit==TRUE) return TRUE;

 //start a new level
 //delete class objects
 CSprite::KillAll();

 //create number of hazards
 int hazcount;
 if(game_level<=6) hazcount=game_level;
 else switch(game_level) {
      case 7:
           hazcount=9;
           break;
      case 8:
           hazcount=13;
           break;
      case 9:
           hazcount=15;
           break;
      default:  //anything above
           hazcount=MAX_HAZARDS;
           break;
      }

 //create hazards
 int j;
 CHazard* newhaz;
 int x1=0,y1=0;
 int posit;
 int rowarray[]={0,6,1,5,2,4,3}; //see below
 {for(int i=0;i<hazcount;i++) {
    //assumes sprite2 comes straight after 1

    //get a random sprite using random (non-ansi) as rand/srand are crap at low numbers especially
    j=rand()%hazstartnum; //0 to sprite number

    newhaz=new CHazard;

    //setup proper entries for added item
    //0-6 sprites get 1,7,2,6,3,5,4 rows alternate left/right third
    //7-13 get same for right/left third
    //14-MAXPOS get random on middle 2/3
    if(i<7) { //1 to 7 sprites
      y1=rowarray[i]; if(i%2==0) x1=426+(rand()%213); else x1=rand()%213; //right third
    }
    if(i>6 && i<14) { //8 to 15
      y1=rowarray[i-7]; if(i%2==0) x1=rand()%213; else x1=426+(rand()%213); //left third
    }
    if(i>13) { //all other
      y1=rand()%7; x1=120+(rand()%420); //anywhere roughly
    }
    CHazard::xyToPos(x1,y1,&posit); //set position

    CHazard::Add(newhaz, posit, (FRAME_GAP_PIXELS_FRAME+difficulty_level)/animation_level, \
                hazstartsprites[j][0]*animation_level, \
                hazstartsprites[j], \
                ((BITMAP*)dat_main[hazstartsprites[j][1]].dat)->w,((BITMAP*)dat_main[hazstartsprites[j][1]].dat)->h,201+i,HAZARD);
 }}

 //create players
 //middle of bottom row, no speed increase for difficulty
 //default to standing still
 addPlayers();

 //new hazard object is deleted by the KillAll static class method

 //add initial gaps
 *gapcount=0; //new level, no gaps
 addGap(GAP_LEFT,gapcount);
 addGap(GAP_RIGHT,gapcount);
 game_time=1; //reset timer

 return exit;
}

void addPlayers()
{
 //create players
 //middle of bottom row, no speed increase for difficulty
 //default to standing still

 //always add player 1 in the centre
 CHazard* newhaz;
 char name[20];
 int loop=player_level+computer_level;
 char smen[4];

 //add computer players
 for(int i=1;i<=computer_level;i++) {
    sprintf(name,"Computer %d",i);
    sprintf(smen,"%d",loop--);
    newhaz=new CPlayer(name);
    CPlayer::Add(newhaz, 7*639+50+rand()%538, FRAME_GAP_PIXELS_FRAME/animation_level, autogeordie[PM_STILL][0]*animation_level, \
              autogeordie[PM_STILL], \
              ((BITMAP*)dat_main[autogeordie[PM_STILL][1]].dat)->w,\
              ((BITMAP*)dat_main[autogeordie[PM_STILL][1]].dat)->h,\
              400+i,COMPUTER);


    if( ((CPlayer*)newhaz)->defaultdirection==PM_FIXED) ((CPlayer*)newhaz)->defaultposition=((CPlayer*)newhaz)->position; //fixed position
    transmsgbox(screen,SCREEN_W,SCREEN_H,"Players to create.  ESCape if game fails to start (reduce players)",smen,fg3,fgdark);
 }

 {for(int i=1;i<=player_level;i++) {
    sprintf(name,"Player %d",i);
    sprintf(smen,"%d",loop--);
    newhaz=new CPlayer(playerkeys[i-1][0],playerkeys[i-1][1],playerkeys[i-1][2],playerkeys[i-1][3],name);    //player 1
    CPlayer::Add(newhaz, 7*639+rand()%638, FRAME_GAP_PIXELS_FRAME/animation_level, player[PM_STILL][0]*animation_level, \
              player[PM_STILL], \
              ((BITMAP*)dat_main[player[PM_STILL][1]].dat)->w,\
              ((BITMAP*)dat_main[player[PM_STILL][1]].dat)->h,\
              i,MAN);
    transmsgbox(screen,SCREEN_W,SCREEN_H,"Players to create.  ESCape if game fails to start (reduce players)",smen,fg3,fgdark);
 }
 }
 //set players scores/lives now that the players are created
 CSprite* players;
 players=CSprite::first;

 while(players) {
   if(((CPlayer*)players)->type==MAN || ((CPlayer*)players)->type==COMPUTER) {
     ((CPlayer*)players)->lives=carrylives;
     ((CPlayer*)players)->score=carryscore;
     ((CPlayer*)players)->safes=carrysafes;
     ((CPlayer*)players)->bombs=carrybombs;
   }
   players=players->next;
 }

}

void addGap(EGAPTYPE etype,int* num)
{
 CHazard* newhaz;
 //add new gap if not too many
 //too many is more than maxgaps
 //or more than game_level*2+5
 //e.g. 6 for level 1, 9,11,13,15,17,19,21,23 for levels 2-9
 //either way, max is MAXGAPS
 if(*num < MAXGAPS && *num<((game_level*2)+5)) {
   newhaz=new CGap(etype);
   CGap::Add(newhaz, rand()%(6*639+639), FRAME_GAP_PIXELS_FRAME/animation_level, 0, \
              gapsprites, \
              ((BITMAP*)dat_main[HAZGAP_BMP].dat)->w,\
              ((BITMAP*)dat_main[HAZGAP_BMP].dat)->h,\
              700+(*num)++,GAP);
 }

 //bring on poppins
 if(shearerthere==FALSE && *num>7) {
   newhaz=new CHazard;
   CHazard::Add(newhaz, rand()%MAXPOS, ((FRAME_GAP_PIXELS_FRAME+difficulty_level)/animation_level)/2, \
                hazshearershearer[0]*animation_level, \
                hazshearershearer, \
                ((BITMAP*)dat_main[hazshearershearer[1]].dat)->w,((BITMAP*)dat_main[hazshearershearer[1]].dat)->h,999,POPPINS);
   shearerthere=TRUE;
   playsample(ENDLEVEL_WAV,HIGH,LOUD);
 }

}

int showpoem(int endlevel)
{
 //start a new level
 int exit=FALSE;
 BITMAP* logo;
 char passw[50];
 char cdummy[20];  //just for player draw
 int idummy; //as above

char story[9][2][70] = {
{ {"Choose unemployment,"},
{"Choose illiteracy,"} },

{ {"Choose uninteligable regional accents,"},
{"Choose to sell all your good players,"} },

{ {"Choose 16,000 fans in Division 1,"},
{"Choose 36,000 fans in the Premiership,"} },

{ {"Choose Warren Barton,"},
{"Choose Ian Rush up front,"} },

{ {"Choose being outsmarted by a team 4 divisions below you,"},
{"Choose trashing your own town after losing a match,"} },

{ {"Choose not winning a trophy for 20 years,"},
{""} },

{ {"Choose living on the most polluted river in Europe,"},
{"Choose Newcastle."} },

{ {"But after jumping the very last gap......"},
{""} },

{ {"Well Done."},
{""} }
};


 //do the end of level sequence -
 //clear the screen with a wipe
 //draw title
 //draw the poem up to the current one
 //scroll up new poem entries
 //give password
 //press any key to continue
 int storyoffset=-1;
 clear_keybuf();
 if(endlevel==TRUE) {
   game_level++;
   storyoffset=-2;
 }


 //fade screen and setup correct game palette
 fade_out(30);
 set_palette((RGB*)dat_main[PALMAIN_BMP].dat);
 clear_to_color(gbuffer,0);
 clear_to_color(screen,0);

 logo=(BITMAP*)dat_main[LEVEND1_BMP].dat;  //set first image

 //setup positions used in the end/start level sequence
 int imageoffset=0;
 int fheight=text_height(font);

 int starttitleline=logo->h+fheight+fheight;
 int startstaticline=starttitleline+fheight*2;
 int topfloatline=startstaticline+fheight+((game_level-1)*2*fheight);


 int scrolltop=SCREEN_H;
 int endloop=FALSE;
 CHazard* newhaz;
 CSprite* item;

 //setup multi-player intro
 if(computer_level>0 || player_level+computer_level>1) {
   //deathmatch
   //create all sprites
   //numbers are irrelevant
   for(int i=1;i<=computer_level;i++) {
    newhaz=new CPlayer(KEY_A,KEY_B,KEY_C,KEY_D,"bob");    //player 1
    CPlayer::Add(newhaz, 5*639+(630-(i*20)), FRAME_GAP_PIXELS_FRAME/animation_level, player[PM_STILL][0]*animation_level, \
              autogeordie[PM_STILL], \
              ((BITMAP*)dat_main[autogeordie[PM_STILL][1]].dat)->w,\
              ((BITMAP*)dat_main[autogeordie[PM_STILL][1]].dat)->h,\
              168+i,COMPUTER);
   }
   {for(int i=1;i<=player_level;i++) {
    //add player count - let them move. he he
    //set id as their finishing position
    newhaz=new CPlayer(playerkeys[i-1][0],playerkeys[i-1][1],playerkeys[i-1][2],playerkeys[i-1][3],"bob");    //player 1
    CPlayer::Add(newhaz, 5*639+(i*20), FRAME_GAP_PIXELS_FRAME/animation_level, player[PM_STILL][0]*animation_level, \
              player[PM_STILL], \
              ((BITMAP*)dat_main[player[PM_STILL][1]].dat)->w,\
              ((BITMAP*)dat_main[player[PM_STILL][1]].dat)->h,\
              i,MAN);
   }}
 }

 //loop round until a key press to show animated logo
 while(endloop==FALSE) {
    if(keypressed()) {
      if(readkey()>>8==KEY_SPACE) endloop=TRUE;
    }

    //draw image
    logo=(BITMAP*)dat_main[LEVEND1_BMP+imageoffset].dat;
    clear_to_color(gbuffer,0);
    blit(logo,gbuffer,0,0,SCREEN_W/2-logo->w/2,0,logo->w,logo->h);
    //draw poem only if single player
    if(computer_level>0 || player_level>1 || player_level==0) {
      textout_centre(gbuffer,font,"Players get ready to battle!",SCREEN_W/2,starttitleline,fg1);
      textout_centre(gbuffer,font,"press SPACE to continue.  Or you can practice your moves first.",SCREEN_W/2,SCREEN_H-fheight,fg1);
    }
    else
    {
     //draw static text (poem already displayed)
     textout_centre(gbuffer,font,"Jumping Skunk is quick and bold,",SCREEN_W/2,starttitleline,fg1);
     textout_centre(gbuffer,font,"With skill his Toon Spotting story will unfold...",SCREEN_W/2,starttitleline+fheight,fg1);
     for(int i=0;i<game_level+storyoffset;i++) {
       textout_centre(gbuffer,font,story[i][0],SCREEN_W/2,startstaticline+(i*2*fheight),fg2);
       textout_centre(gbuffer,font,story[i][1],SCREEN_W/2,startstaticline+(i*2*fheight)+fheight,fg2);
     }

     if(game_level>=1) {
      //if end of level then scroll up display - always two lines of the poem
      if(endlevel==TRUE) {
        textout_centre(gbuffer,font,story[game_level-2][0],SCREEN_W/2,scrolltop,fg1);
        textout_centre(gbuffer,font,story[game_level-2][1],SCREEN_W/2,scrolltop+fheight,fg1);
        if(scrolltop>topfloatline) scrolltop-=4;
        strcpy(passw,"The password is: ");
        strcat(passw,passwords[game_level-2]);
      } else strcpy(passw,"");
     }

     //draw it all to the screen and update logo if required
     if(game_level>LAST_LEVEL) {
      textprintf_centre(gbuffer,font,SCREEN_W/2,SCREEN_H-fheight,fg1,"%s press SPACE To Complete The Game",passw);
     } else {
      textprintf_centre(gbuffer,font,SCREEN_W/2,SCREEN_H-fheight,fg1,"%s press SPACE To Start Level %d of %d",passw,game_level,LAST_LEVEL);
     }
    }

    //update players if necessary
    if(CSprite::first!=NULL) {
      //must be death-match
      item=CSprite::first;
      CSprite::NextFrame();
      rest(10);
      playerDraw(&idummy,cdummy);
    }


    blit(gbuffer,screen,0,0,0,0,gbuffer->w,gbuffer->h);
    if(retrace_count%20==0) imageoffset++; //no need for anything special in the pause
    if(imageoffset>2) imageoffset=0;
 }

 //if finished game, show end sequence
 if(game_level>LAST_LEVEL && (player_level==1 && computer_level==0)) {
   //do ending sequence
   endsequence();
   exit=TRUE;
 }

 clear_keybuf();
 return exit;
}

void set_passwordlevel(char* pwd)
{
 game_level=1; //default
 if(strcmp(pwd,passwords[0])==0) game_level=2;
 if(strcmp(pwd,passwords[1])==0) game_level=3;
 if(strcmp(pwd,passwords[2])==0) game_level=4;
 if(strcmp(pwd,passwords[3])==0) game_level=5;
 if(strcmp(pwd,passwords[4])==0) game_level=6;
 if(strcmp(pwd,passwords[5])==0) game_level=7;
 if(strcmp(pwd,passwords[6])==0) game_level=8;
 if(strcmp(pwd,passwords[7])==0) game_level=9;
 if(strcmp(pwd,"retrospec")==0) {
   //cheat mode
	acquire_screen();
   PALETTE tmp;
   cheatmode=TRUE;
   RGB* myrgb;
   for(int i=0;i<256;i++) { myrgb=pal_logo+i; tmp[i]=(*myrgb); }
   set_palette(tmp);
   {for(int i=0;i<63;i++) {
      vsync();
      if(i<63) {tmp[i].r=63-i; tmp[i].g=63-i;tmp[i].b=63-i;set_color(i,&tmp[0]);}
   }}
   set_palette(pal_logo);
   release_screen();
 }
}

int gamequit()
{
 int validkey=FALSE;
 int userkey;

 clear_keybuf();
 transmsgbox(screen,SCREEN_W,SCREEN_H,"","Are you sure you wish to quit [y/n]?",fg3,fgdark);
 while(validkey==FALSE) {
   userkey=readkey() & 0xff;
   if(userkey=='y' || userkey=='n') validkey=TRUE;
 }
 clear_keybuf();
 game_time=1; //reset interrrupt
 return (userkey=='y');
}

void gamepause()
{
 clear_keybuf();
 transmsgbox(screen,SCREEN_W,SCREEN_H,"Paused","press SPACE to continue",fg3,fgdark);
 waitF7();
 game_time=1; //reset interrupt timer
}

void gamehelp()
{
 clear_keybuf();
 transmsgbox(screen,SCREEN_W,SCREEN_H,"F2 FPS; F3 Auto FPS; F4 Save Screen as BMP; F5 Pause; F6 Player Number On/Off","press SPACE to continue",fg3,fgdark);
 waitF7();
 transmsgbox(screen,SCREEN_W,SCREEN_H,"F8 Music On/Off;  F9 Sound On/Off;  F10 Boss Key  (quick exit with no checks)","press SPACE to continue",fg3,fgdark);
 waitF7();
 transmsgbox(screen,SCREEN_W,SCREEN_H,"Keys (Left,Right,Jump,Action):  P1 - Cursors; P2 - ZXQA; P3 - NMUJ; P4 - 1352","press SPACE to continue",fg3,fgdark);
 waitF7();
 transmsgbox(screen,SCREEN_W,SCREEN_H,"Action Key: Enter Safe Zone if it is not full and player has safes available ","press SPACE to continue",fg3,fgdark);
 waitF7();
 transmsgbox(screen,SCREEN_W,SCREEN_H,"Action Key: If in Safe Zone will unleash fireballs if has fireballs available","press SPACE to continue",fg3,fgdark);
 waitF7();

 game_time=1; //reset interrupt timer
}

void endsequence()
{
 //piss-poor end sequence as haven't got time
 const int INDEX=127; //colour to change - i.e. black to red
 BITMAP* safc=(BITMAP*)dat_main[LEVEND1_BMP].dat;
 BITMAP* man=(BITMAP*)dat_main[SK_STND2_BMP].dat;
 BITMAP* bigman=create_bitmap(man->w*2,man->h*2);
 clear(bigman);
 RGB oldindex;
 RGB black={0,0,0};

 get_color(INDEX,&oldindex);

 fade_out(10);
 clear(screen);
 set_palette((RGB*)dat_main[PALMAIN_BMP].dat);
 //index of player black is actually 4;0;0
 //so change to jet black before continuing
 vsync();
 set_color(INDEX,&black);

 //draw title and initial man
 blit(safc,screen,0,0,SCREEN_W/2-safc->w/2,10,safc->w,safc->h);
 blit(man,bigman,0,0,bigman->w/2-man->w/2,bigman->h-man->h,man->w,man->h);
 blit(bigman,screen,0,0,SCREEN_W/2-bigman->w/2,200,bigman->w,bigman->h);

 //make him big and strong ;)
 textout_centre(screen,font,"You have become even bigger and stronger...",SCREEN_W/2,300,fg1);
 rest(4000);
 for(int i=0;i<man->w;i++) {
    clear(bigman);
    stretch_blit(man,bigman,0,0,man->w,man->h,(bigman->w/2-(man->w+i)/2),bigman->h-man->h-i,man->w+i,man->h+i);
    blit(bigman,screen,0,0,SCREEN_W/2-bigman->w/2,200,bigman->w,bigman->h);
    rest(30);
 }

 //change from black to red
 textout_centre(screen,font,"Your blood is now red; you are vibrant not dead.  A Mackem.",SCREEN_W/2,310,fg1);
 rest(4000);
 {for(int i=0;i<64;i++) {
    vsync();
    set_color(INDEX,&black); //bit of a poor name really
    rest(8);
    black.r++;
 }}

 textout_centre(screen,font,"The transformation is complete.  Well Done. press SPACE to live as a proud Mackem.",SCREEN_W/2,320,fg1);
 waitF7();

 //return palette colour back
 clear(screen);
 vsync();
 set_color(INDEX,&oldindex);
}

void transmsgbox(BITMAP* bmp, int w,int h,char* line1,char* line2, int transcolour, int forecolour)
{
 //passing in width/height in case we are passing in screen
 //and we need screen not virtual size
 int tlen1, tlen2,tlen3;
 tlen1=strlen(line1)*text_length(font,"A");  //fixed point font always
 tlen2=strlen(line2)*text_length(font,"A");
 tlen3=(tlen1>tlen2) ? tlen1 : tlen2;

 BITMAP* tmp=create_bitmap(tlen3,text_height(font)*6);

 clear_to_color(tmp,transcolour);
 textout_centre(tmp,font,line1,tmp->w/2,text_height(font),forecolour);
 textout_centre(tmp,font,line2,tmp->w/2,text_height(font)*3,forecolour);
 draw_trans_sprite(bmp,tmp,w/2-(tmp->w/2),h/2-(tmp->h/2));
 destroy_bitmap(tmp);
}

void waitF7()
{
 clear_keybuf();
 while(readkey()>>8 !=KEY_SPACE);

}


void unleashfireball(int level, int id)
{
 //player already in safety zone and so wishes to unleash the bomb
 //simultaneous creation on levels above and current
 CHazard* newhaz;
 //int i=level;
 for(int i=0;i<=level;i++) {
    newhaz=new CHazard;
    CHazard::Add(newhaz, i*639+1, ((FRAME_GAP_PIXELS_FRAME+difficulty_level)/animation_level)*3, \
                 fireball[0]*animation_level, \
                 fireball, \
                 ((BITMAP*)dat_main[fireball[1]].dat)->w,((BITMAP*)dat_main[fireball[1]].dat)->h,id+i,FIREBALL);
    //play fireballs for however many at top priority
    //attempt to sweep it from left to right
 }
 playfireball(level);
}


void playfireball(int level)
{
 int ret;
 //play fireball sample starting from left
 if(dat_music!=NULL) {
   //make it louder the more there is to show
   myGame.killdigi();
   ret=myGame.playdigi((SAMPLE*)dat_music[FIREBALL_WAV].dat,LOUD,HIGH,0,1000+(level*500),FALSE);
   //attempt to play it sweepint to right finishing when it finishes
   myGame.pansweep(ret,(FRAME_SCREEN_FRAMES/FRAME_FPS_TARGET),255);
 }
}

void GazzaPlay()
{
 //play the thieving magpie by rossinni
 if(dat_music!=NULL) myGame.playmidi((MIDI*)dat_music[GAZZA_MID].dat,TRUE,QUIET);
}

//play a sample
//only play if dat file available
//extra layer as the allegro class should not know about such things
int playsample(int samplenum,EDIGIPRIORITY prior,EVOLUME vol)
{
 if(dat_music!=NULL) return myGame.playdigi((SAMPLE*)dat_music[samplenum].dat,vol,prior,FALSE);
 else return -1;
}

void game_loop()
{
	
	int choice=0;
	int keypress;
	int xoff;
	int c=0;      //text scrolly thing
	int text_pix=0;
	int text_width=0;
	int text_char=0xffff;
	char buf[2]=" ";
	char d_level[256];
	char s_level[256];
	char m_level[256];
	char a_level[256];
	char p_level[256];
	char c_level[256];
	
	BITMAP* buffer=NULL;
	BITMAP* logo;  //repeat of game
	BITMAP* scrolly;
	BITMAP* scorecard;
	char* law1;
	char* law2;
	
	LOCK_VARIABLE(game_time);
	LOCK_FUNCTION(game_timer);
	
	int bx,by,bw,bh;
	int textxgap=10;
	int textygap=10+text_height(font);
	int redraw_req;
	int restart=TRUE;
	int newscroll=TRUE;
	int songoffset=rand()%(4);    //random number 0 to 3 - songs must be sequential
	char passwd[11]="";
	int passwd_input=FALSE;
	int menulevel=0;       //0 main, 1 setup
	
	
	//set colour depth and transparent text mode
	text_mode(-1);
	//open main datafiles
	dat_main=dat_safc=dat_music=NULL;
	
	myGame.datload(&dat_main,MAINDAT_FILE,TRUE);
	
	if (extradat==TRUE) myGame.datload(&dat_safc,SAFCDAT_FILE,FALSE);
	if (musicdat==TRUE) myGame.datload(&dat_music,MUSICDAT_FILE,FALSE);
	if(dat_safc==NULL) {extradat=FALSE; spec_level=SPEC_NONE;}
	if(dat_music==NULL) {music_level=MUSIC_NONE; myGame.noMusic(); myGame.noDigi();}
	
	//set correct palette and set playing flags
	//set bitmaps for options screen
	
	if(dat_main==NULL) myGame.abortsystem("Data file could not be found.");
	
	logo=(BITMAP*)dat_main[LOGO_NEW_BMP].dat;
	pal_logo=(RGB*)dat_main[LOGO_BMP].dat;
	scorecard=(BITMAP*)dat_main[SCORE_BMP].dat;
	set_palette(pal_logo);
	
	//get copyright stuff
	law1=(char*)malloc(sizeof(char)*dat_main[LAW_TXT].size);
	law2=(char*)malloc(sizeof(char)*dat_main[LAW2_TXT].size);
	if(law1!=NULL && law2!=NULL) {
		strncpy(law1,(char*)dat_main[LAW_TXT].dat,dat_main[LAW_TXT].size);
		strncpy(law2,(char*)dat_main[LAW2_TXT].dat,dat_main[LAW2_TXT].size);
		law1[dat_main[LAW_TXT].size-1]=0;
		law2[dat_main[LAW2_TXT].size-1]=0;
	}
	
	if(logo_shown) redraw_req=FALSE; else redraw_req=TRUE;
	scrolly=create_bitmap(SCREEN_W,text_height(font));
	clear(scrolly);
	road=create_bitmap(((BITMAP*)dat_main[HAZROAD_BMP].dat)->w,((BITMAP*)dat_main[HAZROAD_BMP].dat)->h);
	
	leftmostpos=((BITMAP*)(dat_main[SK_DUGEM_BMP].dat))->w;
	//main options loop
	//loops at beginning and after a redraw is required
	
	GazzaPlay();
	do {	
	do {
		//display main option screen
		//draw logo to left,heading to top, flag to bottom right
		//draw options to right - in buffer space
		set_palette(pal_logo);
		clear_keybuf();
		if(redraw_req==TRUE) {
			clear(screen);
			//set_palette(*pal_logo);
			clear(scrolly);
		}
		
		//setup positions
		xoff=position_logo(screen,logo,redraw_req);
		//heading and flag
		blit(scorecard,screen,0,0,SCREEN_W/2-(scorecard->w/2),text_height(font),scorecard->w,scorecard->h);
		//assumes game_quit is the last one
		bx=textxgap+xoff+logo->w;
		by=SCREEN_H/2-(logo->h/2);
		bw=SVGA_W-bx;
		bh=logo->h;
		
		//screen space for menu display
		if(buffer==NULL) buffer=create_sub_bitmap(screen,bx,by,bw,bh);
		
		//output menu options
		clear(buffer);
		int textystart=(buffer->h)/2-((textygap*GAME1_QUIT)/2);
		
		//setup menu dependant upon level
		if(menulevel==0) {
			//main
			//play
			textprintf(buffer,font,textxgap,textystart,fg1,"0 Play: ");
			if(game_level==1)    textprintf(buffer,font,textxgap+text_length(font,   "0 Play:                  "),textystart,fg2,"Starting Level");
			else                 textprintf(buffer,font,textxgap+text_length(font,   "0 Play:                  "),textystart,fg2,"Level %d",game_level);
			
			//players
			player_string(p_level);
			textprintf(buffer,font,textxgap,textystart+(textygap),fg1,               "1 Human Players:         ");
			textprintf(buffer,font,textxgap+text_length(font,                        "1 Human Players:         "),textystart+(textygap),fg2,"%s",p_level);
			//computers
			computer_string(c_level);
			textprintf(buffer,font,textxgap,textystart+(textygap*2),fg1,"2 More Computer Players");
			textprintf(buffer,font,textxgap,textystart+(textygap*3)-(textygap/2),fg1,"3 Less Computer Players: ");
			textprintf(buffer,font,textxgap+text_length(font,           "2 Less Computer Players: "),textystart+(textygap*3)-(textygap/2),fg2,"%s",c_level);
			
			//get difficulty flag
			difficulty_string(d_level);
			textprintf(buffer,font,textxgap,textystart+(textygap*4),fg1,"4 Difficulty:            ");
			textprintf(buffer,font,textxgap+text_length(font,           "4 Difficulty:            "),textystart+(textygap*4),fg2,"%s",d_level);
			
			//password for level
			if(passwd_input) {
				textprintf(buffer,font,textxgap,textystart+(textygap*5),fg1,"5 Password:              ");
				textprintf(buffer,font,textxgap+text_length(font,           "7 Password:              "),textystart+(textygap*5),fg2,"[%10s]",passwd);
			} else {
				if(player_level==1 && computer_level==0)
					textprintf(buffer,font,textxgap,textystart+(textygap*5),fg1,"5 Level");
				else
					textprintf(buffer,font,textxgap,textystart+(textygap*5),fg1,"5 Death-Match Level");
			}
			
			//instructions
			textprintf(buffer,font,textxgap,textystart+(textygap*6),fg1,"6 Instructions");
			//credits
			textprintf(buffer,font,textxgap,textystart+(textygap*7),fg1,"7 Credits");
			
			//setup
			textprintf(buffer,font,textxgap,textystart+(textygap*8),fg1,"8 Setup");
			
			//quit
			textprintf(buffer,font,textxgap,textystart+(textygap*9),fg1,"9 Quit");
			
		} else {
			//setup level
			//get spec level
			spec_string(s_level);
			textprintf(buffer,font,textxgap,textystart,fg1,"0 Backdrops: ");
			textprintf(buffer,font,textxgap+text_length(font,"0 Backdrops: "),textystart,fg2,"%s",s_level);
			
			//get music level
			music_string(m_level);
			textprintf(buffer,font,textxgap,textystart+(textygap),fg1,"1 Music: ");
			textprintf(buffer,font,textxgap+text_length(font,"1 Music: "),textystart+(textygap),fg2,"%s",m_level);
			
			//get animation smoothness level
			animation_string(a_level);
			textprintf(buffer,font,textxgap,textystart+(textygap*2),fg1,"2 Animation: ");
			textprintf(buffer,font,textxgap+text_length(font,"2 Animation: "),textystart+(textygap*2),fg2,"%s",a_level);
			
			//return
			textprintf(buffer,font,textxgap,textystart+(textygap*4),fg1,"9 Return");
			
		}
		if(law1!=NULL && law2!=NULL) {
			textout_centre(screen,font,law1,SCREEN_W/2,SCREEN_H-(text_height(font)*2),fg2);
			textout_centre(screen,font,law2,SCREEN_W/2,SCREEN_H-text_height(font),fg2);
		}
		
		//if keypressed check which option, otherwise scroll scoreboard songs
		do {
			//main processing loop while no keys are being pressed
			restart=TRUE;  //signify that inner loop ends now
			newscroll=FALSE;
			if(keypressed()) {
				keypress=readkey();
				
				//totally ignoring the GAME_* options!
				if(menulevel==0) {
					if(!passwd_input) {
						switch(keypress>>8) {
						case KEY_0: //play
							play_game();
							//redraw screen and scroll
							redraw_req=TRUE;
							newscroll=TRUE;
							break;
						case KEY_1: //player select
							playerset();
							redraw_req=FALSE;
							break;
						case KEY_2: //computer select
							computerset(1);
							redraw_req=FALSE;
							break;
						case KEY_3:
							computerset(-1);
							redraw_req=FALSE;
							break;
						case KEY_4: //difficulty
							difficulty();
							//no need to restart scroller or the screen as
							//just key presses are processsed
							redraw_req=FALSE;
							break;
						case KEY_5: //password level
							//start a new password
							if(player_level!=1 || computer_level!=0) {
								//deathmatch so set level
								game_level++;
								if(game_level>LAST_LEVEL) game_level=1;
							} else {
								for(int i=0;i<11;i++) *(passwd+i)=0;
								game_level=1;
								//dont redraw screen or scroller as only keys are processed
								redraw_req=FALSE;
								if(passwd_input==FALSE) passwd_input=TRUE;
							}
							break;
						case KEY_6: //instructions
							//clear scroll first as don't want to put scroll in a timer
							//and easiest way to make it work
							clear(scrolly);
							blit(scrolly, screen, 0, 0, 0,0,scrolly->w,scrolly->h);
							instructions(buffer);
							//don't redraw screen as nothing changed, restart scroller
							redraw_req=FALSE;
							newscroll=TRUE;
							break;
						case KEY_7: //credits
							//see instructions for this
							clear(scrolly);
							blit(scrolly, screen, 0, 0, 0,0,scrolly->w,scrolly->h);
							credits(buffer);
							//see instructions for this
							redraw_req=FALSE;
							newscroll=TRUE;
							break;
						case KEY_8:  //setup menu
							redraw_req=FALSE;
							menulevel=1;
							break;
						case KEY_9:
							//refer to difficulty
							choice=quit();    //ask first, returns -1 if quit
							redraw_req=FALSE;
							break;
						default:
							restart=FALSE;
						}
					} else {
						//inputting new password level
						//populate string, Enter to exit mode
						if(key[KEY_ENTER]) {
							//process password
							passwd_input=FALSE;
							//changelevel
							set_passwordlevel(passwd);
						} else {
							if(key[KEY_BACKSPACE]) {
								if(strlen(passwd)>0) {
									passwd[strlen(passwd)-1]=0;
									clear_keybuf();
								}
							} else {
								char keyp=keypress&0xff;
								if(keyp>='a' && keyp <='z') {
									int len=strlen(passwd);
									if(len<10) {
										passwd[strlen(passwd)]=keyp;
										passwd[strlen(passwd)+1]=0;
									}
								}
							}
						}
					}
				}
				else {
					//setup menu
					switch(keypress>>8) {
					case KEY_0:  //change game options
						//refer to difficulty
						spec();
						redraw_req=FALSE;
						break;
					case KEY_1:    //change music options
						//refer to difficulty
						music();
						redraw_req=FALSE;
						break;
					case KEY_2:  //animation level
						animation();
						redraw_req=FALSE;
						break;
					case KEY_9:  //return to main
						redraw_req=FALSE;
						menulevel=0;
						break;
					}
				}
			}
			else restart=FALSE;
		}while(restart==FALSE);
	 
	 //if no key is pressed update the scroller
	 //scroller code taken from Shawn Hargreaves Allegro Demo program
	 //slightly modified
	 if(newscroll==TRUE) {
		 c=0;      //text scrolly thing
		 text_pix=0;
		 text_width=0;
		 text_char=0xffff;
		 buf[0]=' ';
		 buf[1]=0;
		 clear(scrolly);
		 newscroll=FALSE;
	 }
	 
	 c++;
	 blit(scrolly, scrolly, c, 0, 0, 0, SCREEN_W, SCREEN_H);
	 rectfill(scrolly, SCREEN_W-c, 0, SCREEN_W, SCREEN_H, 0);
	 while (c > 0) {
		 text_pix += c;
		 textout(scrolly, font, buf, scrolly->w-text_pix, 0, fg2);
		 if (text_pix >= text_width) {
			 c = text_pix - text_width;
			 text_char++;
			 if (text_char >= dat_main[SONG1_TXT+songoffset].size) {
				 songoffset=rand()%(4);    //random number 0 to 3
				 text_char = 0;
			 }
			 buf[0] = ((char *)dat_main[SONG1_TXT+songoffset].dat)[text_char];
			 text_pix = 0;
			 text_width = text_length(font, buf);
		 } else {
			 c = 0;
		 }
		 rest(7); //slow and smooth - just how my wife likes it ;)
		 blit(scrolly, screen, 0, 0, 0,0,scrolly->w,scrolly->h);
	 }
   } while(restart==FALSE); //loop round while no keys are being pressed
   //pinched code ends!
   
 } while(choice!=-1);  //loop round after keys have been pressed
 
 //exit hands control back to main() which will exit nicely
 //destroy local bitmaps
 if(law1!=NULL) free(law1);
 if(law2!=NULL) free(law2);
 destroy_bitmap(buffer);
 destroy_bitmap(scrolly);
 destroy_bitmap(road);
}

