//sprite functions
#include <allegro.h>
#include "jj_main.h"
#include "sh_alleg.h"
#include "sh_sprit.h"
#include "my_sprit.h"
#include "game.h"
#include "jj_music.h"
#include <stdio.h>
#include <string.h>

//these arrays below must match the size where they came from!
//yes I know thats why #defines were created
extern int player[][7];
extern int autogeordie[][7];
extern int levelsafeavailable[8];
extern int playersafe[6];

extern CAllegro myGame;
extern BITMAP* gbuffer;
extern int animation_level;
extern int cheatmode;
extern int gapcount;
extern int game_level;
extern int leftmostpos;
extern int showplayernumber;
extern int autoshownumber;
extern int computersleft;
extern int playersleft;

////
//hazard sprite
CHazard::CHazard()
{
 //not really needed as set by add
 position=0;
 type=HAZARD;
 //constructor for sprite sets up rest first
}

void CHazard::Add(CHazard* haz, int pos, int movei, int anif, int*animseq, int width,int height,int num, ESPRITE type)
{

 haz->position=pos;
 CSprite::Add(haz,movei,anif,animseq,width,height,num,type);

}


void CHazard::xyToPos(int x, int y, int* pos)
//static
{
 //convert row/col to position
 //rows are 0 to 6
 //cols are 0 to 639
 //MAXPOS is 7*639
 *pos=y*639+x;
}

void CHazard::PosToxy(int pos, int*x, int*y)
//static inline
{
 //refer to xytopos
 if(pos<=639) {
   if(pos<0) {*x=0;*y=-1;}
   else {*x=pos; *y=0;}
 }
 else {
   *x=pos%639;
   *y=(pos-(pos%639))/639;
 }
}

void CHazard::Move(int notwaiting,int flag)
{
 //only process if waiting
 if(notwaiting==FALSE) return;

 switch(type) {
   case HAZARD:
        MoveLeft(0,MAXPOS);
        break;
   case POPPINS:
        MoveRight(0,MAXPOS);
        break;
   case FIREBALL:
        //move it and kill it if at end of level
        int x,y,y1;
        PosToxy(position,&x,&y);
        MoveRight(0,MAXPOS);
        PosToxy(position,&x,&y1);
        if(y!=y1 || x>600) flagdelete=TRUE;
        break;
   default:
        break;
 }
}

void CHazard::MoveLeft(int min, int max)
{
 //called only by nextframe or as an override to move hazard straight away
 position-=moveinc;         //hazards always move left
 if(position<min) {
   position=max;      //wrap from top to bottom
   //waiting=random()%(FRAME_HAZ_WAIT_MAX*animation_level); //wait upto a second
   waiting=rand()%(FRAME_HAZ_WAIT_MAX*animation_level); //wait upto a second - change for win
 }
}

void CHazard::MoveRight(int min, int max)
{
 //called only by nextframe or as an override to move hazard straight away
 position+=moveinc;         //hazards always move left except Poppins
 if(position>max) {
   position=min;      //wrap from bottom to top
   //waiting=random()%(FRAME_HAZ_WAIT_MAX*animation_level);
   waiting=rand()%(FRAME_HAZ_WAIT_MAX*animation_level); //change for win
 }
}

////
//gap override
////
void CGap::Move(int notwaiting,int flag)
{
 if(notwaiting==FALSE) return;

 switch(gapdirection) {
   case GAP_LEFT:
        MoveLeft();
        break;
   case GAP_RIGHT:
        MoveRight();
        break;
   case GAP_RANDOM:
        //only random until direction is set
        //if(random()%100 >49) {gapdirection=GAP_LEFT; MoveLeft(); }
	   if(rand()%100 >49) {gapdirection=GAP_LEFT; MoveLeft(); } //change for win
        else { gapdirection=GAP_RIGHT; MoveRight(); }
        break;
 }
}

////
//player override
//

//human
CPlayer::CPlayer(int left,int right, int jump1, int jump2,char* name)
{
 //constructor
 kleft=left;
 kright=right;
 kjump1=jump1;
 kjump2=jump2;
 direction=PM_STILL;
 vertical=0;
 score=0;
 insafe=FALSE;
 lives=MAX_LIVES_NORMAL;
 deadasageordie=FALSE;
 strcpy(playername,name);
 movementoverride=PM_STILL;
 defaultdirection=PM_STILL;
 singlevoice=-1;
}

//computer
CPlayer::CPlayer(char* name)
{
 direction=PM_STILL;
 vertical=0;
 strcpy(playername,name);
 score=0;//not really needed
 deadasageordie=FALSE;
 lives=MAX_LIVES_NORMAL;
 movementoverride=PM_STILL;
 defaultposition=640/2;
 insafe=FALSE;
 singlevoice=-1;

 //set default direction for computer
 //mainly standing still but 2 out of 6 stand still; 2:6 are fixed; 1:6 left; 1:6 right
 int num;
 //num=random()%6;
 num=rand()%6; //change for win
 if(num<2) defaultdirection=PM_STILL;
  if(num>1) defaultdirection=PM_FIXED;
 if(num==4) defaultdirection=PM_LEFT;
 if(num==5) defaultdirection=PM_RIGHT;
}

void CPlayer::Move(int notwaiting,int forcedirection)
{
 //player can't move or do anything if waiting
 //except drop down a hole - extra collisions are ignored
 //if keyforce they move as instructed if allowed
 EPLAYER olddirection=direction;

 if(notwaiting==TRUE && deadasageordie==FALSE) {
  direction=PM_STILL;    //default to standing still looking cool
  int x,y;
  PosToxy(position,&x,&y);
  //process user movement only if not waiting
  //only allow movement if not in safety zone - right moves out
  //priority is highest for last check, in theory
  if(vertical==0) {
     //check keypresses
     if(type==MAN) {
      if(key[kleft] && insafe==FALSE) {
        direction=PM_LEFT;
        autoshownumber=FALSE;
      }
      if(key[kright]) {
        autoshownumber=FALSE;
        direction=PM_RIGHT;
        if(insafe==TRUE) {
          levelsafeavailable[y]=TRUE;
          //moving out so put player outside of box
          xyToPos(leftmostpos-(width/2),y,&position);
          insafe=FALSE;
        }
      }
      //kjump2 is safety move then fire if safe - only if not moving
      if(key[kjump1] && insafe==FALSE) {
        //stop the single voice sound
        direction=PM_JUMP;
        autoshownumber=FALSE;
      }
      if(key[kjump2] && olddirection==PM_STILL) {
        if(insafe==FALSE && levelsafeavailable[y] && y<7 && safes>0) {
          //players entering safety zone
          ::playsample(SAFE_WAV,NORMAL,MEDIUMQUIET);
          autoshownumber=FALSE;
          insafe=TRUE;
          levelsafeavailable[y]=FALSE;
          safes--;
          animseq=playersafe; //set sequence pointer
          //adjust for FPS
          animateframes=playersafe[0]*animation_level;
          currentframe=0; //reset straight away
          shownsprite=1;            //set starting sprite
          xyToPos(1,y,&position);
          waiting=30*animation_level; //quick pause to ensure don't setoff fireball
        } else {
          if(insafe==TRUE && bombs>0) {
            ::unleashfireball(y,num<<8);
            waiting=30*animation_level; //quick pause to ensure don't press it more than once by mistake
            bombs--;
          } else {
            if(insafe==TRUE && bombs<=0) ::playsample(CLICK_WAV,NORMAL,MEDIUMQUIET);
          }
        }
      }
     }

     //if forced move (e.g. for demo or computer move)
     if(movementoverride!=PM_STILL) {
       direction=movementoverride;
     }
   } else {
    //we are in the air till the end or hit
    direction=olddirection; //falling or jumping
   }
 }


 //check for collision
 ESPRITE sp;
 int colpos;
 //only check if any kind of collision first
 if(Collision(&sp,&colpos)==TRUE) {
   //if hit poppins or a hazard then fall
   if((sp==HAZARD || sp==POPPINS || sp==FIREBALL) && notwaiting==TRUE) {
     if(cheatmode==FALSE || type==COMPUTER) {
       direction=PM_FALLHIT;         //when hit always fall as when 0 turns to hit
       myGame.stopdigi(singlevoice);
       //if(sp==FIREBALL) singlevoice= ::playsample(SCREAM1_WAV+random()%3,NORMAL,MEDIUM);
       if(sp==FIREBALL) singlevoice= ::playsample(SCREAM1_WAV+rand()%3,NORMAL,MEDIUM); //change for win
       else singlevoice= ::playsample(HIT_WAV,NORMAL,MEDIUM);
     }
   }
   else {
      //if hit a gap then if not in the air we are falling
      //if in the air ignore
     //only check when waiting if hit
     if(notwaiting==TRUE || (notwaiting==FALSE && direction==PM_HIT)) {
     if(sp==GAP) {
       if(vertical==0) {
         position+=639;
         direction=PM_FALLGAP;
         myGame.stopdigi(singlevoice);
         singlevoice= ::playsample(FALL_WAV,LOW,MEDIUM);
         vertical=PLATFORM_WIDTH+PLATFORM_SPACE;
       }
     }}
   }
 } else {
   //if not hit and in the air check if hit roof
   //some kind of bug here as cannot seem to make user
   //get on platform after jumping through a gap, hence comment below
   if(vertical>(PLATFORM_SPACE-height) && notwaiting==TRUE) {
     direction=PM_FALLGAP; //original JJ should really be HIT time but we are being nice
     myGame.stopdigi(singlevoice);
     singlevoice= ::playsample(FALL_WAV,LOW,MEDIUM);
   }
 }

 //to reset dead if changed by above
 if(deadasageordie) direction=PM_DEAD;

 switch(direction) {
   //for each direction
   //set animation pointer if new type, otherwise just move
   //move if required (newframe controls movement)
   case PM_STILL:
        break;
   case PM_LEFT:
        MoveLeft();
        break;
   case PM_RIGHT:
        MoveRight();
        break;
   case PM_JUMP:
        MoveVertical();
        break;
   case PM_FALLGAP:
   case PM_FALLHIT:
        MoveVertical();
        if(vertical==0) {
          if(direction==PM_FALLHIT) waiting=FRAME_ROOF_HIT; //hit a hazard or roof
          else waiting=FRAME_ROOF_FALL; //shorter dizziness

          direction=PM_HIT;
          int x1,y1;
          PosToxy(position,&x1,&y1);
          if(y1==7) lives--;
        }
        break;
   case PM_HIT:
        //change to still if not hit anymore
        if(waiting==0) {
          direction=PM_STILL;
        }
        break;
   default:
        break;
 }
 //}
 //set animation back to start if new direction
 if(notwaiting==TRUE || deadasageordie==TRUE) {
   if(olddirection!=direction) {
     if(type==MAN) animseq=player[direction]; //set sequence pointer
     else animseq=autogeordie[direction];

     //adjust for FPS
     if(type==MAN) animateframes=player[direction][0]*animation_level;
     else animateframes=autogeordie[direction][0]*animation_level;

     currentframe=0; //reset straight away
     shownsprite=1;            //set starting sprite
   }

 }
 if(direction==PM_STILL) {
   //cough if random - more if more players
   //if(random()%(1200-computersleft-playersleft)==69) {
	 if(rand()%(1200-computersleft-playersleft)==69) { //change for win
     myGame.stopdigi(singlevoice);
     //singlevoice= ::playsample(COUGH1_WAV+random()%3,LOW,QUIET);
     singlevoice= ::playsample(COUGH1_WAV+rand()%3,LOW,QUIET); //change for win
   }
 }
}
void CPlayer::MoveLeft()
{
 //called only by nextframe or as an override to move hazard straight away
 int x1,y1,x2,y2;
 //if on new level put back to right of level as moving left
 PosToxy(position,&x1,&y1); //current
 position-=moveinc;         //move left
 PosToxy(position,&x2,&y2); //new

 //move to right if at edge of left
 //edge is in safety zone or edge of screen if bottom layer
 if((y1==7 && y1!=y2) || (y1!=7 && x2+(width/2)<leftmostpos))
   xyToPos(635,y1,&position);
}

void CPlayer::MoveRight()
{
 //called only by nextframe or as an override to move hazard straight away
 int x1,y1,x2,y2;

 //if on new level put back to left of level as moving right
 PosToxy(position,&x1,&y1); //current
 position+=moveinc;         //move left
 PosToxy(position,&x2,&y2); //new

 //move to left if at edge of left
 //edge is in safety zone or edge of screen if bottom layer
 if(y1==7 && y1!=y2) xyToPos(1,y1,&position);
 else if(y1!=7 && y1!=y2) xyToPos(leftmostpos-(width/2),y1,&position);
}

void CPlayer::MoveVertical()
{
 static int veloc=1;
 static int adjustanimation=animation_level; //adjust upwards movement if faster FPS

 //jump or fall
 if(direction==PM_JUMP) {
   //jumping not yet collision
   //only one position
   //movement is normally x pixels per frame
   //but if upping speed (e.g. double frame rate)
   //then only update jump if offset is zero
   if(vertical==0) {
     myGame.stopdigi(singlevoice);
     singlevoice= ::playsample(JUMP_WAV,LOW,MEDIUM);
   }

   adjustanimation--;
   if(adjustanimation<=0) {
     //startjump noise
     myGame.stopdigi(singlevoice);
     vertical+=veloc;
     veloc+=1;
     adjustanimation=animation_level;
   }
   if(vertical>=PLATFORM_SPACE+PLATFORM_WIDTH) {
     //new level safely
     //check for end of level?
     veloc=1;
     vertical=0;
     position-=639;
     waiting=(FRAME_FPS_TARGET*animation_level)/4; //quarter a second to let gap get past just enough if in the right place
     direction=PM_STILL;
     score+=(gapcount*game_level);
     if(type==MAN || type==COMPUTER) {
       //add gap if man
       //add 1 if one player
       //otherwise random if more to not get too many gaps
       //dont take into account dead players
       if(gettypecount(MAN)+gettypecount(COMPUTER)==1) ::addGap(GAP_RANDOM,&gapcount); //only add gaps when players jump
       else {
         //increase only for human players unless only computers left
         //does not take into account dead ones as that is player advantage
         //if(random()%(gettypecount(MAN)+gettypecount(COMPUTER))==((gettypecount(MAN)+gettypecount(COMPUTER))-1)) ::addGap(GAP_RANDOM,&gapcount);
         if(rand()%(gettypecount(MAN)+gettypecount(COMPUTER))==((gettypecount(MAN)+gettypecount(COMPUTER))-1)) ::addGap(GAP_RANDOM,&gapcount); //change for win
       }
     }
   }
 } else {
   //falling
   vertical-=veloc;
   veloc+=1;
   if(vertical<=0) {
     //hit the floor
     veloc=1;
     vertical=0;
     //main move sets hit
   }
 }
}

//check collision of player with all hazards
int CPlayer::Collision(ESPRITE* sp,int* pos)
{
 //return value is TRUE for collision
 //sp is sprite type collided with

 //x,y is bottom left
 //vert is how many off the floor
 //only using boundbox check, no need really for pixel-perfect
 CSprite* item=first;
 *pos=0;
 int cx,cy;
 int x,y;
 int compensateval=0;
 PosToxy(position,&x,&y);
 //loop all hazards
 while(item) {
  //dont bother checking yourself
  //collision with other players is ignored too
  //as is if in safe zone
  if(num!=item->num && item->type!=COMPUTER && item->type!=MAN && insafe==FALSE) {
   *sp=item->type;  //only valid and checked if a collision
   //convert to x,y co-ordinates for easy handling
     //check if valid check
     PosToxy(((CHazard*)item)->position,&cx,&cy);
     //only check if on same level
     //gaps are a special case because a level is the space and the
     //platform above so need to compensate for this
     //if jumping then cant hit one below so don't compensate
     //if no jumping then cant hit one above so compensate
     if(item->type==GAP && vertical==0) { compensateval=639;cy--;}; //gap compensation
     if(cy==y) {
       //assumes sprite will change y as soon as top of head changes level
       //or feet changes level
       //match if within bounds of hazard
       if((cx>=x && cx<x+width) || (cx<x && cx+item->width>x)) {
         //collision
         //but first check vertical (i.e. if jumping)
         //does not matter about gaps
         //as once falling, you cannot stop
         if(item->type!=GAP) *pos=((CHazard*)item)->position; //set position of collided sprite
         else *pos=((CHazard*)item)->position-compensateval; //gap compensation (see above)

         if(vertical==0) {
           //if on platform (not in air) then collision if hazard
           //or collion with gap only if within tolerance - same as below
           if(item->type==GAP ) {
             if(x>=cx+((item->width)/6) && x<=cx+item->width-((item->width)/8)) return TRUE;
           } else
           //rectfill(screen,x,y*60,x+width,60*y+height,0);
           //rectfill(screen,cx,cy*60,x+item->width,60*cy+item->height,254);
           return TRUE; //assumes 0 is walking
          }
         else if(vertical<=item->height || item->type==GAP) {
           //only allow jumping if within tolerance - same as above
           //as gap is 3D
           if(x>=cx+((item->width)/6) && x<=cx+item->width-((item->width)/8)){
           //rectfill(screen,x,y*60,x+width,y+height,0);
           //rectfill(screen,cx,cy*60,x+item->width,60*cy+item->height,255);
           return TRUE;}
         } //if jumping and is less than height of hazard then collision
        }
     }
  }
  item=item->next; //get next one
 }
 return FALSE;
}

void CPlayer::dead()
{
 deadasageordie=TRUE;
 myGame.stopdigi(singlevoice);
 if(type==COMPUTER) {
   //if(random()%2==1) ::playsample(DEAD1_WAV,NORMAL,MEDIUM);
   if(rand()%2==1) ::playsample(DEAD1_WAV,NORMAL,MEDIUM); //change for win
   else ::playsample(DEAD2_WAV,NORMAL,MEDIUM);
 }
 else ::playsample(DEAD3_WAV,NORMAL,MEDIUM);
}

int CPlayer::isdead()
{
 return deadasageordie;
}

