/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.campaign;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.campaign.CampUnitSelectionControl;
import com.scs.stellarforces.start.CurrentGameDetailsModule;
import com.scs.stellarforces.start.equip.GetEquipmentDataModule;
import dsr.comms.AbstractCommFuncs;
import dsr.comms.DataTable;
import dsr.comms.WGet_SF;
import dsr.data.GameData;
import java.io.IOException;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.ConfirmModule;
import ssmith.android.framework.modules.SimpleScrollingAbstractModule;
import ssmith.android.lib2d.Spatial;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.gui.CheckBox;
import ssmith.android.lib2d.gui.ToggleButton;
import ssmith.android.lib2d.layouts.HorizontalFlowGridLayout;
import ssmith.android.lib2d.layouts.VerticalFlowLayout;
import ssmith.util.Browser;

public class SelectCampaignSquadModule
extends SimpleScrollingAbstractModule {
    private static final String CONFIRM_SQUAD = "conf_squad";
    private static final float GAP = (float)Statics.SCREEN_WIDTH * 0.005f;
    private GameData game_data;
    private static Paint paint_normal_text = new Paint();
    private DataTable camp_squad_dt;
    private Button finished;
    private Button finished2;
    private Button game_details;
    private Button mission_file;
    private VerticalFlowLayout vfl;

    static {
        paint_normal_text.setARGB(255, 255, 255, 255);
        paint_normal_text.setAntiAlias(true);
        paint_normal_text.setTextSize(Statics.GetHeightScaled(0.07f));
    }

    public SelectCampaignSquadModule(AbstractActivity act, int _ret, GameData _game_data) {
        block8: {
            super(_ret);
            this.game_data = _game_data;
            this.setBackground("space1.jpg");
            this.showPleaseWait("Getting squad roster...");
            try {
                try {
                    WGet_SF wc = new WGet_SF(act, null, "cmd=get_camp_squad_list&comms_version=" + Statics.COMMS_VERSION + "&login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD));
                    String response = wc.getResponse();
                    if (response != null && response.length() > 0) {
                        if (!response.equalsIgnoreCase("error")) {
                            this.camp_squad_dt = new DataTable(response);
                            break block8;
                        }
                        throw new IOException("Invalid data for campaign squad");
                    }
                    throw new IOException("Invalid data for campaign squad");
                }
                catch (Exception ex) {
                    AbstractActivity.HandleError(ex);
                    this.dismissPleaseWait();
                    return;
                }
            }
            finally {
                this.dismissPleaseWait();
            }
        }
        this.root_node.removeAllChildren();
        this.vfl = new VerticalFlowLayout("vfl", GAP);
        this.finished = new Button("Deploy Selected Units", null, paint_normal_text, Statics.img_cache.getImage("button_green", (float)Statics.SCREEN_WIDTH, Statics.GetStdButtonHeight()));
        this.vfl.attachChild(this.finished);
        HorizontalFlowGridLayout heading = new HorizontalFlowGridLayout("heading", GAP);
        Button tb_unit_name = new Button("Name", null, CampUnitSelectionControl.paint_unit_name, Statics.img_cache.getImage("lumin_green_button2", CampUnitSelectionControl.OVERALL_WIDTH * 0.55f, CampUnitSelectionControl.ARMOUR_ICON_HEIGHT));
        heading.attachChild(tb_unit_name);
        ToggleButton b = new ToggleButton("Hlth", null, null, CampUnitSelectionControl.paint_armour_name, Statics.img_cache.getImage("lumin_green_button2", CampUnitSelectionControl.ARMOUR_ICON_WIDTH, CampUnitSelectionControl.ARMOUR_ICON_HEIGHT), Statics.img_cache.getImage("button_blue_darker", CampUnitSelectionControl.ARMOUR_ICON_WIDTH, CampUnitSelectionControl.ARMOUR_ICON_HEIGHT));
        heading.attachChild(b);
        b = new ToggleButton("APs", null, null, CampUnitSelectionControl.paint_armour_name, Statics.img_cache.getImage("lumin_green_button2", CampUnitSelectionControl.ARMOUR_ICON_WIDTH, CampUnitSelectionControl.ARMOUR_ICON_HEIGHT), Statics.img_cache.getImage("button_blue_darker", CampUnitSelectionControl.ARMOUR_ICON_WIDTH, CampUnitSelectionControl.ARMOUR_ICON_HEIGHT));
        heading.attachChild(b);
        b = new ToggleButton("Shot", null, null, CampUnitSelectionControl.paint_armour_name, Statics.img_cache.getImage("lumin_green_button2", CampUnitSelectionControl.ARMOUR_ICON_WIDTH, CampUnitSelectionControl.ARMOUR_ICON_HEIGHT), Statics.img_cache.getImage("button_blue_darker", CampUnitSelectionControl.ARMOUR_ICON_WIDTH, CampUnitSelectionControl.ARMOUR_ICON_HEIGHT));
        heading.attachChild(b);
        b = new ToggleButton("CC", null, null, CampUnitSelectionControl.paint_armour_name, Statics.img_cache.getImage("lumin_green_button2", CampUnitSelectionControl.ARMOUR_ICON_WIDTH, CampUnitSelectionControl.ARMOUR_ICON_HEIGHT), Statics.img_cache.getImage("button_blue_darker", CampUnitSelectionControl.ARMOUR_ICON_WIDTH, CampUnitSelectionControl.ARMOUR_ICON_HEIGHT));
        heading.attachChild(b);
        b = new ToggleButton("Str", null, null, CampUnitSelectionControl.paint_armour_name, Statics.img_cache.getImage("lumin_green_button2", CampUnitSelectionControl.ARMOUR_ICON_WIDTH, CampUnitSelectionControl.ARMOUR_ICON_HEIGHT), Statics.img_cache.getImage("button_blue_darker", CampUnitSelectionControl.ARMOUR_ICON_WIDTH, CampUnitSelectionControl.ARMOUR_ICON_HEIGHT));
        heading.attachChild(b);
        b = new ToggleButton("Nrg", null, null, CampUnitSelectionControl.paint_armour_name, Statics.img_cache.getImage("lumin_green_button2", CampUnitSelectionControl.ARMOUR_ICON_WIDTH, CampUnitSelectionControl.ARMOUR_ICON_HEIGHT), Statics.img_cache.getImage("button_blue_darker", CampUnitSelectionControl.ARMOUR_ICON_WIDTH, CampUnitSelectionControl.ARMOUR_ICON_HEIGHT));
        heading.attachChild(b);
        b = new ToggleButton("Mrl", null, null, CampUnitSelectionControl.paint_armour_name, Statics.img_cache.getImage("lumin_green_button2", CampUnitSelectionControl.ARMOUR_ICON_WIDTH, CampUnitSelectionControl.ARMOUR_ICON_HEIGHT), Statics.img_cache.getImage("button_blue_darker", CampUnitSelectionControl.ARMOUR_ICON_WIDTH, CampUnitSelectionControl.ARMOUR_ICON_HEIGHT));
        heading.attachChild(b);
        heading.updateGeometricState();
        this.vfl.attachChild(heading);
        this.camp_squad_dt.moveBeforeFirst();
        while (this.camp_squad_dt.moveNext()) {
            CampUnitSelectionControl unit_ctrl = new CampUnitSelectionControl(GAP, this.camp_squad_dt.getInt("CampUnitID"), this.camp_squad_dt.getString("Name"), "" + this.camp_squad_dt.getInt("MaxHealth"), "" + this.camp_squad_dt.getInt("MaxAPs"), "" + this.camp_squad_dt.getInt("ShotSkill"), "" + this.camp_squad_dt.getInt("CombatSkill"), "" + this.camp_squad_dt.getInt("Strength"), "" + this.camp_squad_dt.getInt("MaxEnergy"), "" + this.camp_squad_dt.getInt("MaxMorale"));
            this.vfl.attachChild(unit_ctrl);
        }
        this.vfl.updateGeometricState();
        HorizontalFlowGridLayout hfgl = new HorizontalFlowGridLayout("hfgl", (float)Statics.SCREEN_WIDTH * 0.02f);
        this.game_details = new Button("Game Details", null, paint_normal_text, Statics.img_cache.getImage("button_blue", (float)Statics.SCREEN_WIDTH * 0.47f, Statics.GetStdButtonHeight()));
        hfgl.attachChild(this.game_details);
        this.mission_file = new Button("Mission File", null, paint_normal_text, Statics.img_cache.getImage("button_blue", (float)Statics.SCREEN_WIDTH * 0.47f, Statics.GetStdButtonHeight()));
        hfgl.attachChild(this.mission_file);
        hfgl.updateGeometricState();
        this.vfl.attachChild(hfgl);
        this.finished2 = new Button("Deploy Selected Units", null, paint_normal_text, Statics.img_cache.getImage("button_green", (float)Statics.SCREEN_WIDTH, Statics.GetStdButtonHeight()));
        this.vfl.attachChild(this.finished2);
        this.root_node.attachChild(this.vfl);
        this.root_node.updateGeometricState();
        this.root_cam.lookAt(Statics.SCREEN_WIDTH / 2, Statics.SCREEN_HEIGHT / 2, true);
    }

    @Override
    public void started() {
        if (Statics.data.containsKey(CONFIRM_SQUAD)) {
            String s = Statics.data.get(CONFIRM_SQUAD);
            Statics.data.clear();
            if (s.equalsIgnoreCase("yes")) {
                this.finish();
            }
        }
    }

    @Override
    public void handleClick(AbstractComponent c) throws Exception {
        AbstractActivity act = Statics.act;
        if (c instanceof CheckBox) {
            CheckBox cb = (CheckBox)c;
            cb.toggle();
        } else if (c == this.game_details) {
            CurrentGameDetailsModule mod = new CurrentGameDetailsModule(act, this, this.game_data, false);
            this.getMainThread().setNextModule(mod);
        } else if (c == this.mission_file) {
            String url = String.valueOf(Statics.URL_FOR_CLIENT) + "/dsr/missiondescriptions.cls?type=" + this.game_data.mission_type + "&android_login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&android_pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD);
            Browser.OpenBrowser(url);
        } else if (c == this.finished || c == this.finished2) {
            this.confirmIfFinished();
        }
    }

    private void confirmIfFinished() {
        AbstractActivity act = Statics.act;
        this.getMainThread().setNextModule(new ConfirmModule(act, this, "Are You Sure?", "Are you sure you have definitely finished selecting your units?  You can't go back afterwards!", "space1.jpg", CONFIRM_SQUAD));
    }

    private void finish() {
        block9: {
            AbstractActivity act = Statics.act;
            StringBuffer str = new StringBuffer();
            int count = 0;
            for (Spatial s : this.vfl.getChildren()) {
                CampUnitSelectionControl cb;
                if (!(s instanceof CampUnitSelectionControl) || !(cb = (CampUnitSelectionControl)s).isChecked()) continue;
                if (cb.campunitid <= 0) {
                    throw new RuntimeException("No cb.campunitid!");
                }
                str.append(String.valueOf(cb.campunitid) + ",");
                ++count;
            }
            if (count >= this.game_data.min_camp_units[this.game_data.our_side]) {
                if (count <= this.game_data.max_camp_units[this.game_data.our_side] && this.game_data.max_camp_units[this.game_data.our_side] > 0) {
                    try {
                        WGet_SF wc = new WGet_SF(act, null, "cmd=send_camp_squad_selection&comms_version=" + Statics.COMMS_VERSION + "&login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD) + "&gameid=" + this.game_data.game_id + "&side=" + this.game_data.our_side + "&data=" + str.toString());
                        String response = wc.getResponse();
                        if (AbstractCommFuncs.IsResponseGood(response)) {
                            super.getMainThread().setNextModule(new GetEquipmentDataModule(act, this.game_data));
                            break block9;
                        }
                        throw new IOException("Error from server: " + response);
                    }
                    catch (Exception ex) {
                        AbstractActivity.HandleError(ex);
                    }
                } else {
                    this.showToast("You can only select a maximum of " + this.game_data.max_camp_units[this.game_data.our_side] + " unit(s)");
                }
            } else {
                this.showToast("You must select at least " + this.game_data.min_camp_units[this.game_data.our_side] + " unit(s)");
            }
        }
    }
}

