/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.game;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.UpdateServerThread;
import com.scs.stellarforces.game.AllUnitStatsModule;
import com.scs.stellarforces.game.ExplosionPendingData;
import com.scs.stellarforces.game.GameLogModule;
import com.scs.stellarforces.game.IProcessable;
import com.scs.stellarforces.game.InGameMenu;
import com.scs.stellarforces.game.LoadLogThread;
import com.scs.stellarforces.game.ScannerModule;
import com.scs.stellarforces.game.SelectStructureToBuildModule;
import com.scs.stellarforces.game.SingleUnitStatsModule;
import com.scs.stellarforces.game.TextureStateCache;
import com.scs.stellarforces.game.Tutorial;
import com.scs.stellarforces.graphics.Bullet;
import com.scs.stellarforces.graphics.BulletLaser;
import com.scs.stellarforces.graphics.CCExplosion;
import com.scs.stellarforces.graphics.DummyWall;
import com.scs.stellarforces.graphics.EquipmentModel;
import com.scs.stellarforces.graphics.Explosion;
import com.scs.stellarforces.graphics.FireExtinguisherEffect;
import com.scs.stellarforces.graphics.FlameThrowerEffect;
import com.scs.stellarforces.graphics.GameObject;
import com.scs.stellarforces.graphics.GasCannister;
import com.scs.stellarforces.graphics.MapNode;
import com.scs.stellarforces.graphics.MapSquareImage;
import com.scs.stellarforces.graphics.gui.HUD;
import com.scs.stellarforces.graphics.gui.IconNode;
import com.scs.stellarforces.graphics.icons.AbstractIcon;
import com.scs.stellarforces.graphics.icons.ShowEnemyIcon;
import com.scs.stellarforces.graphics.units.AbstractUnit;
import com.scs.stellarforces.graphics.units.Blob;
import com.scs.stellarforces.instructions.InstructionsModule;
import com.scs.stellarforces.message.SendMessageModule;
import com.scs.stellarforces.start.CurrentGameDetailsModule;
import com.scs.stellarforces.start.GetGamesModule;
import dsr.comms.AbstractCommFuncs;
import dsr.comms.EquipmentDataComms;
import dsr.comms.EventDataComms;
import dsr.comms.GameDataComms;
import dsr.comms.GetAllGameData;
import dsr.comms.MapDataComms;
import dsr.comms.SetStatComms;
import dsr.comms.UnitDataComms;
import dsr.comms.VisibleEnemyComms;
import dsr.data.ClientMapData;
import dsr.data.EquipmentData;
import dsr.data.GameData;
import dsr.data.MapSquare;
import dsr.data.UnitData;
import dsrwebserver.tables.EquipmentTypesTable;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import ssmith.android.compatibility.Canvas;
import ssmith.android.compatibility.Paint;
import ssmith.android.compatibility.RectF;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.ErrorReporter;
import ssmith.android.framework.modules.AbstractComplexModule;
import ssmith.android.framework.modules.ConfirmModule;
import ssmith.android.lib2d.MyPickResults;
import ssmith.android.lib2d.MyPointF;
import ssmith.android.lib2d.PickData;
import ssmith.android.lib2d.Ray;
import ssmith.android.lib2d.Spatial;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.shapes.Geometry;
import ssmith.android.lib2d.shapes.Line;
import ssmith.awt.ImageCache;
import ssmith.lang.GeometryFuncs;
import ssmith.lang.NumberFunctions;
import ssmith.util.Browser;
import ssmith.util.IDisplayMessages;
import ssmith.util.Interval;
import ssmith.util.PointByte;
import ssmith.util.TSArrayList;

public final class GameModule
extends AbstractComplexModule
implements IDisplayMessages {
    private static final String CONFIRM_END_TURN = "end_turn";
    private static final String CONFIRM_START_TUTORIAL = "start_tutorial";
    private static final String CONFIRM_REMOVE_ITEM = "remove_item";
    public static final int MENU_ADVANCED_SCANNER = 2;
    public static final int MENU_GRID = 3;
    public static final int MENU_GAME_LOG = 4;
    public static final int MENU_START_TUTORIAL = 5;
    public static final int MENU_MISSION_DESC = 7;
    public static final int MENU_GAME_CHAT = 8;
    public static final int MENU_UNIT_STATS = 9;
    public static final int MENU_GAME_DETAILS = 10;
    public static final int MENU_MSG_OPPONENT = 11;
    public static final int MENU_MSG_COMRADE = 12;
    public static final int MENU_INSTRUCTIONS = 13;
    public static final boolean VERBOSE_COMMS = false;
    private static final byte MIN_SHOT_ACC = 15;
    private static final byte MAX_SHOT_ACC = 85;
    private static final byte OPP_FIRE_ACC_REDUCTION = 15;
    private static final int POINT_BLANK_DAMAGE_BONUS = 5;
    public static final float MIN_DAMAGE_REDUCTION_RANGE = 10.0f;
    public static final int STRENGTH_TO_DESTROY_COMP = 5;
    private static final int OPP_CC_COST = 8;
    private static final long TIME_BETWEEN_EXPLOSIONS = 2000L;
    private static final byte APP_STARTED = 4;
    private static final byte APP_TURN_ENDED_SHOWING_EXPLOSIONS = 5;
    private static final byte APP_TURN_ENDED_MOVE_AI = 6;
    private static final byte APP_TURN_ENDED_WAIT_FOR_COMMS = 7;
    private static final byte APP_TURN_FINISHED_COMPLETELY = 8;
    private static final byte APP_CRASHED = 9;
    private byte client_mode = (byte)4;
    public static final byte MM_NO_UNIT_SELECTED = 1;
    public static final byte MM_UNIT_SELECTED = 2;
    public static final byte MM_EQUIPMENT_MENU = 3;
    public static final byte MM_CHANGE_ITEM = 4;
    public static final byte MM_PICKUP_ITEM = 5;
    public static final byte MM_SHOOTING = 6;
    public static final byte MM_THROW = 7;
    public static final byte MM_PRIME_GRENADE = 9;
    public static final byte MM_TURN_FINISHED_NO_MENU = 10;
    public static final byte APS_CHANGE_ITEM = 13;
    public static final byte APS_PICKUP_ITEM = 8;
    public static final byte APS_DROP_ITEM = 3;
    public static final byte APS_REMOVE_ITEM = 8;
    public static final byte APS_PRIME = 10;
    public static final byte APS_ACTIVATE = 10;
    public static final byte APS_THROW = 10;
    public static final byte APS_CATCH = 3;
    public static final byte APS_USE_MEDIKIT = 20;
    public static final byte APS_OPEN_DOOR = 8;
    public static final byte APS_USE_SCANNER = 8;
    public static final byte APS_TELEPORT = 40;
    public static final byte APS_CREATE_ABSORB = 10;
    public static final byte APS_DISMANTLE = 15;
    public static final byte APS_SPLIT = 10;
    public static final byte APS_ABSORB = 10;
    public static final byte APS_EXPLODE = 20;
    public GameData game_data;
    public UnitData current_unit;
    private boolean check_our_init_visible_units;
    public UnitData[] units;
    public ClientMapData mapdata;
    public EquipmentData[] equipment;
    public boolean help_mode_on = true;
    public HUD hud;
    public IconNode icon_table;
    private Line shot_line;
    private Spatial highlighter;
    private long time_since_last_explosion;
    private TSArrayList<IProcessable> objects_for_processing = new TSArrayList();
    public MapNode map_model;
    public int next_to_deploy = -1;
    private ArrayList<ExplosionPendingData> explosions_to_show = new ArrayList();
    private ArrayList<AbstractIcon> orig_visible_enemy_icons = new ArrayList();
    private RectF signal_rect = new RectF(0.0f, 0.0f, 10.0f, 10.0f);
    public static boolean show_grid;
    private UpdateServerThread update_server_thread;
    private boolean wait_for_data_to_be_sent = false;
    public boolean show_tutorial = false;
    private Tutorial tutorial;
    private GameLogModule game_log_module;
    private boolean showing_please_wait = false;
    private boolean game_finished = false;
    private Button menu_icon;
    private Button end_turn_icon;
    private Button centre_on_unit;
    public InGameMenu submenu;
    public static ImageCache ImgCache;
    public boolean ap_lock = false;
    public boolean question = false;
    private LoadLogThread load_log;
    private boolean mentioned_ai = false;
    private boolean no_ai = true;
    private ArrayList<Integer> units_deployed = new ArrayList();
    private ArrayList<Integer> next_deploy_dir = new ArrayList();
    public boolean is_april_fools_day = false;
    private boolean moving_cam_to_explosion = true;
    private Interval ambience_interval = new Interval(30000L, true);
    private Interval check_shot_line_int = new Interval(300L, false);
    public static Paint paint_yellow_box;
    private static Paint paint_shot_line_unblocked;
    private static Paint paint_shot_line_blocked;

    static {
        paint_yellow_box = new Paint();
        paint_shot_line_unblocked = new Paint();
        paint_shot_line_blocked = new Paint();
        paint_yellow_box.setARGB(100, 255, 255, 0);
        paint_yellow_box.setAntiAlias(false);
        paint_shot_line_unblocked.setARGB(100, 0, 255, 0);
        paint_shot_line_unblocked.setStrokeWidth(6.0f);
        paint_shot_line_blocked.setARGB(100, 255, 0, 0);
        paint_shot_line_blocked.setStrokeWidth(4.0f);
    }

    public GameModule(AbstractActivity act, GetAllGameData all_game_data) {
        super(4);
        Calendar c = Calendar.getInstance();
        boolean bl = this.is_april_fools_day = c.get(2) == 3 && c.get(5) == 1;
        if (ImgCache == null) {
            ImgCache = new ImageCache(act.thread.window);
        }
        this.update_server_thread = new UpdateServerThread(this, act.thread.window);
        this.game_data = all_game_data.game_data;
        this.units = new UnitData[0];
        this.units = all_game_data.units.toArray(this.units);
        this.mapdata = all_game_data.getMap();
        this.equipment = all_game_data.equipment;
        this.check_our_init_visible_units = true;
        this.stat_node.detachAllChildren();
        this.menu_icon = new Button("Menu", AbstractIcon.paint_transp, AbstractIcon.paint_white_text, Statics.img_cache.getImage("menu_frame_blue", Statics.ICONS_WIDTH, Statics.ICONS_HEIGHT));
        this.menu_icon.setLocation((float)Statics.SCREEN_WIDTH - Statics.ICONS_WIDTH, 0.0f);
        this.stat_node.attachChild(this.menu_icon);
        if (this.game_data.game_status != 20) {
            this.end_turn_icon = new Button("End\nTurn", AbstractIcon.paint_transp, AbstractIcon.paint_white_text, Statics.img_cache.getImage("menu_frame_red", Statics.ICONS_WIDTH, Statics.ICONS_HEIGHT));
            this.end_turn_icon.setLocation((float)Statics.SCREEN_WIDTH - Statics.ICONS_WIDTH, (float)Statics.SCREEN_HEIGHT - Statics.ICONS_HEIGHT);
            this.stat_node.attachChild(this.end_turn_icon);
        }
        if (Statics.USE_NEW_MOVEMENT_ICONS == 1) {
            this.centre_on_unit = new Button("Centre\non Unit", AbstractIcon.paint_transp, AbstractIcon.paint_white_text, Statics.img_cache.getImage("menu_frame_yellow", Statics.ICONS_WIDTH, Statics.ICONS_HEIGHT));
            this.centre_on_unit.setLocation((float)Statics.SCREEN_WIDTH - Statics.ICONS_WIDTH * 2.0f, (float)Statics.SCREEN_HEIGHT - Statics.ICONS_HEIGHT);
            this.stat_node.attachChild(this.centre_on_unit);
        }
        this.icon_table = new IconNode(this);
        this.hud = new HUD(this, this.icon_table);
        this.stat_node.attachChild(this.hud);
        this.submenu = new InGameMenu(this);
        this.stat_node.attachChild(this.submenu);
        this.stat_node.updateGeometricState();
        this.stat_cam.lookAt(Statics.SCREEN_WIDTH / 2, Statics.SCREEN_HEIGHT / 2, true);
        this.objects_for_processing.add((Object)this.hud);
        this.root_node.detachAllChildren();
        this.createMapModel();
        int i = 0;
        while (i < this.units.length) {
            UnitData unit = this.units[i];
            if (unit.getStatus() == 2) {
                unit.model = AbstractUnit.Factory(this, unit);
                this.root_node.attachChild(unit.model);
                unit.model.visible = false;
                unit.updateModelFromUnitData();
            }
            ++i;
        }
        i = 0;
        while (i < this.equipment.length) {
            EquipmentData equip = this.equipment[i];
            if (equip.getUnitID() <= 0 && !equip.destroyed) {
                try {
                    PointByte p = EquipmentData.GetEquipmentMapSquare(this.mapdata, equip);
                    if (p != null) {
                        equip.model = EquipmentModel.Factory(this, equip, p.x, p.y);
                        this.attachToRootNode(equip.model, false);
                        if (this.game_data.is_advanced == 1 && equip.seen_by_side[this.game_data.our_side] == 0) {
                            equip.model.visible = false;
                        }
                    }
                }
                catch (RuntimeException ex) {
                    ErrorReporter.getInstance().handleSilentException(ex);
                }
            }
            ++i;
        }
        UnitData unit_to_be_selected = null;
        int i2 = 0;
        while (i2 < this.units.length) {
            UnitData unit = this.units[i2];
            if (this.game_data.areSidesFriends(unit.getSide(), this.game_data.our_side)) {
                if (unit.getStatus() == 2) {
                    unit.model.visible = true;
                    unit.updateModelFromUnitData();
                    if (this.game_data.game_status == 30 && this.game_data.turn_side == this.game_data.our_side && unit.getSide() == this.game_data.our_side && unit_to_be_selected == null) {
                        unit_to_be_selected = unit;
                    }
                }
            } else {
                new ShowEnemyIcon(this, unit);
            }
            ++i2;
        }
        this.root_node.updateGeometricState();
        this.root_cam.lookAt(this.root_node, false);
        if (this.game_data.game_status == 20) {
            this.updateMenu((byte)1);
            this.getNextUnitToDeploy();
            this.addToHUD(act.getString("deployment_squares"));
            this.addToHUD(act.getString("right_click_to_deploy"));
        } else if (this.game_data.game_status == 30 && unit_to_be_selected != null) {
            this.recalcVisibleEnemiesAndOppFire(false, null);
            this.selectOurUnit(unit_to_be_selected, true);
            this.updateMenu((byte)2);
            if (this.game_data.max_turns == this.game_data.turn_no) {
                this.addToHUD(act.getString("last_turn"));
            }
        } else if (this.game_data.game_status != 40) {
            this.updateMenu((byte)1);
            this.addToHUD(act.getString("no_units"));
        }
        this.loadTheLog();
        if (this.game_data.is_practise == 1 && this.isThereAnAISide() && this.game_data.game_status == 30) {
            ConfirmModule m = new ConfirmModule(act, this, "Start Tutorial?", "Would you like to turn Tutorial Mode on to help you play the game?", "space1.jpg", CONFIRM_START_TUTORIAL);
            this.getMainThread().setNextModule(m);
        }
    }

    private int getNextDeployDir() {
        while (this.next_deploy_dir.size() <= 0) {
            this.next_deploy_dir.add(NumberFunctions.rnd(0, 7) * 45);
        }
        return this.next_deploy_dir.remove(this.next_deploy_dir.size() - 1);
    }

    private void loadTheLog() {
        AbstractActivity act = Statics.act;
        this.load_log = new LoadLogThread(act, this.game_data.game_id);
    }

    @Override
    public void started() {
        if (Statics.data.containsKey(CONFIRM_END_TURN)) {
            if (Statics.data.get(CONFIRM_END_TURN).equalsIgnoreCase("yes")) {
                this.showExplosionsAndEndTurn();
            } else {
                this.returnTo();
            }
        } else if (Statics.data.containsKey("Scanner_Coords")) {
            try {
                String[] data = Statics.data.get("Scanner_Coords").split(",");
                int x = NumberFunctions.ParseInt(data[0]);
                int y = NumberFunctions.ParseInt(data[1]);
                this.root_cam.lookAt((float)x * Statics.SQ_SIZE, (float)y * Statics.SQ_SIZE, false);
                this.rootCamMoved(0.0f, 0.0f);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (Statics.data.containsKey(CONFIRM_START_TUTORIAL)) {
            try {
                if (Statics.data.get(CONFIRM_START_TUTORIAL).equalsIgnoreCase("yes")) {
                    this.startTutorial();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (Statics.data.containsKey(CONFIRM_REMOVE_ITEM)) {
            try {
                if (Statics.data.get(CONFIRM_REMOVE_ITEM).equalsIgnoreCase("yes")) {
                    this.removeCurrentItem();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Statics.data.clear();
    }

    @Override
    public void stopped() {
    }

    public void updateMenu() {
        this.updateMenu(this.icon_table.menu_mode);
    }

    private void updateMenu(byte menu) {
        this.icon_table.updateMenu(menu);
        this.hud.updateStatusBar();
        if (menu == 1 || this.game_data.game_status == 20) {
            this.hud.setMovementIconsVisible(false);
        } else if (this.current_unit != null) {
            this.hud.setMovementIconsVisible(true);
        }
        if (this.icon_table.menu_mode != 6 && this.icon_table.menu_mode != 7 && this.shot_line != null) {
            this.shot_line.removeFromParent();
            this.shot_line = null;
        }
    }

    public static int GetAimedShotAccuracy(UnitData unit) {
        float acc = Math.max(15, unit.shot_skill + unit.current_item.aimed_shot_acc);
        return (byte)Math.min(85.0f, acc);
    }

    public static int GetSnapShotAccuracy(UnitData unit) {
        float acc = Math.max(15, unit.shot_skill / 2 + unit.current_item.snap_shot_acc);
        return (byte)Math.min(85.0f, acc);
    }

    public static int GetAutoShotAccuracy(UnitData unit) {
        float acc = Math.max(15, unit.shot_skill / 3 + unit.current_item.auto_shot_acc);
        return (byte)Math.min(85.0f, acc);
    }

    @Override
    public boolean componentClicked(Geometry g) {
        AbstractActivity act = Statics.act;
        try {
            if (g.parent != null && g.parent.parent == this.submenu && g instanceof Button) {
                Button b = (Button)g;
                this.menuPressed(b);
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.wait_for_data_to_be_sent) {
            this.addToHUD("Please wait...");
            this.showing_please_wait = true;
            return true;
        }
        if (this.client_mode == 8) {
            this.returnTo();
            return true;
        }
        if (g == this.menu_icon) {
            this.submenu.toggle();
            return true;
        }
        if (g == this.end_turn_icon) {
            this.askIfEndTurn();
            return true;
        }
        if (g == this.centre_on_unit) {
            this.selectOurUnit(this.current_unit, true);
            return true;
        }
        if (g instanceof AbstractIcon) {
            AbstractIcon ai = (AbstractIcon)g;
            boolean ret = ai.mouseClicked();
            if (this.question) {
                this.question = false;
            }
            return ret;
        }
        if (g instanceof AbstractUnit) {
            AbstractUnit unit_model = (AbstractUnit)g;
            if (unit_model.unit_data.getSide() == this.game_data.our_side) {
                this.selectOurUnit(unit_model.unit_data, true);
            } else if (this.game_data.areSidesFriends(unit_model.unit_data.getSide(), this.game_data.our_side)) {
                if (unit_model.visible) {
                    this.addToHUD(act.getString("friendly_unit"));
                    if (unit_model.unit_data.current_item != null) {
                        EquipmentData eq = unit_model.unit_data.current_item;
                        this.addToHUD("Using " + eq.getName(true) + " ");
                    } else if (unit_model.unit_data.can_use_equipment) {
                        this.addToHUD("Using " + act.getString("nothing"));
                    }
                    return true;
                }
            } else if (unit_model.visible) {
                this.showEnemyDetails(unit_model);
                return true;
            }
        } else if (g instanceof MapSquareImage) {
            MapSquare sq;
            MapSquareImage mi = (MapSquareImage)g;
            if (this.game_data.game_status == 20 && this.next_to_deploy >= 0) {
                sq = this.mapdata.getSq_MaybeNULL(mi.x, mi.y);
                if (sq.deploy_sq_side > 0) {
                    this.deployUnit(sq);
                    return true;
                }
                this.addToHUD(act.getString("not_deploy_sq"));
            }
            if ((sq = this.mapdata.getSq_MaybeNULL(mi.x, mi.y)) != null) {
                String str_sq;
                if (sq.door_type > 0) {
                    this.addToHUD(act.getString("is_door"));
                }
                if (sq.smoke_type == 22) {
                    this.addToHUD(act.getString("is_nerve_gas"));
                }
                if (sq.smoke_type == 21) {
                    this.addToHUD(act.getString("is_smoke"));
                }
                if (sq.smoke_type == 34) {
                    this.addToHUD("That is fire");
                }
                if (sq.escape_hatch_side > 0) {
                    this.addToHUD(act.getString("is_escape_hatch"));
                }
                if (sq.major_type == 2) {
                    this.addToHUD("That is a computer");
                }
                if (sq.major_type == 3) {
                    this.addToHUD("That is a wall");
                }
                if (sq.major_type == 1) {
                    String side = "";
                    if (sq.owner_side > 0) {
                        side = " owned by ";
                        side = sq.owner_side == this.game_data.our_side ? String.valueOf(side) + "you" : String.valueOf(side) + this.game_data.GetPlayersNameFromSide(sq.owner_side);
                    }
                    switch (sq.texture_code) {
                        case 85: {
                            this.addToHUD("That is a Medi-Bay" + side);
                            break;
                        }
                        case 87: {
                            this.addToHUD("That is a Gun Vending Machine" + side);
                            break;
                        }
                        case 88: {
                            this.addToHUD("That is a Grenade Vending Machine" + side);
                            break;
                        }
                        case 86: {
                            this.addToHUD("That is a Clone Generator" + side);
                            break;
                        }
                        case 84: {
                            this.addToHUD("That is a Power Unit" + side);
                            break;
                        }
                        case 93: {
                            this.addToHUD("That is an alien egg" + side);
                        }
                    }
                }
                if ((str_sq = sq.getListOfEquipment(this.game_data.is_advanced, this.game_data.our_side)).length() > 0) {
                    this.addToHUD(str_sq);
                }
                return false;
            }
        }
        return false;
    }

    private void showEnemyDetails(AbstractUnit unit_model) {
        AbstractActivity act = Statics.act;
        this.addToHUD("Side " + unit_model.unit_data.getSide() + " #" + unit_model.unit_data.order_by + ", owned by " + this.game_data.GetPlayersNameFromSide(unit_model.unit_data.getSide()));
        if (unit_model.unit_data.current_item != null) {
            EquipmentData eq = unit_model.unit_data.current_item;
            this.addToHUD("Using " + eq.getName(false) + " ");
        } else if (unit_model.unit_data.can_use_equipment) {
            this.addToHUD("Using " + act.getString("nothing"));
        }
        this.addToHUD("Protection: " + unit_model.unit_data.protection);
        try {
            int x;
            if (this.is_april_fools_day && (x = NumberFunctions.rnd(0, 10)) == 0) {
                if (unit_model.unit_data.model_type == 1 || unit_model.unit_data.model_type == 2 || unit_model.unit_data.model_type == 5 || unit_model.unit_data.model_type == 6) {
                    this.addToHUD("He's not scared of you.");
                } else if (unit_model.unit_data.model_type == 12) {
                    this.addToHUD("Zombie says 'brainzzz!");
                } else if (unit_model.unit_data.model_type == 3) {
                    this.addToHUD("The alien only wants to be friends.");
                }
            }
        }
        catch (Exception ex) {
            ErrorReporter.getInstance().handleSilentException(ex);
        }
    }

    private boolean deployUnit(MapSquare sq) {
        AbstractActivity act = Statics.act;
        if (sq.deploy_sq_side > 0) {
            if (this.game_data.areSidesFriends(sq.deploy_sq_side, this.game_data.our_side)) {
                UnitData unit = this.units[this.next_to_deploy];
                UnitData other = this.getUnitAt(sq.x, sq.y);
                if (other == null) {
                    act.playSound("teleport");
                    unit.model = AbstractUnit.Factory(this, unit);
                    this.root_node.attachChild(unit.model);
                    unit.setTargetMapLocation(this, sq.x, sq.y, sq);
                    unit.setAngle(this.getNextDeployDir());
                    unit.setStatus((byte)2);
                    this.updateUnitOnServer(unit);
                    this.addToHUD(act.getString("unit_deployed"));
                    this.units_deployed.add(this.next_to_deploy);
                    this.getNextUnitToDeploy();
                    return true;
                }
                this.addToHUD(act.getString("already_a_unit"));
            } else {
                this.addToHUD(act.getString("not_your_deploy_sq"));
            }
        } else {
            this.addToHUD(act.getString("not_deploy_sq"));
        }
        return false;
    }

    @Override
    public void updateGame(long interpol) {
        AbstractActivity act = Statics.act;
        this.submenu.process();
        if (this.ambience_interval.hitInterval() && NumberFunctions.rnd(1, 3) == 1) {
            this.playAmbience();
        }
        if (this.wait_for_data_to_be_sent) {
            if (this.update_server_thread.isSendingData()) {
                return;
            }
            this.wait_for_data_to_be_sent = false;
        } else if (this.showing_please_wait) {
            if (this.client_mode != 6) {
                this.addToHUD(act.getString("ready"));
            }
            this.showing_please_wait = false;
        }
        this.objects_for_processing.refresh();
        this.time_since_last_explosion += interpol;
        if (this.areExplosionsScheduled()) {
            if (this.time_since_last_explosion >= 2000L) {
                ExplosionPendingData epd = this.getNextExplosion();
                if (this.moving_cam_to_explosion) {
                    Point p = epd.eq.getMapLocation(this.units, this.mapdata);
                    int mapx = p.x;
                    int mapy = p.y;
                    this.root_cam.lookAt((float)mapx * Statics.SQ_SIZE, (float)mapy * Statics.SQ_SIZE, false);
                    this.moving_cam_to_explosion = false;
                } else if (!this.root_cam.isMoving()) {
                    this.removeNextExplosion();
                    this.explodeGrenade(epd.eq, epd.caused_by);
                    this.time_since_last_explosion = 0L;
                    this.moving_cam_to_explosion = true;
                }
            }
        } else if (this.client_mode == 5) {
            if (!this.update_server_thread.isSendingData()) {
                this.recalcVisibleEnemiesAndOppFire(false, null);
                this.client_mode = (byte)6;
                this.waitForPendingUpdateRequests();
            }
        } else if (this.client_mode == 6) {
            this.no_ai = true;
            int i = 0;
            while (i < this.units.length) {
                if (this.units[i].getSide() != this.game_data.our_side && this.units[i].hasAI() && this.units[i].getStatus() == 2) {
                    if (!this.mentioned_ai) {
                        this.addToHUD("Moving AI Units...");
                        this.mentioned_ai = true;
                    }
                    if (this.units[i].processAI(this)) {
                        this.no_ai = false;
                        break;
                    }
                }
                ++i;
            }
            if (this.no_ai) {
                this.updateGameDataOnServer(2);
                this.client_mode = (byte)7;
            }
        } else if (this.client_mode == 7 && !this.update_server_thread.isSendingData()) {
            this.client_mode = (byte)8;
            act.playSound(CONFIRM_END_TURN);
            if (this.game_data.game_status == 20) {
                this.addToHUD(act.getString("all_deployed"));
                if (this.game_data.getOpponentsName().equalsIgnoreCase("no-one") && this.game_data.num_players > 1) {
                    this.addToHUD("You will need to wait for another player to accept your game and deploy before you can take a turn.");
                }
                this.addToHUD(act.getString("press_any_key"));
            } else {
                this.hud.appendText(act.getString("press_any_key"));
                if (!this.game_finished && this.no_ai) {
                    this.hud.appendText("Your opponent has been informed that it is now their turn.");
                }
            }
        }
        int i = 0;
        while (i < this.objects_for_processing.size()) {
            IProcessable obj = (IProcessable)this.objects_for_processing.get(i);
            obj.process(interpol);
            ++i;
        }
        if (!this.update_server_thread.isAlive() && this.client_mode != 9) {
            this.addToHUD("PLEASE RESTART CLIENT");
            this.client_mode = (byte)9;
        }
    }

    private void waitForPendingUpdateRequests() {
        AbstractActivity act = Statics.act;
        this.wait_for_data_to_be_sent = true;
        if (this.update_server_thread.isSendingData()) {
            this.addToHUD(act.getString("please_wait"));
            this.showing_please_wait = true;
        }
    }

    @Override
    public void doDraw(Canvas g, long interpol) {
        float range;
        super.doDraw(g, interpol);
        if (this.shot_line != null) {
            this.updateShotLine(false);
        }
        if (this.icon_table.menu_mode == 7) {
            float range2 = (float)GameModule.GetMaxRangeSq(this) * Statics.SQ_SIZE;
            g.drawCircleFromCentre(this.current_unit.model.getWorldCentreX() - this.root_cam.left, this.current_unit.model.getWorldCentreY() - this.root_cam.top, range2, paint_shot_line_blocked);
        } else if (this.icon_table.menu_mode == 6 && this.current_unit.current_item != null && (range = (float)this.current_unit.current_item.range_sq * Statics.SQ_SIZE) > 0.0f) {
            g.drawCircleFromCentre(this.current_unit.model.getWorldCentreX() - this.root_cam.left, this.current_unit.model.getWorldCentreY() - this.root_cam.top, range, paint_shot_line_blocked);
        }
        if (this.update_server_thread.isSendingData()) {
            g.drawRect(this.signal_rect, paint_yellow_box);
        }
    }

    public void addToProcess(IProcessable o) {
        this.objects_for_processing.add((Object)o);
    }

    public void removeFromProcess(IProcessable o) {
        this.objects_for_processing.remove(o);
    }

    @Override
    public boolean onBackPressed() {
        if (this.submenu != null && this.submenu.getStatus() == 1) {
            this.submenu.hide();
            return true;
        }
        if (this.update_server_thread.isSendingData() && this.client_mode != 9) {
            this.hud.appendText("Please wait - sending data...");
            return true;
        }
        if (this.hud.getMenuMode() > 1) {
            this.cancelMenu();
        } else if (this.client_mode == 8) {
            this.returnTo();
        } else if (this.game_data.game_status == 20) {
            this.returnTo();
        } else {
            this.askIfEndTurn();
        }
        return true;
    }

    public void askIfEndTurn() {
        AbstractActivity act = Statics.act;
        ConfirmModule m = new ConfirmModule(act, this, "End Your Turn?", "Do you want to finish your turn?", "space1.jpg", CONFIRM_END_TURN);
        this.getMainThread().setNextModule(m);
    }

    public void updateEquipmentOnServer(EquipmentData eq, int x, int y) {
        String req = EquipmentDataComms.GetEquipmentUpdateRequest(eq, x, y, this.game_data.game_id);
        this.update_server_thread.addRequest(req);
    }

    public void addToHUD(String s) {
        if (this.hud != null) {
            this.hud.appendText(s);
        }
    }

    public void addToHUD(String s, boolean pri) {
        this.hud.appendText(s);
    }

    public void updateUnitOnServer(UnitData unit) {
        String req = UnitDataComms.GetUnitUpdateRequest(unit);
        this.update_server_thread.addRequest(req);
    }

    public void updateVisibleUnitOnServer(UnitData enemy, UnitData seen_by) {
        String req = VisibleEnemyComms.GetVisibleEnemyRequest(enemy, seen_by);
        this.update_server_thread.addRequest(req);
    }

    public void sendEventToServer_UnitMoved(UnitData unit, boolean[] seen_by_sides) {
        String req = EventDataComms.GetNewEventRequest(this.game_data.game_id, this.game_data.gamecode, 1, unit.unitid, unit.map_x, unit.map_y, 0, 0, seen_by_sides, 0, 0);
        this.update_server_thread.addRequest(req);
    }

    public void sendEventToServer_Explosion(int x, int z, int rad, byte type) {
        boolean[] seen_by_sides = new boolean[]{true, true, true, true};
        String req = EventDataComms.GetNewEventRequest(this.game_data.game_id, this.game_data.gamecode, 2, -1, x, z, rad, type, seen_by_sides, 0, 0);
        this.update_server_thread.addRequest(req);
    }

    public void sendEventToServer_MapSquareChanged(int x, int z, int old_major_type, int new_major_type, int tex, int side) {
        boolean[] seen_by_sides = new boolean[]{true, true, true, true};
        String req = EventDataComms.GetNewEventRequest(this.game_data.game_id, this.game_data.gamecode, 33, -1, x, z, old_major_type, new_major_type, seen_by_sides, tex, side);
        this.update_server_thread.addRequest(req);
    }

    public void sendEventToServer_ShotFired(UnitData unit, int ang, int len, boolean[] seen_by_sides) {
        String req = EventDataComms.GetNewEventRequest(this.game_data.game_id, this.game_data.gamecode, 5, unit.unitid, unit.getMapX(), unit.getMapY(), ang, len, seen_by_sides, 0, 0);
        this.update_server_thread.addRequest(req);
    }

    public void sendEventToServer_GrenadePrimed(UnitData unit, int turns, boolean[] seen_by_sides) {
        String req = EventDataComms.GetNewEventRequest(this.game_data.game_id, this.game_data.gamecode, 26, unit.unitid, unit.getMapX(), unit.getMapY(), turns, -1, seen_by_sides, 0, 0);
        this.update_server_thread.addRequest(req);
    }

    private void sendEventToServer_CloseCombat(UnitData shooter, boolean[] seen_by_side) {
        String req = EventDataComms.GetNewEventRequest(this.game_data.game_id, this.game_data.gamecode, 21, shooter.unitid, shooter.getMapX(), shooter.getMapY(), 0, 0, seen_by_side, 0, 0);
        this.update_server_thread.addRequest(req);
    }

    public void sendEventToServer_ItemThrown(UnitData shooter, int ang, int dist, boolean[] seen_by_side) {
        String req = EventDataComms.GetNewEventRequest(this.game_data.game_id, this.game_data.gamecode, 19, shooter.unitid, shooter.getMapX(), shooter.getMapY(), ang, dist, seen_by_side, 0, 0);
        this.update_server_thread.addRequest(req);
    }

    public void sendEventToServer_UnitTeleported(UnitData shooter, boolean[] seen_by_side) {
        String req = EventDataComms.GetNewEventRequest(this.game_data.game_id, this.game_data.gamecode, 32, shooter.unitid, shooter.getMapX(), shooter.getMapY(), 0, 0, seen_by_side, 0, 0);
        this.update_server_thread.addRequest(req);
    }

    public void sendEventToServer_ItemDropped(UnitData shooter, boolean[] seen_by_side) {
        String req = EventDataComms.GetNewEventRequest(this.game_data.game_id, this.game_data.gamecode, 18, shooter.unitid, shooter.getMapX(), shooter.getMapY(), 0, 0, seen_by_side, 0, 0);
        this.update_server_thread.addRequest(req);
    }

    public void sendEventToServer_ItemPickedUp(UnitData unit, boolean[] seen_by_side) {
        String req = EventDataComms.GetNewEventRequest(this.game_data.game_id, this.game_data.gamecode, 20, unit.unitid, unit.getMapX(), unit.getMapY(), 0, 0, seen_by_side, 0, 0);
        this.update_server_thread.addRequest(req);
    }

    public void sendEventToServer_UnitKilled(UnitData unit_killed, int attacked_by_side, int attacked_by_unitid, int form_of_attack, int amt, boolean[] seen_by_side) {
        String req = EventDataComms.GetNewEventRequest(this.game_data.game_id, this.game_data.gamecode, 4, unit_killed.unitid, unit_killed.getMapX(), unit_killed.getMapY(), attacked_by_side, attacked_by_unitid, seen_by_side, form_of_attack, amt);
        this.update_server_thread.addRequest(req);
    }

    private void sendEventToServer_BlobSplit(UnitData unit, boolean[] seen_by_side, int x, int z) {
        String req = EventDataComms.GetNewEventRequest(this.game_data.game_id, this.game_data.gamecode, 27, unit.unitid, unit.getMapX(), unit.getMapY(), x, z, seen_by_side, 0, 0);
        this.update_server_thread.addRequest(req);
    }

    public void sendEventToServer_UnitEscaped(UnitData unit_killed, boolean[] seen_by_side) {
        String req = EventDataComms.GetNewEventRequest(this.game_data.game_id, this.game_data.gamecode, 7, unit_killed.unitid, unit_killed.getMapX(), unit_killed.getMapY(), 0, 0, seen_by_side, 0, 0);
        this.update_server_thread.addRequest(req);
    }

    public void sendEventToServer_UnitWounded(UnitData unit_killed, int attacked_by_side, int attacked_by_unitid, int form_of_attack, int amt, boolean[] seen_by_side) {
        String req = EventDataComms.GetNewEventRequest(this.game_data.game_id, this.game_data.gamecode, 17, unit_killed.unitid, unit_killed.getMapX(), unit_killed.getMapY(), attacked_by_side, attacked_by_unitid, seen_by_side, form_of_attack, amt);
        this.update_server_thread.addRequest(req);
    }

    public void setResPointsForSideOnServer(int side, int amt) {
        String req = SetStatComms.GetSetStatRequest(this.game_data.game_id, this.game_data.gamecode, side, 1, amt);
        this.update_server_thread.addRequest(req);
    }

    public void updateGameDataOnServer(int type) {
        String req = GameDataComms.GetGameUpdateRequest(this.game_data.game_id, this.game_data.gamecode, this.game_data.our_side, type);
        this.update_server_thread.addRequest(req);
    }

    public void updateMapOnServer(MapSquare sq, int destroyed_by_side) {
        String req = MapDataComms.GetMapDataUpdateRequest(this.game_data.game_id, this.game_data.gamecode, sq, destroyed_by_side);
        this.update_server_thread.addRequest(req);
    }

    public static void p(Object o) {
        AbstractActivity.Log(o.toString());
    }

    public void sideHasWon(byte side) {
        AbstractActivity act = Statics.act;
        this.addToHUD("**********************");
        if (this.game_data.areSidesFriends(side, this.game_data.our_side)) {
            this.addToHUD(act.getString("you_have_won"));
            act.playSound("fanfare");
            this.showToast(act.getString("you_have_won"));
        } else {
            this.addToHUD(act.getString("you_have_lost"));
            this.showToast(act.getString("you_have_lost"));
        }
        this.addToHUD("**********************");
        this.game_finished = true;
    }

    public void gameIsDraw() {
        AbstractActivity act = Statics.act;
        this.addToHUD("**********************");
        this.addToHUD(act.getString("game_drawn"));
        this.showToast(act.getString("game_drawn"));
        this.addToHUD("**********************");
        this.game_finished = true;
    }

    public void checkForDeathGrenadesOrAlienExplode(UnitData caused_by_unit) {
        if (caused_by_unit.model_type == 3) {
            int ACID_BLOOD_DAMAGE = 40;
            this.normalExplosion(caused_by_unit.map_x, caused_by_unit.map_y, NumberFunctions.rndByte(1, 3), ACID_BLOOD_DAMAGE, caused_by_unit, false, true);
        } else if (caused_by_unit.model_type == 7) {
            int ACID_BLOOD_DAMAGE = 80;
            this.normalExplosion(caused_by_unit.map_x, caused_by_unit.map_y, NumberFunctions.rndByte(2, 4), ACID_BLOOD_DAMAGE, caused_by_unit, false, true);
        } else if (caused_by_unit.model_type != 8) {
            int i = 0;
            while (i < caused_by_unit.items.size()) {
                EquipmentData eq = caused_by_unit.items.get(i);
                if (eq.major_type == 9 && eq.primed) {
                    eq.primed = false;
                    this.updateEquipmentOnServer(eq, -1, -1);
                    this.scheduleExplosion(eq, caused_by_unit);
                }
                ++i;
            }
        }
    }

    public UnitData getCurrentUnit() {
        return this.current_unit;
    }

    public boolean[] whichSidesCanSeeUnit(UnitData shooter) {
        boolean[] side_can_see_shooter = new boolean[this.game_data.num_players + 1];
        boolean[] sides_checked = new boolean[this.game_data.num_players + 1];
        this.game_data.side_sides[shooter.getSide()].setArray(sides_checked, true);
        side_can_see_shooter[shooter.getSide()] = true;
        int i = 0;
        while (i < this.units.length) {
            if (!sides_checked[this.units[i].getSide()] && this.units[i].getStatus() == 2 && this.units[i].canUnitSee(shooter)) {
                sides_checked[this.units[i].getSide()] = true;
                side_can_see_shooter[this.units[i].getSide()] = true;
            }
            ++i;
        }
        return side_can_see_shooter;
    }

    public boolean canAnyOtherSideSeeUnit(UnitData unit) {
        int i = 0;
        while (i < this.units.length) {
            if (this.units[i].getStatus() == 2 && this.units[i].getSide() != unit.getSide() && this.units[i].canUnitSee(unit)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void unitKilled(UnitData unit) {
        this.icon_table.our_unit_icons.remove(unit.icon);
        this.deselectUnitIfCurrent(unit);
        int i = 0;
        while (i < this.equipment.length) {
            EquipmentData equip = this.equipment[i];
            if (equip.getUnitID() == unit.unitid) {
                unit.removeItem(this, equip, false);
                equip.seen_by_side[unit.getSide()] = 1;
                this.mapdata.getSq_MaybeNULL(unit.getMapX(), unit.getMapY()).addEquipment(equip);
                this.updateEquipmentOnServer(equip, unit.getMapX(), unit.getMapY());
                equip.model = EquipmentModel.Factory(this, equip, unit.getMapX(), unit.getMapY());
                this.attachToRootNode(equip.model, true);
            }
            ++i;
        }
    }

    public void attachToRootNode(Spatial s, boolean update) {
        this.attachToRootNode(1, s, update);
    }

    public void attachToRootNode_Top(Spatial s, boolean update) {
        this.attachToRootNode(this.root_node.getNumChildren(), s, update);
    }

    public void attachToRootNode(int pos, Spatial s, boolean update) {
        this.root_node.attachChild(pos, s);
        if (update) {
            this.root_node.updateGeometricState();
        }
    }

    public void unitEscaped(UnitData unit) {
        AbstractActivity act = Statics.act;
        this.icon_table.our_unit_icons.remove(unit.icon);
        this.deselectUnitIfCurrent(unit);
        this.addToHUD(String.valueOf(unit.name) + " " + act.getString("has_escaped"));
    }

    public void recalcVisibleEnemiesAndOppFire(boolean opp_fire, UnitData unit_that_moved) {
        this.orig_visible_enemy_icons.clear();
        this.orig_visible_enemy_icons.addAll(this.icon_table.visible_enemy_icons);
        boolean can_see_all_enemies = this.game_data.side_see_enemies[this.game_data.our_side] == 1;
        this.icon_table.visible_enemy_icons.clear();
        if (this.game_data.is_advanced == 1) {
            int j_friend = 0;
            while (j_friend < this.units.length) {
                if (this.game_data.areSidesFriends(this.units[j_friend].getSide(), this.game_data.our_side) && this.units[j_friend].getStatus() == 2) {
                    int e = 0;
                    while (e < this.equipment.length) {
                        if (this.equipment[e].getUnitID() <= 0 && !this.equipment[e].destroyed && this.equipment[e].seen_by_side[this.game_data.our_side] == 0 && this.canUnitSeeEquipment(this.units[j_friend], this.equipment[e])) {
                            this.equipment[e].model.visible = true;
                            this.equipment[e].seen_by_side[this.game_data.our_side] = 1;
                            PointByte p = EquipmentData.GetEquipmentMapSquare(this.mapdata, this.equipment[e]);
                            if (p != null) {
                                this.updateEquipmentOnServer(this.equipment[e], p.x, p.y);
                            }
                        }
                        ++e;
                    }
                }
                ++j_friend;
            }
        }
        int i = 0;
        while (i < this.units.length) {
            this.units[i].clearSeenUnits();
            ++i;
        }
        int i_enemy = 0;
        while (i_enemy < this.units.length) {
            if (!this.game_data.areSidesFriends(this.units[i_enemy].getSide(), this.game_data.our_side)) {
                boolean can_enemy_see_all_us = this.game_data.side_see_enemies[this.units[i_enemy].getSide()] == 1;
                boolean has_enemy_fired = false;
                if (this.units[i_enemy].getStatus() == 2) {
                    if (!this.units[i_enemy].has_been_seen && !can_see_all_enemies) {
                        this.units[i_enemy].model.visible = false;
                    } else if (can_see_all_enemies) {
                        this.units[i_enemy].model.visible = true;
                    }
                    int j_friend = 0;
                    while (j_friend < this.units.length) {
                        if (this.units[j_friend].getSide() == this.game_data.our_side && this.units[j_friend].getStatus() == 2) {
                            if (this.canUnitSeeUnit(this.units[j_friend], this.units[i_enemy], true) || can_see_all_enemies) {
                                this.markUnitAsSeen(this.units[i_enemy], this.units[j_friend]);
                            }
                            if (this.canUnitSeeUnit(this.units[i_enemy], this.units[j_friend], true) || can_enemy_see_all_us) {
                                this.markUnitAsSeen(this.units[j_friend], this.units[i_enemy]);
                                if (this.check_our_init_visible_units) {
                                    this.units[i_enemy].can_see_at_start.add(this.units[j_friend]);
                                }
                                if (!(has_enemy_fired || !opp_fire || this.client_mode >= 5 || this.units[j_friend] != unit_that_moved && unit_that_moved != null || this.units[i_enemy].opp_fire_01 == 0 || this.game_data.is_snafu != 0 && this.game_data.snafu_will_opp_fire_on_side[this.units[i_enemy].getSide()] != 1)) {
                                    if (this.units[i_enemy].current_item != null && this.units[i_enemy].current_item.major_type == 1 && this.units[i_enemy].current_item.auto_shot_acc > 0) {
                                        if (!this.isUnitAdjToFriendlyUnitHeCanSee(this.units[j_friend]) && !this.units[i_enemy].can_see_at_start.contains(this.units[j_friend])) {
                                            float dist = this.units[i_enemy].model.getMapDistTo(this.units[j_friend].model);
                                            if (this.units[i_enemy].current_item.range_sq <= 0 || dist <= (float)this.units[i_enemy].current_item.range_sq) {
                                                this.makeOppFireShot(this.units[i_enemy], this.units[j_friend]);
                                                has_enemy_fired = true;
                                            }
                                        }
                                    } else if ((this.units[i_enemy].current_item == null || this.units[i_enemy].current_item.major_type == 4) && this.units[i_enemy].model.getMapDistTo(this.units[j_friend].model) < 1.7f && !this.units[i_enemy].can_see_at_start.contains(this.units[j_friend]) && this.units[i_enemy].checkAndReduceAPs(this, 8)) {
                                        this.closeCombat(this.units[i_enemy], this.units[j_friend]);
                                    }
                                }
                            }
                        }
                        ++j_friend;
                    }
                }
            }
            ++i_enemy;
        }
        this.check_our_init_visible_units = false;
        this.updateEnemyIcons();
    }

    @Override
    public void displayMessage(String s) {
        this.hud.appendText(s);
    }

    public boolean isAnyFriendlyUnitHoldingPrimedGrenade() {
        int i = 0;
        while (i < this.units.length) {
            if (this.units[i].getSide() == this.game_data.our_side && this.units[i].current_item != null) {
                EquipmentData eq = this.units[i].current_item;
                if ((eq.major_type == 2 || eq.major_type == 21 || eq.major_type == 22) && eq.primed && eq.explode_turns < this.game_data.num_players) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private void getNextUnitToDeploy() {
        AbstractActivity act = Statics.act;
        this.next_to_deploy = -1;
        int i = 0;
        while (i < this.units.length) {
            if (this.units[i].getSide() == this.game_data.our_side && this.units[i].getStatus() == 1) {
                this.next_to_deploy = i;
                break;
            }
            ++i;
        }
        this.hud.clearText();
        if (this.next_to_deploy == -1) {
            this.finishedDeployment();
        } else {
            this.addToHUD(String.valueOf(act.getString("unit")) + " " + this.units[this.next_to_deploy].order_by + "/" + this.game_data.getUnitsRemaining() + ":");
            this.addToHUD(String.valueOf(act.getString("select_deploy_sq")) + " " + this.units[this.next_to_deploy].name);
            if (this.units[this.next_to_deploy].can_use_equipment) {
                this.addToHUD(String.valueOf(act.getString("unit_protection")) + ": " + this.units[this.next_to_deploy].protection);
                this.addToHUD(String.valueOf(act.getString("unit_is_carrying")) + ":-");
                this.addToHUD(GameModule.GetUnitsEquipmentAsString(this.units[this.next_to_deploy], this.equipment).toString());
            }
        }
        this.hud.updateStatusBar();
        this.updateMenu();
    }

    public void finishedDeployment() {
        this.updateGameDataOnServer(1);
        this.waitForPendingUpdateRequests();
        this.client_mode = (byte)7;
    }

    public static String GetUnitsEquipmentAsString(UnitData unit, EquipmentData[] equipment) {
        StringBuffer str = new StringBuffer();
        boolean any = false;
        int i = 0;
        while (i < equipment.length) {
            EquipmentData equip = equipment[i];
            if (equip.getUnitID() == unit.unitid && !equip.destroyed) {
                str.append(equip.getName(true));
                if (equip == unit.current_item) {
                    str.append("*");
                }
                str.append(", ");
                any = true;
            }
            ++i;
        }
        if (!any) {
            str.append("Nothing.");
        } else {
            str.delete(str.length() - 2, str.length());
        }
        return str.toString();
    }

    public void selectOurUnit(UnitData unit, boolean force) {
        AbstractActivity act = Statics.act;
        if (this.current_unit == unit && !force) {
            return;
        }
        if (unit == null) {
            return;
        }
        if (this.game_data.turn_side == this.game_data.our_side && unit.getSide() == this.game_data.our_side && !unit.hasAI() && unit.getStatus() == 2) {
            int x;
            this.root_cam.lookAt(unit.model, false);
            this.current_unit = unit;
            this.hud.clearText();
            this.addToHUD(String.valueOf(unit.name) + " (" + unit.order_by + ") " + act.getString("selected"));
            if (unit.can_use_equipment) {
                this.addToHUD(String.valueOf(act.getString("unit_is_carrying")) + ":-");
                this.addToHUD(GameModule.GetUnitsEquipmentAsString(unit, this.equipment));
                if (this.help_mode_on && this.current_unit.current_item == null) {
                    this.addToHUD(String.valueOf(act.getString("help")) + ": " + act.getString("not_using_anything"));
                    this.addToHUD(String.valueOf(act.getString("help")) + ": " + act.getString("select_equip"));
                }
                if (this.current_unit.current_item != null) {
                    if (this.current_unit.current_item.major_type == 2 || this.current_unit.current_item.major_type == 22) {
                        if (this.current_unit.current_item.primed) {
                            this.addToHUD(String.valueOf(act.getString("warning")) + ": " + act.getString("holding_primed_grenade"), true);
                        }
                    } else if (this.current_unit.current_item.major_type == 1) {
                        if (this.current_unit.current_item.getAmmo() <= 0) {
                            this.addToHUD(String.valueOf(act.getString("warning")) + ": " + act.getString("out_of_ammo"));
                        }
                        if (unit.aps >= unit.opp_fire_aps_req && this.isUnitAdjToFriendlyUnitHeCanSee(unit)) {
                            this.addToHUD(String.valueOf(act.getString("warning")) + ": " + act.getString("will_not_opp_fire"), true);
                        }
                    }
                } else {
                    this.addToHUD(String.valueOf(act.getString("warning")) + ": " + act.getString("not_using_anything"), true);
                }
                if (this.current_unit.on_fire > 0) {
                    this.addToHUD("UNIT IS ON FIRE!", true);
                    act.playSound("fire");
                }
            }
            if (this.is_april_fools_day && (x = NumberFunctions.rnd(0, 10)) == 0) {
                if (this.current_unit.model_type == 1 || this.current_unit.model_type == 2 || this.current_unit.model_type == 5 || this.current_unit.model_type == 6) {
                    this.addToHUD("Unit has wet himself.");
                } else if (this.current_unit.model_type == 12) {
                    this.addToHUD("Unit has become vegetarian.");
                } else {
                    byte cfr_ignored_0 = this.current_unit.model_type;
                }
            }
            if (this.game_data.is_advanced == 1) {
                if (this.current_unit.panicked != 0) {
                    this.addToHUD(act.getString("unit_panicked"));
                } else if (this.current_unit.curr_morale <= 5) {
                    this.addToHUD(String.valueOf(act.getString("warning")) + ": " + act.getString("unit_scared"), true);
                }
                if (this.current_unit.curr_energy <= 0) {
                    this.addToHUD(act.getString("unit_exhausted"));
                } else if (this.current_unit.curr_energy < this.current_unit.max_aps) {
                    this.addToHUD(String.valueOf(act.getString("warning")) + ": " + act.getString("unit_tired"), true);
                }
            }
            this.hud.updateStatusBar();
            this.updateMenu((byte)2);
            this.updateEnemyIcons();
            if (Statics.USE_NEW_MOVEMENT_ICONS == 1) {
                this.hud.setMovementIconsVisible(true);
                this.hud.new_movement.updateMovementIcons(unit);
            }
        }
    }

    private void updateEnemyIcons() {
        if (this.current_unit != null) {
            for (AbstractIcon icon : this.icon_table.visible_enemy_icons) {
                ShowEnemyIcon ic = (ShowEnemyIcon)icon;
                if (this.current_unit.canUnitSee(ic.getUnit())) {
                    ic.setFlashing(true);
                    continue;
                }
                ic.setFlashing(false);
            }
        }
    }

    public void showUnitStats(UnitData unit) {
        if (unit.getSide() == this.game_data.our_side) {
            super.getMainThread().setNextModule(new SingleUnitStatsModule(this, unit, this.equipment));
        }
    }

    public void activateEquipment() {
        AbstractActivity act = Statics.act;
        EquipmentData eq = this.current_unit.current_item;
        if (eq != null) {
            if (eq.major_type == 9) {
                if (!eq.primed) {
                    if (this.current_unit.checkAndReduceAPs(this, 10) && this.current_unit != null) {
                        this.updateUnitOnServer(this.current_unit);
                        this.addToHUD(act.getString("item_activated"));
                        eq.primed = true;
                        eq.last_unit_to_touch = this.current_unit.unitid;
                        this.updateEquipmentOnServer(eq, -1, -1);
                        this.hud.updateStatusBar();
                        this.icon_table.updateMenu((byte)2);
                    }
                } else {
                    this.addToHUD(act.getString("already_activated"));
                }
            } else {
                this.addToHUD(act.getString("cannot_be_activated"));
            }
        }
    }

    public void cancelMenu() {
        if (this.icon_table.menu_mode == 2) {
            this.current_unit = null;
            this.updateMenu((byte)1);
            this.removeHighlighter();
        } else {
            this.updateMenu((byte)2);
        }
    }

    private void removeHighlighter() {
        if (this.highlighter != null) {
            this.highlighter.removeFromParent();
            this.highlighter = null;
        }
    }

    public void dropCurrentItem() {
        MapSquare sq;
        AbstractActivity act = Statics.act;
        EquipmentData eq = this.current_unit.current_item;
        if (eq.major_type == 13 && (sq = this.mapdata.getSq_MaybeNULL(this.current_unit.map_x, this.current_unit.map_y)).containsType(13)) {
            this.addToHUD(act.getString("no_room"));
            return;
        }
        if (this.current_unit.checkAndReduceAPs(this, 3) && this.current_unit != null) {
            this.current_unit.removeCurrentItem(this);
            this.mapdata.getSq_MaybeNULL(this.current_unit.getMapX(), this.current_unit.getMapY()).addEquipment(eq);
            eq.model = EquipmentModel.Factory(this, eq, this.current_unit.getMapX(), this.current_unit.getMapY());
            this.attachToRootNode(eq.model, true);
            boolean[] who_can_see = this.whichSidesCanSeeUnit(this.current_unit);
            this.sendEventToServer_ItemDropped(this.current_unit, who_can_see);
            eq.seen_by_side[this.current_unit.getSide()] = 1;
            this.updateEquipmentOnServer(eq, this.current_unit.getMapX(), this.current_unit.getMapY());
            this.updateUnitOnServer(this.current_unit);
            this.updateMenu((byte)2);
            this.hud.appendText("Item dropped.");
        }
    }

    public void askIfRemoveItem() {
        AbstractActivity act = Statics.act;
        ConfirmModule m = new ConfirmModule(act, this, "Remove Current Item?", "Do you want to remove the unit's current item?", "space1.jpg", CONFIRM_REMOVE_ITEM);
        this.getMainThread().setNextModule(m);
    }

    public void removeCurrentItem() {
        if (this.current_unit.checkAndReduceAPs(this, 8) && this.current_unit != null) {
            this.current_unit.current_item = null;
            this.updateUnitOnServer(this.current_unit);
            this.updateMenu((byte)2);
        }
    }

    public void absorbeCorpse() {
        AbstractActivity act = Statics.act;
        if (this.current_unit != null) {
            boolean corpse_found = false;
            ArrayList<EquipmentData> al = this.mapdata.getSq_MaybeNULL(this.current_unit.getMapX(), this.current_unit.getMapY()).getEquipment_MaybeNULL();
            if (al != null) {
                int i = 0;
                while (i < al.size()) {
                    EquipmentData equip = al.get(i);
                    if (EquipmentTypesTable.CORPSES.contains(equip.major_type)) {
                        corpse_found = true;
                        if (this.current_unit.checkAndReduceAPs(this, 10) && this.current_unit != null) {
                            if (equip.model != null) {
                                equip.model.removeFromParent();
                                equip.model = null;
                            }
                            equip.destroyed = true;
                            this.mapdata.getSq_MaybeNULL(this.current_unit.getMapX(), this.current_unit.getMapY()).removeEquipment(equip);
                            int s = 1;
                            while (s <= 4) {
                                equip.seen_by_side[s] = 0;
                                ++s;
                            }
                            this.updateEquipmentOnServer(equip, this.current_unit.getMapX(), this.current_unit.getMapY());
                            if (this.current_unit.model_type == 8) {
                                this.current_unit.incHealth(15, true);
                                this.current_unit.strength += 15;
                                this.current_unit.combat_skill += 15;
                                this.updateUnitOnServer(this.current_unit);
                                Blob b = (Blob)this.current_unit.model;
                                b.recreateBitmaps(this, this.current_unit);
                            } else if (this.game_data.can_build_and_dismantle == 1 && (this.current_unit.model_type == 3 || this.current_unit.model_type == 7)) {
                                byte by = this.game_data.our_side;
                                this.game_data.res_points[by] = this.game_data.res_points[by] + 1;
                                this.setResPointsForSideOnServer(this.game_data.our_side, this.game_data.res_points[this.game_data.our_side]);
                            }
                            this.addToHUD("Corpse absorbed.");
                            this.updateMenu((byte)2);
                            return;
                        }
                    }
                    ++i;
                }
            }
            if (!corpse_found) {
                this.addToHUD(act.getString("no_corpse"));
            }
        }
    }

    public void splitBlob() {
        AbstractActivity act = Statics.act;
        if (this.current_unit.getHealth() >= 6) {
            MapSquare sq = null;
            int z = this.current_unit.getMapY() - 1;
            while (z <= this.current_unit.getMapY() + 1) {
                int x = this.current_unit.getMapX() - 1;
                while (x <= this.current_unit.getMapX() + 1) {
                    MapSquare sq_tmp = this.mapdata.getSq_MaybeNULL(x, z);
                    if (sq_tmp != null && sq_tmp.major_type == 1 && sq_tmp.door_type <= 0 && this.getUnitAt(x, z) == null) {
                        sq = sq_tmp;
                    }
                    ++x;
                }
                ++z;
            }
            if (sq != null) {
                if (this.current_unit.checkAndReduceAPs(this, 10) && this.current_unit != null) {
                    this.current_unit.setHealth(this.current_unit.getHealth() / 2);
                    this.current_unit.setMaxHealth(this.current_unit.getMaxHealth() / 2);
                    this.current_unit.combat_skill -= this.current_unit.combat_skill / 2;
                    this.current_unit.strength -= this.current_unit.strength / 2;
                    Blob b = (Blob)this.current_unit.model;
                    b.recreateBitmaps(this, this.current_unit);
                    this.updateUnitOnServer(this.current_unit);
                    byte by = this.current_unit.getSide();
                    this.game_data.units_remaining[by] = (byte)(this.game_data.units_remaining[by] + 1);
                    boolean[] who_can_see = this.whichSidesCanSeeUnit(this.current_unit);
                    this.sendEventToServer_BlobSplit(this.current_unit, who_can_see, sq.x, sq.y);
                    UnitData unit = this.current_unit.clone();
                    unit.map_x = sq.x;
                    unit.map_y = sq.y;
                    unit.aps = 0;
                    unit.num = this.units.length;
                    try {
                        UnitData[] new_units = new UnitData[this.units.length + 1];
                        int i = 0;
                        while (i < this.units.length) {
                            new_units[i] = this.units[i];
                            ++i;
                        }
                        new_units[new_units.length - 1] = unit;
                        this.units = new_units;
                    }
                    catch (Exception ex) {
                        AbstractActivity.HandleError(ex);
                    }
                    unit.model = AbstractUnit.Factory(this, unit);
                    this.root_node.attachChild(unit.model);
                    unit.updateModelFromUnitData();
                    this.root_node.updateGeometricState();
                    this.recalcVisibleEnemiesAndOppFire(true, null);
                    this.addToHUD("Blob has split.");
                    this.updateMenu((byte)2);
                }
            } else {
                this.addToHUD(act.getString("no_room"));
            }
        } else {
            this.addToHUD("Blob is too small to split!  6 HP required.");
        }
    }

    public UnitData getUnitAt(int map_x, int map_z) {
        int i = 0;
        while (i < this.units.length) {
            UnitData unit = this.units[i];
            if (unit.getStatus() == 2 && unit.getMapX() == map_x && unit.getMapY() == map_z) {
                return unit;
            }
            ++i;
        }
        return null;
    }

    public UnitData getDeadUnitAt(int map_x, int map_z) {
        int i = 0;
        while (i < this.units.length) {
            UnitData unit = this.units[i];
            if (unit.getStatus() == 3 && unit.getMapX() == map_x && unit.getMapY() == map_z) {
                return unit;
            }
            ++i;
        }
        return null;
    }

    public void showPrimeMenu() {
        AbstractActivity act = Statics.act;
        this.icon_table.less_icon.action = this.icon_table.do_prime_icon;
        this.icon_table.more_icon.action = this.icon_table.do_prime_icon;
        this.updateMenu((byte)9);
        this.addToHUD(String.valueOf(act.getString("priming_help")) + ":-");
        this.addToHUD("0 - " + act.getString("ph_end_of_turn"));
        if (this.game_data.num_players == 2) {
            this.addToHUD("1 - " + act.getString("ph_end_opp_turn"));
            this.addToHUD("2 - " + act.getString("ph_end_next_turn"));
            this.addToHUD("4 - End of your second next turn");
        } else if (this.game_data.num_players == 3) {
            this.addToHUD("1 - " + act.getString("ph_end_opp1_turn"));
            this.addToHUD("2 - " + act.getString("ph_end_opp2_turn"));
            this.addToHUD("3 - " + act.getString("ph_end_next_turn"));
            this.addToHUD("6 - End of your second next turn");
        } else if (this.game_data.num_players == 4) {
            this.addToHUD("1 - " + act.getString("ph_end_opp1_turn"));
            this.addToHUD("2 - " + act.getString("ph_end_opp2_turn"));
            this.addToHUD("3 - " + act.getString("ph_end_opp3_turn"));
            this.addToHUD("4 - " + act.getString("ph_end_next_turn"));
            this.addToHUD("8 - End of your second next turn");
        }
        this.addToHUD(act.getString("ph_and_so_on"));
    }

    private void blobDoExplode(UnitData blob) {
        int DAMAGE = blob.getBlobExplodeDamage();
        int RAD = blob.getBlobExplodeRad();
        this.normalExplosion(blob.map_x, blob.map_y, RAD, DAMAGE, blob, false, false);
    }

    public void blobAttemptExplode() {
        if (this.current_unit.checkAndReduceAPs(this, 20) && this.current_unit != null) {
            UnitData this_unit = this.current_unit;
            this.current_unit.damage(this, this.current_unit.getHealth(), this.current_unit, 3);
            this.updateUnitOnServer(this_unit);
            this.blobDoExplode(this_unit);
        }
    }

    public void showExplosionsAndEndTurn() {
        this.hud.clearText();
        this.addToHUD("Please wait...");
        this.current_unit = null;
        this.time_since_last_explosion = 0L;
        this.client_mode = (byte)5;
        this.updateMenu((byte)10);
        int i = 0;
        while (i < this.units.length) {
            if (this.units[i].getStatus() == 2 && this.units[i].aps > 0) {
                this.units[i].checkForNerveGasAndFire(this, this.units[i].aps);
            }
            ++i;
        }
        int turns_in_advance_to_check = this.getTurnsInAdvanceToCheck();
        int i2 = 0;
        while (i2 < this.equipment.length) {
            EquipmentData eq = this.equipment[i2];
            if (!eq.destroyed && eq.primed && eq.explode_turns <= turns_in_advance_to_check && (eq.major_type == 2 || eq.major_type == 11 || eq.major_type == 21 || eq.major_type == 22 || eq.major_type == 34)) {
                UnitData caused_by = null;
                if (eq.last_unit_to_touch > 0) {
                    caused_by = UnitData.GetUnitDataFromID(this.units, eq.last_unit_to_touch);
                }
                this.scheduleExplosion(eq, caused_by);
            }
            ++i2;
        }
    }

    private int getTurnsInAdvanceToCheck() {
        if (this.game_data.num_players <= 2) {
            return 0;
        }
        int ret = 0;
        int s = this.game_data.our_side;
        int i = 0;
        while (i < this.game_data.num_players) {
            if (++s > this.game_data.num_players) {
                s = 1;
            }
            if (this.game_data.units_remaining[s] > 0) break;
            ++ret;
            ++i;
        }
        return ret;
    }

    private void explodeGrenade(EquipmentData grenade, UnitData caused_by_unit) {
        this.waitForPendingUpdateRequests();
        Point p = grenade.getMapLocation(this.units, this.mapdata);
        int mapx = p.x;
        int mapz = p.y;
        grenade.equipmentDestroyed(this);
        if (grenade.major_type == 21 || grenade.major_type == 22 || grenade.major_type == 34) {
            this.smokeGrenadeOrNerveGasExplosion(mapx, mapz, grenade.explosion_rad, grenade.major_type, caused_by_unit);
        } else {
            this.normalExplosion(mapx, mapz, grenade.explosion_rad, grenade.explosion_dam, caused_by_unit, grenade.major_type == 11, false);
        }
        if (grenade.model != null) {
            grenade.model.removeFromParent();
        }
    }

    private void smokeGrenadeOrNerveGasExplosion(int mapx, int mapz, int radius, byte eq_type, UnitData caused_by_unit) {
        AbstractActivity act = Statics.act;
        this.addToHUD(act.getString("been_explosion"));
        this.sendEventToServer_Explosion(mapx, mapz, radius, eq_type);
        HashSet<MapSquare> changed_squares = new HashSet<MapSquare>();
        int caused_by_unitid = -1;
        if (caused_by_unit != null) {
            caused_by_unitid = caused_by_unit.unitid;
        }
        int tot_existing_smoke = 0;
        int r = 0;
        while (r <= radius) {
            tot_existing_smoke += this.checkForSmokeAccess_init(mapx, mapz, r, radius, eq_type, caused_by_unitid, changed_squares);
            ++r;
        }
        if (tot_existing_smoke > 0) {
            r = 0;
            while (r <= radius * 4) {
                if (tot_existing_smoke > 0) {
                    tot_existing_smoke = this.checkForSmokeAccess_extra(mapx, mapz, r, r + 1, eq_type, caused_by_unitid, changed_squares, tot_existing_smoke);
                }
                ++r;
            }
        }
        this.createMapModel();
        this.root_node.updateGeometricState();
        this.showExplosion(mapx, mapz, radius, eq_type);
    }

    private void normalExplosion(int mapx, int mapy, int map_radius, int damage, UnitData caused_by_unit, boolean explosives, boolean alien_acid) {
        boolean any_dam;
        int i;
        boolean hit;
        int wall_count;
        float dist;
        AbstractActivity act = Statics.act;
        if (map_radius <= 0) {
            map_radius = 1;
        }
        this.root_cam.vibrate(2000L);
        this.addToHUD(act.getString("been_explosion"));
        this.sendEventToServer_Explosion(mapx, mapy, map_radius, (byte)2);
        int i2 = 0;
        while (i2 < this.units.length) {
            if (this.units[i2].getStatus() == 2 && (this.units[i2].model_type != 3 && this.units[i2].model_type != 7 || !alien_acid) && (dist = this.units[i2].model.getMapDistTo(mapx, mapy)) <= (float)map_radius) {
                wall_count = this.units[i2].model.getExplosionWallProtectionCount(mapx, mapy);
                hit = true;
                if (this.game_data.wall_type == 0) {
                    hit = wall_count <= 0;
                } else if (this.game_data.wall_type == 1) {
                    boolean bl = hit = wall_count <= 1;
                }
                if (explosives || hit) {
                    int dam = this.randomizeDamage(damage);
                    if (dist >= 1.0f) {
                        int x = this.units[i2].map_x - mapx;
                        int y = this.units[i2].map_y - mapy;
                        float ang = GeometryFuncs.NormalizeAngle(GeometryFuncs.GetAngleFromDirection(x, y));
                        float angle_mult = GameModule.GetAdjustmentForAngle(ang, this.units[i2].angle);
                        dam -= (int)((float)this.units[i2].protection * angle_mult);
                    } else {
                        GameModule.p("Unit is on top of grenade!");
                    }
                    GameModule.p("Final damage: " + dam);
                    this.units[i2].damage(this, dam, caused_by_unit, 3);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.equipment.length) {
            if (!this.equipment[i2].destroyed && this.equipment[i2].getUnitID() <= 0 && this.equipment[i2].indestructable == 0 && this.equipment[i2].model != null && (dist = this.equipment[i2].model.getMapDistTo(mapx, mapy)) <= (float)map_radius) {
                wall_count = this.equipment[i2].model.getExplosionWallProtectionCount(mapx, mapy);
                hit = true;
                if (this.game_data.wall_type == 0) {
                    hit = wall_count <= 0;
                } else if (this.game_data.wall_type == 1) {
                    boolean bl = hit = wall_count <= 1;
                }
                if (explosives || hit) {
                    int rnd = NumberFunctions.rnd(1, 100);
                    if (this.equipment[i2].major_type == 2 || this.equipment[i2].major_type == 11 || this.equipment[i2].major_type == 23 || this.equipment[i2].major_type == 21 || this.equipment[i2].major_type == 22) {
                        if (rnd <= 50) {
                            this.scheduleExplosion(this.equipment[i2], caused_by_unit);
                        }
                    } else if (rnd <= 50) {
                        this.equipment[i2].equipmentDestroyed(this);
                    }
                }
            }
            ++i2;
        }
        boolean any_walls_destroyed = false;
        int side = -1;
        if (caused_by_unit != null) {
            side = caused_by_unit.getSide();
        }
        if ((this.game_data.wall_type == 2 || explosives) && !alien_acid) {
            any_walls_destroyed = this.checkForWallDamage_WEAK_WALLS(mapx, mapy, map_radius, side);
        } else if (this.game_data.wall_type == 1) {
            i = map_radius;
            while (i >= 0) {
                any_dam = this.checkForWallDamage_STRONG_WALLS(mapx, mapy, i, map_radius, side);
                any_walls_destroyed = any_walls_destroyed || any_dam;
                --i;
            }
        } else if (this.game_data.wall_type == 0 || alien_acid) {
            i = map_radius;
            while (i >= 0) {
                any_dam = this.checkForWallDamage_SOLID_WALLS(mapx, mapy, i, map_radius, side);
                any_walls_destroyed = any_walls_destroyed || any_dam;
                --i;
            }
        }
        if (any_walls_destroyed) {
            this.createMapModel();
        }
        this.root_node.updateGeometricState();
        this.showExplosion(mapx, mapy, map_radius, (byte)2);
    }

    private boolean checkForWallDamage_WEAK_WALLS(int mapx, int mapz, int this_rad, int caused_by_side) {
        boolean any_walls_destroyed = false;
        int z = mapz - this_rad;
        while (z <= mapz + this_rad) {
            int x = mapx - this_rad;
            while (x <= mapx + this_rad) {
                double dist;
                MapSquare sq = this.mapdata.getSq_MaybeNULL(x, z);
                if (sq != null && (dist = GeometryFuncs.distance(x, z, mapx, mapz)) <= (double)this_rad) {
                    boolean is_this_destroyed = false;
                    if (sq.major_type == 3) {
                        is_this_destroyed = true;
                    } else if (sq.major_type == 1) {
                        if (sq.door_type > 0) {
                            sq.door_type = (byte)-1;
                        }
                        is_this_destroyed = true;
                        if (sq.smoke_type > 0 && NumberFunctions.rnd(1, 2) == 1) {
                            sq.smoke_type = 0;
                        }
                    } else if (sq.major_type == 2 && sq.destroyed == 0) {
                        is_this_destroyed = true;
                        this.addToHUD("Computer destroyed!");
                    }
                    if (is_this_destroyed) {
                        if (sq.major_type != 2) {
                            sq.major_type = 1;
                            sq.texture_code = TextureStateCache.GetRandomRubbleTex();
                            sq.scenery_code = 0;
                            sq.raised_texture_code = 0;
                            any_walls_destroyed = true;
                        }
                        sq.destroyed = 1;
                        this.updateMapOnServer(sq, caused_by_side);
                    }
                }
                ++x;
            }
            ++z;
        }
        return any_walls_destroyed;
    }

    private boolean checkForWallDamage_STRONG_WALLS(int epicentre_mapx, int epicentre_mapz, int this_rad, int max_rad, int caused_by_side) {
        boolean any_walls_destroyed = false;
        int z = epicentre_mapz - this_rad;
        while (z <= epicentre_mapz + this_rad) {
            int x = epicentre_mapx - this_rad;
            while (x <= epicentre_mapx + this_rad) {
                MapSquare sq;
                double dist;
                if ((z == epicentre_mapz - this_rad || z == epicentre_mapz + this_rad || x == epicentre_mapx - this_rad || x == epicentre_mapx + this_rad) && this.mapdata.isLOS_Faces(epicentre_mapx, epicentre_mapz, x, z, true, true) && (dist = GeometryFuncs.distance(x, z, epicentre_mapx, epicentre_mapz)) <= (double)max_rad && (sq = this.mapdata.getSq_MaybeNULL(x, z)) != null) {
                    boolean is_this_destroyed = false;
                    if (sq.major_type == 3) {
                        is_this_destroyed = true;
                    } else if (sq.major_type == 1) {
                        if (sq.door_type > 0) {
                            sq.door_type = (byte)-1;
                        }
                        is_this_destroyed = true;
                        if (sq.smoke_type > 0 && NumberFunctions.rnd(1, 2) == 1) {
                            sq.smoke_type = 0;
                        }
                    } else if (sq.major_type == 2 && sq.destroyed == 0) {
                        is_this_destroyed = true;
                        this.addToHUD("Computer destroyed!");
                    }
                    if (is_this_destroyed) {
                        if (sq.major_type != 2) {
                            sq.major_type = 1;
                            sq.texture_code = TextureStateCache.GetRandomRubbleTex();
                            sq.scenery_code = 0;
                            sq.raised_texture_code = 0;
                            any_walls_destroyed = true;
                        }
                        sq.destroyed = 1;
                        this.updateMapOnServer(sq, caused_by_side);
                    }
                }
                ++x;
            }
            ++z;
        }
        return any_walls_destroyed;
    }

    private boolean checkForWallDamage_SOLID_WALLS(int mapx, int mapz, int this_rad, int max_rad, int caused_by_side) {
        boolean any_walls_destroyed = false;
        int z = mapz - this_rad;
        while (z <= mapz + this_rad) {
            int x = mapx - this_rad;
            while (x <= mapx + this_rad) {
                MapSquare sq;
                if ((x == mapx - this_rad || x == mapx + this_rad || z == mapz - this_rad || z == mapz + this_rad) && (sq = this.mapdata.getSq_MaybeNULL(x, z)) != null && this.mapdata.isLOS_Faces(mapx, mapz, x, z, true, true)) {
                    boolean is_this_destroyed = false;
                    double dist = GeometryFuncs.distance(x, z, mapx, mapz);
                    if (dist <= (double)max_rad) {
                        if (sq.major_type != 0 && sq.major_type != 3) {
                            if (sq.major_type == 1) {
                                if (sq.door_type > 0) {
                                    sq.door_type = (byte)-1;
                                    is_this_destroyed = true;
                                    sq.texture_code = TextureStateCache.GetRandomRubbleTex();
                                }
                                if (sq.smoke_type > 0 && NumberFunctions.rnd(1, 2) == 1) {
                                    sq.smoke_type = 0;
                                }
                            } else if (sq.major_type == 2 && sq.destroyed == 0) {
                                sq.destroyed = 1;
                                is_this_destroyed = true;
                                this.addToHUD("Computer destroyed!");
                            }
                        }
                        if (is_this_destroyed) {
                            sq.scenery_code = 0;
                            sq.raised_texture_code = 0;
                            this.updateMapOnServer(sq, caused_by_side);
                            any_walls_destroyed = true;
                        }
                    }
                }
                ++x;
            }
            ++z;
        }
        return any_walls_destroyed;
    }

    private int checkForSmokeAccess_init(int mapx, int mapz, int this_rad, int max_rad, byte eq_type, int caused_by_unitid, HashSet<MapSquare> changed_squares) {
        int existing_smoke_count = 0;
        int z = mapz - this_rad;
        while (z <= mapz + this_rad) {
            int x = mapx - this_rad;
            while (x <= mapx + this_rad) {
                MapSquare sq;
                if ((x == mapx - this_rad || x == mapx + this_rad || z == mapz - this_rad || z == mapz + this_rad) && GeometryFuncs.distance(mapx, mapz, x, z) <= (double)max_rad && (sq = this.mapdata.getSq_MaybeNULL(x, z)) != null && this.mapdata.getBlockCountInLOS_Pixels_Centre(mapx, mapz, x, z, true, false) <= 0 && sq.major_type == 1 && this.replaceSmoke(sq, eq_type, caused_by_unitid)) {
                    ++existing_smoke_count;
                    changed_squares.add(sq);
                }
                ++x;
            }
            ++z;
        }
        return existing_smoke_count;
    }

    private int checkForSmokeAccess_extra(int mapx, int mapz, int this_rad, int max_rad, byte eq_type, int caused_by_unitid, HashSet<MapSquare> changed_squares, int extra_count) {
        if (extra_count <= 0) {
            return 0;
        }
        int z = mapz - this_rad;
        while (z <= mapz + this_rad) {
            int x = mapx - this_rad;
            while (x <= mapx + this_rad) {
                MapSquare sq;
                if ((x == mapx - this_rad || x == mapx + this_rad || z == mapz - this_rad || z == mapz + this_rad) && GeometryFuncs.distance(mapx, mapz, x, z) <= (double)max_rad && (sq = this.mapdata.getSq_MaybeNULL(x, z)) != null && this.mapdata.getBlockCountInLOS_Pixels_Centre(mapx, mapz, x, z, true, false) <= 0 && sq.major_type == 1) {
                    if (this.replaceSmoke(sq, eq_type, caused_by_unitid)) {
                        ++extra_count;
                        changed_squares.add(sq);
                    }
                    if (--extra_count == 0) {
                        return 0;
                    }
                }
                ++x;
            }
            ++z;
        }
        return extra_count;
    }

    private boolean replaceSmoke(MapSquare sq, byte new_type, int caused_by_unitid) {
        byte curr_type = sq.smoke_type;
        if (curr_type == new_type) {
            return false;
        }
        if (curr_type == 34) {
            return false;
        }
        if (curr_type == 22 && new_type != 34) {
            return false;
        }
        sq.smoke_type = new_type;
        sq.smoke_caused_by = caused_by_unitid;
        this.updateMapOnServer(sq, 0);
        return true;
    }

    private void showExplosion(int mapx, int mapy, float map_radius, byte gren_type) {
        AbstractActivity act = Statics.act;
        if (gren_type == 21) {
            act.playSound("smokegrenadehiss");
        } else if (gren_type == 22) {
            act.playSound("nervegashiss");
        } else {
            act.playSound("explosion1");
        }
        this.current_unit = null;
        this.updateMenu((byte)1);
        this.root_cam.lookAt((float)mapx * Statics.SQ_SIZE, (float)mapy * Statics.SQ_SIZE, true);
        float rad = map_radius * Statics.SQ_SIZE;
        new Explosion(this, (float)mapx * Statics.SQ_SIZE + Statics.SQ_SIZE / 2.0f, (float)mapy * Statics.SQ_SIZE + Statics.SQ_SIZE / 2.0f, rad);
    }

    private int randomizeDamage(int dam) {
        return (int)((float)dam * NumberFunctions.rndFloat(0.5f, 1.5f));
    }

    public void openDoor() {
        AbstractActivity act = Statics.act;
        MapSquare sq = this.current_unit.model.getSquareInFrontOfUnit_MaybeNULL();
        if (sq != null) {
            if (sq.door_type > 0) {
                if (!sq.door_open) {
                    if (this.current_unit.checkAndReduceAPs(this, 8)) {
                        this.updateUnitOnServer(this.current_unit);
                        act.playSound("door");
                        if (sq.door != null) {
                            sq.door.startOpening();
                            sq.door.opposite.startOpening();
                        }
                        sq.door_open = true;
                        this.updateMapOnServer(sq, -1);
                        this.recalcVisibleEnemiesAndOppFire(true, null);
                        this.updateMenu((byte)2);
                    }
                } else {
                    this.addToHUD(act.getString("door_already_open"));
                }
            } else {
                this.addToHUD(act.getString("no_door"));
            }
        }
    }

    public void closeDoor() {
        AbstractActivity act = Statics.act;
        MapSquare sq = this.current_unit.model.getSquareInFrontOfUnit_MaybeNULL();
        if (sq != null) {
            if (sq.door_type > 0) {
                if (sq.door_open) {
                    UnitData unit = this.getUnitAt(sq.x, sq.y);
                    if (unit == null) {
                        ArrayList<EquipmentData> al = sq.getEquipment_MaybeNULL();
                        if (al == null || al.size() == 0) {
                            if (this.current_unit.checkAndReduceAPs(this, 8)) {
                                this.updateUnitOnServer(this.current_unit);
                                act.playSound("door");
                                if (sq.door != null) {
                                    sq.door.startClosing();
                                    sq.door.opposite.startClosing();
                                }
                                sq.door_open = false;
                                this.updateMapOnServer(sq, -1);
                                this.updateMenu((byte)2);
                            }
                        } else {
                            this.addToHUD(act.getString("equipment_in_the_way"));
                        }
                    } else {
                        this.addToHUD(act.getString("already_a_unit"));
                    }
                } else {
                    this.addToHUD(act.getString("door_already_closed"));
                }
            } else {
                this.addToHUD(act.getString("no_door"));
            }
        }
    }

    public void changeCurrentEquipment(EquipmentData eq) {
        if (this.current_unit != null) {
            if (this.current_unit.current_item != null && eq == this.current_unit.current_item) {
                this.updateMenu((byte)2);
                return;
            }
            int cost = 13;
            if (this.current_unit.checkAndReduceAPs(this, cost)) {
                this.current_unit.current_item = eq;
                this.updateMenu((byte)2);
                this.updateEquipmentOnServer(eq, this.current_unit.getMapX(), this.current_unit.getMapY());
                this.updateUnitOnServer(this.current_unit);
            }
        }
    }

    public void escape() {
        MapSquare sq = this.mapdata.getSq_MaybeNULL(this.current_unit.map_x, this.current_unit.map_y);
        if (sq != null && (sq.escape_hatch_side == this.current_unit.getSide() || sq.escape_hatch_side > 4)) {
            this.current_unit.escaped(this);
        }
    }

    public void pickupEquipment(EquipmentData eq) {
        AbstractActivity act = Statics.act;
        if (this.current_unit != null) {
            if (eq.weight <= this.current_unit.strength) {
                int cost = 8;
                if (this.current_unit.current_item != null) {
                    cost *= 2;
                }
                if (this.current_unit.checkAndReduceAPs(this, cost)) {
                    eq.model.removeFromParent();
                    eq.model = null;
                    eq.setUnitID(this.current_unit.unitid);
                    MapSquare sq = this.mapdata.getSq_MaybeNULL(this.current_unit.getMapX(), this.current_unit.getMapY());
                    if (sq != null) {
                        sq.removeEquipment(eq);
                    }
                    this.current_unit.current_item = eq;
                    this.current_unit.items.add(eq);
                    int s = 1;
                    while (s <= 4) {
                        eq.seen_by_side[s] = 0;
                        ++s;
                    }
                    this.updateMenu((byte)2);
                    this.updateEquipmentOnServer(eq, this.current_unit.getMapX(), this.current_unit.getMapY());
                    this.updateUnitOnServer(this.current_unit);
                    boolean[] who_can_see = this.whichSidesCanSeeUnit(this.current_unit);
                    this.sendEventToServer_ItemPickedUp(this.current_unit, who_can_see);
                }
            } else {
                this.addToHUD(act.getString("too_heavy"));
            }
        }
    }

    public void makeAimedShot() {
        AbstractActivity act = Statics.act;
        this.addToHUD(act.getString("attempting_aimed"));
        this.shoot(this.current_unit, GameModule.GetAimedShotAccuracy(this.current_unit), this.current_unit.current_item.aimed_shot_aps, true, null);
    }

    public void makeSnapShot() {
        AbstractActivity act = Statics.act;
        this.addToHUD(act.getString("attempting_snap"));
        this.shoot(this.current_unit, GameModule.GetSnapShotAccuracy(this.current_unit), this.current_unit.current_item.snap_shot_aps, true, null);
    }

    public void makeAutoShot() {
        AbstractActivity act = Statics.act;
        this.addToHUD(act.getString("attempting_auto"));
        this.shoot(this.current_unit, GameModule.GetAutoShotAccuracy(this.current_unit), this.current_unit.current_item.auto_shot_aps, true, null);
    }

    public void shoot(UnitData shooter, int acc, int ap_cost, boolean show_bullet, Ray targetting_ray) {
        AbstractActivity act = Statics.act;
        EquipmentData gun = shooter.current_item;
        if (gun != null && gun.major_type == 1) {
            if (gun.getAmmo() > 0) {
                float ang;
                float diff;
                if (targetting_ray == null) {
                    targetting_ray = new Ray(this.shot_line);
                }
                if ((diff = GeometryFuncs.GetDiffBetweenAngles(ang = targetting_ray.getAngle(), shooter.getAngle())) < 49.0f) {
                    if (shooter.checkAndReduceAPs(this, ap_cost)) {
                        this.updateUnitOnServer(shooter);
                        gun.decAmmo();
                        this.updateEquipmentOnServer(gun, -1, -1);
                        this.hud.updateStatusBar();
                        Ray actual_shot_ray = new Ray(targetting_ray);
                        float angle_adj = 0.0f;
                        int rnd = NumberFunctions.rnd(0, 100);
                        if (rnd < acc) {
                            angle_adj = NumberFunctions.rndFloat(0.0f, 0.5f);
                        } else {
                            float badness = (rnd - acc) / 3;
                            angle_adj = NumberFunctions.rndFloat(2.0f, 2.0f + badness);
                        }
                        if (angle_adj != 0.0f) {
                            if (NumberFunctions.rnd(0, 1) == 1) {
                                angle_adj *= -1.0f;
                            }
                            actual_shot_ray.setDirection(GeometryFuncs.AdjustVectorByAngle(actual_shot_ray.getDirection(), angle_adj));
                        }
                        MyPickResults results = new MyPickResults(shooter.model, null);
                        this.root_node.findPick(actual_shot_ray, results);
                        this.mapdata.canSee(actual_shot_ray, results, true, false);
                        results.sort();
                        boolean bullet_created = false;
                        if (results.getNumber() > 0) {
                            int i = 0;
                            while (i < results.getNumber()) {
                                int rnd2;
                                PickData o = results.getPickData(i);
                                GameObject target = results.getGameObject(i);
                                if (!(!target.can_be_shot || o.getDistance() >= 1.5f * Statics.SQ_SIZE && target.isChanceofNotHitting() && (rnd2 = NumberFunctions.rnd(1, 100)) < target.getChanceofNotHitting())) {
                                    boolean[] seen = this.whichSidesCanSeeUnit(shooter);
                                    this.sendEventToServer_ShotFired(shooter, (int)actual_shot_ray.getAngle(), (int)(o.getDistance() / Statics.SQ_SIZE), seen);
                                    if (gun.range_sq <= 0 || !(o.getDistance() > (float)gun.range_sq * Statics.SQ_SIZE)) {
                                        MyPointF vdiff = actual_shot_ray.getDirection().multiply(o.getDistance());
                                        MyPointF end = actual_shot_ray.getOrigin().add(vdiff);
                                        bullet_created = true;
                                        if (gun.code.equalsIgnoreCase("FIREEXT")) {
                                            new FireExtinguisherEffect(this, shooter.model.getWorldTopLeft_CreatesNew(), end);
                                            act.playSound("smokegrenadehiss");
                                            shooter.on_fire = 0;
                                            if (!(target instanceof AbstractUnit)) break;
                                            AbstractUnit unit_target = (AbstractUnit)target;
                                            if (unit_target.unit_data.on_fire == 0) break;
                                            unit_target.unit_data.on_fire = 0;
                                            this.updateUnitOnServer(unit_target.unit_data);
                                            this.addToHUD("The fire has been extinguished.");
                                            break;
                                        }
                                        if (gun.code.equalsIgnoreCase("FLAMETHROWER")) {
                                            new FlameThrowerEffect(this, shooter.model.getWorldTopLeft_CreatesNew(), end);
                                            act.playSound("fire");
                                            if (!(target instanceof AbstractUnit)) break;
                                            AbstractUnit unit_target = (AbstractUnit)target;
                                            if (unit_target.unit_data.on_fire != 0) break;
                                            if (unit_target.unit_data.model_type != 14) {
                                                unit_target.unit_data.on_fire = 1;
                                            }
                                            act.playSound("fire");
                                            this.updateUnitOnServer(unit_target.unit_data);
                                            this.addToHUD("A unit has been set on fire!");
                                            break;
                                        }
                                        if (gun.ammo_type_id != 2) {
                                            new BulletLaser(this, shooter.model.getWorldCentre_CreatesNew(), end, false, show_bullet);
                                        } else {
                                            new Bullet(this, shooter.model.getWorldCentre_CreatesNew(), end, true, show_bullet, "laser_bolt", 3, Statics.BULLET_SIZE);
                                        }
                                        act.playSound("laser4");
                                        if (target instanceof AbstractUnit) {
                                            AbstractUnit unit_target = (AbstractUnit)target;
                                            if (shooter == this.current_unit) {
                                                this.addToHUD(String.valueOf(act.getString("you_have_shot")) + " " + unit_target.unit_data.name);
                                            }
                                            int dam = gun.shot_damage;
                                            dam = this.randomizeDamage(dam);
                                            float ang_adj = GameModule.GetAdjustmentForAngle(GeometryFuncs.GetAngleFromDirection(actual_shot_ray.direction.x, actual_shot_ray.direction.y), unit_target.unit_data.getAngle());
                                            float protec = (float)unit_target.unit_data.protection * ang_adj;
                                            dam = (int)((float)dam - protec);
                                            int map_dist = (int)shooter.model.getMapDistTo(target);
                                            if (map_dist < 2) {
                                                dam += 5;
                                                GameModule.p("Short-range bonus: 5");
                                            } else if ((float)map_dist >= 10.0f && gun.ammo_type_id != 2) {
                                                int reduction = (int)(((float)map_dist - 10.0f) / 2.0f);
                                                int max_reduction = dam / 2;
                                                if (reduction > max_reduction) {
                                                    reduction = max_reduction;
                                                }
                                                dam -= reduction;
                                            }
                                            unit_target.unit_data.damage(this, dam, shooter, 1);
                                        } else if (target instanceof GasCannister) {
                                            GasCannister gc = (GasCannister)target;
                                            this.scheduleExplosion(gc.eq, shooter);
                                            gc.removeFromParent();
                                        } else if (target instanceof DummyWall) {
                                            DummyWall w = (DummyWall)target;
                                            if (w.sq.major_type == 2) {
                                                this.computerDestroyed(w.sq, shooter);
                                            } else if (shooter == this.current_unit) {
                                                int x;
                                                this.addToHUD(act.getString("shot_wall"));
                                                if (this.is_april_fools_day && (x = NumberFunctions.rnd(0, 10)) == 0) {
                                                    this.addToHUD("Did you miss deliberately?");
                                                }
                                            }
                                        }
                                        if (gun.explodes) {
                                            MyPointF vdiff2 = actual_shot_ray.getDirection().multiply(o.getDistance() - 1.0f);
                                            MyPointF end2 = actual_shot_ray.getOrigin().add(vdiff2);
                                            this.normalExplosion((int)(end2.x / Statics.SQ_SIZE), (int)(end2.y / Statics.SQ_SIZE), gun.explosion_rad, gun.explosion_dam, shooter, false, false);
                                            this.recalcVisibleEnemiesAndOppFire(true, null);
                                            break;
                                        }
                                        this.recalcVisibleEnemiesAndOppFire(true, shooter);
                                        break;
                                    }
                                }
                                ++i;
                            }
                        }
                        if (!bullet_created) {
                            int x;
                            MyPointF end;
                            MyPointF vdiff;
                            if (gun.code.equalsIgnoreCase("FIREEXT")) {
                                vdiff = actual_shot_ray.getDirection().multiply(Statics.SQ_SIZE * (float)gun.range_sq);
                                end = actual_shot_ray.getOrigin().add(vdiff);
                                new FireExtinguisherEffect(this, shooter.model.getWorldTopLeft_CreatesNew(), end);
                                act.playSound("smokegrenadehiss");
                                shooter.on_fire = 0;
                            } else if (gun.code.equalsIgnoreCase("FLAMETHROWER")) {
                                vdiff = actual_shot_ray.getDirection().multiply(Statics.SQ_SIZE * (float)gun.range_sq);
                                end = actual_shot_ray.getOrigin().add(vdiff);
                                new FlameThrowerEffect(this, shooter.model.getWorldTopLeft_CreatesNew(), end);
                                act.playSound("fire");
                            } else {
                                vdiff = actual_shot_ray.getDirection().multiply(Statics.SQ_SIZE * (float)this.mapdata.getMapHeight());
                                end = actual_shot_ray.getOrigin().add(vdiff);
                                if (gun.ammo_type_id != 2) {
                                    new BulletLaser(this, shooter.model.getWorldCentre_CreatesNew(), end, false, !show_bullet);
                                } else {
                                    new Bullet(this, shooter.model.getWorldCentre_CreatesNew(), end, false, !show_bullet, "laser_bolt", 3, Statics.BULLET_SIZE);
                                }
                                act.playSound("laser4");
                            }
                            bullet_created = true;
                            boolean[] seen = this.whichSidesCanSeeUnit(shooter);
                            this.sendEventToServer_ShotFired(shooter, (int)GeometryFuncs.GetAngleFromDirection(actual_shot_ray.direction.x, actual_shot_ray.direction.y), 10, seen);
                            if (this.is_april_fools_day && (x = NumberFunctions.rnd(0, 10)) == 0) {
                                this.addToHUD("My granny could have done better.");
                            }
                        }
                    }
                } else if (shooter == this.current_unit) {
                    this.addToHUD(act.getString("not_in_view"));
                    if (this.help_mode_on) {
                        this.addToHUD(act.getString("white_line_help"));
                    }
                }
            } else if (shooter == this.current_unit) {
                this.addToHUD(act.getString("out_of_ammo"));
            }
        }
    }

    public boolean selectNextUnit() {
        if (this.game_data.game_status == 30) {
            int curr_id = 0;
            if (this.current_unit != null) {
                curr_id = this.current_unit.num;
            }
            int i = curr_id + 1;
            while (i < this.units.length) {
                if (this.units[i].getSide() == this.game_data.our_side && !this.units[i].hasAI() && this.units[i].getStatus() == 2) {
                    this.selectOurUnit(this.units[i], false);
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < this.units.length) {
                if (this.units[i].getSide() == this.game_data.our_side && !this.units[i].hasAI() && this.units[i].getStatus() == 2) {
                    this.selectOurUnit(this.units[i], false);
                    return false;
                }
                ++i;
            }
        }
        return false;
    }

    public void selectPrevUnit() {
        if (this.game_data.game_status == 30) {
            int curr_id = 0;
            if (this.current_unit != null) {
                curr_id = this.current_unit.num;
            }
            int i = curr_id - 1;
            while (i >= 0) {
                if (this.units[i].getSide() == this.game_data.our_side && !this.units[i].hasAI() && this.units[i].getStatus() == 2) {
                    this.selectOurUnit(this.units[i], false);
                    return;
                }
                --i;
            }
            i = this.units.length - 1;
            while (i >= 0) {
                if (this.units[i].getSide() == this.game_data.our_side && !this.units[i].hasAI() && this.units[i].getStatus() == 2) {
                    this.selectOurUnit(this.units[i], false);
                    return;
                }
                --i;
            }
        }
    }

    private void createMapModel() {
        if (this.mapdata == null) {
            throw new RuntimeException("mapdata is null!");
        }
        if (this.map_model != null) {
            this.map_model.removeFromParent();
            this.map_model = null;
            System.gc();
        }
        this.map_model = new MapNode(this);
        this.attachToRootNode(0, this.map_model, true);
        this.map_model.updateGeometricState();
    }

    public void reload() {
        AbstractActivity act = Statics.act;
        if (this.current_unit != null) {
            EquipmentData gun = this.current_unit.current_item;
            if (gun != null && gun.major_type == 1) {
                EquipmentData ammo = this.findAmmo(gun.ammo_type_id);
                if (ammo != null) {
                    if (this.current_unit.checkAndReduceAPs(this, gun.reload_cost)) {
                        while (gun.getAmmoCapacity() > gun.getAmmo() && ammo.getAmmo() > 0) {
                            gun.incAmmo();
                            ammo.decAmmo();
                        }
                        this.updateUnitOnServer(this.current_unit);
                        this.updateEquipmentOnServer(gun, -1, -1);
                        this.updateEquipmentOnServer(ammo, -1, -1);
                        if (ammo.getAmmo() <= 0) {
                            ammo.equipmentDestroyed(this);
                        }
                        this.updateMenu((byte)2);
                        this.addToHUD(act.getString("weapon_reloaded"));
                    }
                } else {
                    this.addToHUD(act.getString("no_clip_found"));
                }
            }
        } else {
            this.updateMenu((byte)1);
        }
    }

    private EquipmentData findAmmo(int type) {
        EquipmentData eq_most_ammo = null;
        int i = 0;
        while (i < this.current_unit.items.size()) {
            EquipmentData eq = this.current_unit.items.get(i);
            if (eq.major_type == 5 && eq.ammo_type_id == type) {
                if (eq_most_ammo == null) {
                    eq_most_ammo = eq;
                } else if (eq_most_ammo.ammo_capacity < eq.ammo_capacity) {
                    eq_most_ammo = eq;
                }
            }
            ++i;
        }
        return eq_most_ammo;
    }

    public void useMedikit(boolean self) {
        AbstractActivity act = Statics.act;
        if (this.current_unit != null) {
            EquipmentData eq = this.current_unit.current_item;
            if (eq != null) {
                if (eq.major_type == 3) {
                    UnitData target_unit = this.current_unit;
                    if (!self && (target_unit = this.current_unit.model.getUnitInFrontOfUnit_MaybeNULL()) == null) {
                        this.addToHUD("Comrade not found!");
                        return;
                    }
                    if (target_unit.getHealth() < target_unit.max_health) {
                        if (this.current_unit.checkAndReduceAPs(this, 20)) {
                            this.current_unit.removeItem(this, eq, false);
                            target_unit.incHealth(eq.shot_damage);
                            this.addToHUD(act.getString("medikit_used"));
                            this.updateUnitOnServer(this.current_unit);
                            if (this.current_unit != target_unit) {
                                this.updateUnitOnServer(target_unit);
                            }
                            eq.equipmentDestroyed(this);
                            this.updateMenu((byte)2);
                        }
                    } else {
                        this.addToHUD(act.getString("at_max_health"));
                    }
                } else {
                    this.addToHUD(act.getString("not_a_medikit"));
                }
            } else {
                this.addToHUD(act.getString("no_unit_selected"));
            }
        }
    }

    public void heal() {
        AbstractActivity act = Statics.act;
        if (this.current_unit != null) {
            UnitData target_unit = this.current_unit.model.getUnitInFrontOfUnit_MaybeNULL();
            if (target_unit == null) {
                this.addToHUD("No-one found to heal!");
                return;
            }
            if (target_unit.getHealth() < target_unit.max_health / 2) {
                if (this.current_unit.checkAndReduceAPs(this, 20)) {
                    target_unit.setHealth(target_unit.max_health / 2);
                    this.updateUnitOnServer(target_unit);
                    this.updateUnitOnServer(this.current_unit);
                    this.updateMenu((byte)2);
                }
            } else {
                this.addToHUD("That unit cannot be healed any further.");
            }
        } else {
            this.addToHUD(act.getString("no_unit_selected"));
        }
    }

    public void useStardriveScanner() {
        if (this.current_unit != null) {
            EquipmentData eq = this.current_unit.current_item;
            if (eq != null) {
                if (eq.major_type == 25) {
                    if (this.current_unit.checkAndReduceAPs(this, 8)) {
                        this.updateUnitOnServer(this.current_unit);
                        int sd_mapx = -1;
                        int sd_mapz = -1;
                        EquipmentData stardrive = null;
                        int i = 0;
                        while (i < this.equipment.length) {
                            stardrive = this.equipment[i];
                            if (stardrive.major_type == 12 || stardrive.major_type == 24) {
                                if (stardrive.getUnitID() > 0) {
                                    UnitData unit = UnitData.GetUnitDataFromID(this.units, stardrive.getUnitID());
                                    sd_mapx = unit.getMapX();
                                    sd_mapz = unit.getMapY();
                                    break;
                                }
                                PointByte p = EquipmentData.GetEquipmentMapSquare(this.mapdata, stardrive);
                                if (p == null) break;
                                sd_mapx = p.x;
                                sd_mapz = p.y;
                                break;
                            }
                            ++i;
                        }
                        if (stardrive != null && sd_mapx >= 0 && sd_mapz >= 0) {
                            int dist = (int)GeometryFuncs.distance(this.current_unit.getMapX(), this.current_unit.getMapY(), sd_mapx, sd_mapz);
                            if (stardrive.major_type == 12) {
                                this.addToHUD("The flag is " + dist + " metres away");
                            } else if (stardrive.major_type == 24) {
                                this.addToHUD("The stardrive is " + dist + " metres away");
                            } else {
                                this.addToHUD("Unknown item: " + stardrive.major_type);
                            }
                        } else {
                            this.addToHUD("Nothing found");
                        }
                    }
                } else {
                    this.addToHUD("That is not a scanner!");
                }
            }
        } else {
            this.addToHUD("No unit selected.");
        }
    }

    public void computerDestroyed(MapSquare sq, UnitData shooter) {
        AbstractActivity act = Statics.act;
        if (sq.destroyed != 1) {
            if (shooter == this.current_unit) {
                this.addToHUD(act.getString("computer_destroyed"));
            }
            sq.destroyed = 1;
            this.updateMapOnServer(sq, shooter.getSide());
            new CCExplosion(this, (float)sq.x * Statics.SQ_SIZE, (float)sq.y * Statics.SQ_SIZE);
        }
    }

    private static float GetAdjustmentForAngle(float source_ang, float target_ang) {
        float ang_diff = GeometryFuncs.GetDiffBetweenAngles(source_ang, target_ang);
        if (ang_diff >= 130.0f) {
            return 1.0f;
        }
        if (ang_diff >= 40.0f) {
            return 0.5f;
        }
        return 0.25f;
    }

    private void scheduleExplosion(EquipmentData eq, UnitData caused_by) {
        eq.destroyed = true;
        this.explosions_to_show.add(new ExplosionPendingData(eq, caused_by));
    }

    public void showChangeUnitsItemMenu() {
        this.updateMenu((byte)4);
    }

    public void showPickupItemMenu() {
        this.updateMenu((byte)5);
    }

    public void toggleScanner() {
        AbstractActivity act = Statics.act;
        this.getMainThread().setNextModule(new ScannerModule(act, this));
    }

    public void showSelectShotTypeMenu() {
        AbstractActivity act = Statics.act;
        this.updateMenu((byte)6);
        this.createShotLine();
        this.addToHUD(act.getString("drag_to_aim_shot"));
    }

    private void createShotLine() {
        this.shot_line = new Line("Shot_Line", paint_shot_line_unblocked);
        this.attachToRootNode_Top(this.shot_line, true);
        this.updateShotLine(true);
    }

    public void showThrowMenu() {
        AbstractActivity act = Statics.act;
        this.updateMenu((byte)7);
        this.createShotLine();
        this.addToHUD(act.getString("drag_to_aim_throw"));
        if (!(this.current_unit.current_item == null || this.current_unit.current_item.major_type != 2 && this.current_unit.current_item.major_type != 21 && this.current_unit.current_item.major_type != 22 || this.current_unit.current_item.primed)) {
            this.addToHUD(String.valueOf(act.getString("warning")) + ": " + act.getString("grenade_not_primed"), true);
        }
    }

    public void closeCombat(UnitData attacker, UnitData defender) {
        AbstractActivity act = Statics.act;
        this.waitForPendingUpdateRequests();
        boolean[] who_can_see = this.whichSidesCanSeeUnit(attacker);
        who_can_see[defender.getSide()] = true;
        this.sendEventToServer_CloseCombat(attacker, who_can_see);
        act.playSound("punch");
        new CCExplosion(this, defender.model.getWorldCentreX(), defender.model.getWorldCentreY());
        int att_rating = attacker.combat_skill;
        if (attacker.current_item != null) {
            att_rating += attacker.current_item.cc_acc;
        }
        float angle_mult = GameModule.GetAdjustmentForAngle(attacker.angle, defender.angle);
        int def_rating = (int)((float)defender.combat_skill * angle_mult);
        int tot = att_rating * 2 - def_rating;
        int rnd = NumberFunctions.rnd(1, 100);
        if (rnd < tot) {
            this.ccDamage(attacker, defender, angle_mult);
        } else if (defender.canUnitSee(attacker)) {
            this.ccDamage(defender, attacker, angle_mult);
        }
    }

    private void ccDamage(UnitData victor, UnitData loser, float angle_mult) {
        int damage = victor.strength;
        if (victor.current_item != null) {
            damage += victor.current_item.cc_damage;
        }
        damage = this.randomizeDamage(damage);
        damage = (int)((float)damage - (float)loser.protection * angle_mult);
        loser.damage(this, damage, victor, 2);
        this.hud.updateStatusBar();
    }

    private boolean isUnitAdjToFriendlyUnitHeCanSee(UnitData unit) {
        int i_enemy = 0;
        while (i_enemy < this.units.length) {
            if (this.units[i_enemy] != unit && this.game_data.areSidesFriends(this.units[i_enemy].getSide(), unit.getSide()) && this.units[i_enemy].getStatus() == 2 && this.units[i_enemy].model.getMapDistTo(unit.model) <= 1.5f && unit.model.canSee(this.units[i_enemy].model, unit.getAngle(), true)) {
                return true;
            }
            ++i_enemy;
        }
        return false;
    }

    public boolean areExplosionsScheduled() {
        return this.explosions_to_show.size() > 0;
    }

    private ExplosionPendingData getNextExplosion() {
        Comparator<ExplosionPendingData> comparator = new Comparator<ExplosionPendingData>(){

            @Override
            public int compare(ExplosionPendingData o1, ExplosionPendingData o2) {
                return (int)(o1.eq.primed_time - o2.eq.primed_time);
            }
        };
        Collections.sort(this.explosions_to_show, comparator);
        return this.explosions_to_show.get(0);
    }

    private ExplosionPendingData removeNextExplosion() {
        return this.explosions_to_show.remove(0);
    }

    public void unitFinishedMoving(UnitData unit) {
        this.recalcVisibleEnemiesAndOppFire(true, unit);
        if (this.icon_table.menu_mode == 5) {
            this.icon_table.menu_mode = (byte)2;
        }
        this.checkIfUnitsOnFireAndNearAnotherUnit(unit);
        this.updateMenu();
    }

    public void checkIfUnitsOnFireAndNearAnotherUnit(UnitData unit) {
        AbstractActivity act = Statics.act;
        try {
            int i = 0;
            while (i < this.units.length) {
                float dist;
                if (this.units[i] != unit && this.units[i].getStatus() == 2 && (unit.on_fire != 0 || this.units[i].on_fire != 0) && unit.model_type != 14 && this.units[i].model_type != 14 && NumberFunctions.rnd(1, 3) == 1 && (dist = unit.getDistanceTo(this.units[i])) <= 1.1f) {
                    unit.on_fire = 1;
                    this.updateUnitOnServer(unit);
                    this.units[i].on_fire = 1;
                    this.updateUnitOnServer(this.units[i]);
                    act.playSound("fire");
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ErrorReporter.getInstance().handleSilentException(ex);
        }
    }

    public boolean isObjectUpdating(IProcessable i) {
        return this.objects_for_processing.contains(i);
    }

    private boolean canUnitSeeEquipment(UnitData unit, EquipmentData eq) {
        if (eq.model == null) {
            return false;
        }
        return unit.model.canSee(eq.model, unit.getAngle(), false);
    }

    public boolean canUnitSeeUnit(UnitData friend, UnitData enemy, boolean do_units_block) {
        if (friend.getStatus() == 2 && enemy.model != null) {
            return friend.model.canSee(enemy.model, friend.getAngle(), do_units_block);
        }
        return false;
    }

    private void markUnitAsSeen(UnitData unit, UnitData seen_by) {
        AbstractActivity act = Statics.act;
        this.updateVisibleUnitOnServer(unit, seen_by);
        if (!unit.has_been_seen) {
            boolean[] seen_by_sides = new boolean[5];
            seen_by_sides[seen_by.getSide()] = true;
            this.sendEventToServer_UnitMoved(unit, seen_by_sides);
        }
        unit.has_been_seen = true;
        seen_by.setCanSee(unit);
        if (unit.getSide() != this.game_data.our_side) {
            if (unit.model != null) {
                unit.model.visible = true;
            }
            if (!this.icon_table.visible_enemy_icons.contains(unit.icon)) {
                this.icon_table.visible_enemy_icons.add(unit.icon);
                if (!this.orig_visible_enemy_icons.contains(unit.icon)) {
                    act.playSound("enemyalert");
                }
            }
        }
    }

    public void makeOppFireShot(UnitData shooter, UnitData target) {
        Ray targetting_ray = new Ray();
        targetting_ray.origin = shooter.model.getWorldCentre_CreatesNew();
        targetting_ray.direction = target.model.getWorldCentre_CreatesNew().copy().subtract(shooter.model.getWorldCentre_CreatesNew()).normalize();
        this.shoot(shooter, GameModule.GetSnapShotAccuracy(shooter) - 15, shooter.current_item.snap_shot_aps, false, targetting_ray);
    }

    private void deselectUnitIfCurrent(UnitData unit) {
        if (this.current_unit == unit) {
            this.current_unit = null;
            this.removeHighlighter();
            this.updateMenu((byte)1);
        }
    }

    public void lookAtEnemyUnit(UnitData unit) {
        this.showEnemyDetails(unit.model);
        this.root_cam.lookAt(unit.model, false);
        this.removeHighlighter();
        if (Statics.USE_NEW_MOVEMENT_ICONS == 1) {
            this.hud.setMovementIconsVisible(false);
        }
    }

    private void updateShotLine(boolean check_length) {
        this.shot_line.setXYXY(this.current_unit.model.getWorldCentreX(), this.current_unit.model.getWorldCentreY(), this.root_cam.getActualCentre().x, this.root_cam.getActualCentre().y);
        this.shot_line.updateGeometricState();
        if (this.check_shot_line_int.hitInterval()) {
            this.shot_line.setPaint(paint_shot_line_unblocked);
            MyPickResults results = new MyPickResults(null, null);
            Ray ray = new Ray(this.shot_line);
            this.mapdata.canSee(ray, results, false, false);
            if (results.size() > 0) {
                int i = 0;
                while (i < results.getNumber()) {
                    PickData o = results.getPickData(i);
                    if (o.getDistance() <= this.shot_line.getLength()) {
                        this.shot_line.setPaint(paint_shot_line_blocked);
                        break;
                    }
                    ++i;
                }
            }
        }
        if (check_length && this.shot_line.getLength() < Statics.SQ_SIZE / 2.0f) {
            Point p = AbstractUnit.GetDirFromAngle(this.current_unit.angle);
            this.root_cam.moveCam((float)p.x * Statics.SQ_SIZE * 2.0f, (float)p.y * Statics.SQ_SIZE * 2.0f, false);
        }
    }

    public void throwItem() {
        AbstractActivity act = Statics.act;
        if (this.current_unit.model != null && this.shot_line != null) {
            float max_range_sq;
            float selected_dist_sq = this.shot_line.getLength() / Statics.SQ_SIZE;
            if (selected_dist_sq > (max_range_sq = (float)GameModule.GetMaxRangeSq(this))) {
                selected_dist_sq = max_range_sq;
            }
            if (this.current_unit.current_item != null) {
                Ray targetting_ray = new Ray(this.shot_line);
                float ang = targetting_ray.getAngle();
                float diff = GeometryFuncs.GetDiffBetweenAngles(ang, this.current_unit.getAngle());
                if (diff < 49.0f) {
                    if (this.current_unit.checkAndReduceAPs(this, 10)) {
                        act.playSound("throwitem");
                        this.hud.appendText(act.getString("item_thrown"));
                        EquipmentData obj_thrown = this.current_unit.current_item;
                        this.current_unit.removeCurrentItem(this);
                        MyPickResults results = new MyPickResults(this.current_unit.model, null);
                        results.clear();
                        float ang_rnd = (100 - this.current_unit.combat_skill) / 12;
                        float angle = NumberFunctions.rndFloat(-ang_rnd, ang_rnd);
                        targetting_ray.setDirection(GeometryFuncs.AdjustVectorByAngle(targetting_ray.getDirection(), angle));
                        float dist_rnd = (float)(100 - this.current_unit.combat_skill) / 220.0f;
                        GameModule.p("Dist changed to " + (selected_dist_sq *= NumberFunctions.rndFloat(1.0f - dist_rnd, 1.0f + dist_rnd)));
                        float selected_dist_px = selected_dist_sq * Statics.SQ_SIZE;
                        boolean object_landed = false;
                        this.root_node.findPick(targetting_ray, results);
                        this.mapdata.canSee(targetting_ray, results, true, false);
                        results.sort();
                        if (results.getNumber() > 0) {
                            int i = 0;
                            while (i < results.getNumber()) {
                                PickData o = results.getPickData(i);
                                if (!(o.getDistance() <= selected_dist_px)) break;
                                GameObject target = results.getGameObject(i);
                                if (target instanceof AbstractUnit) {
                                    AbstractUnit catcher = (AbstractUnit)target;
                                    selected_dist_px = o.getDistance();
                                    boolean caught = false;
                                    if (catcher.unit_data.current_item == null && catcher.unit_data.can_use_equipment && this.canUnitSeeUnit(catcher.unit_data, this.current_unit, true) && catcher.unit_data.checkAndReduceAPs(this, 3)) {
                                        catcher.unit_data.current_item = obj_thrown;
                                        catcher.unit_data.items.add(obj_thrown);
                                        this.updateUnitOnServer(catcher.unit_data);
                                        obj_thrown.setUnitID(catcher.unit_data.unitid);
                                        this.updateEquipmentOnServer(obj_thrown, -1, -1);
                                        this.addToHUD(String.valueOf(act.getString("caught_by")) + " " + catcher.unit_data.name);
                                        caught = true;
                                    }
                                    if (!caught) {
                                        this.addToHUD(String.valueOf(act.getString("has_hit")) + " " + catcher.unit_data.name + ".");
                                        this.putEquipmentOnFloor(obj_thrown, catcher.unit_data.getMapX(), catcher.unit_data.getMapY());
                                    }
                                    object_landed = true;
                                    break;
                                }
                                if (target.can_be_shot && target.getChanceofNotHitting() <= 0) {
                                    selected_dist_px = o.getDistance();
                                    this.objectThrownToTheFloor(obj_thrown, selected_dist_px, targetting_ray);
                                    object_landed = true;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (!object_landed) {
                            this.objectThrownToTheFloor(obj_thrown, selected_dist_px, targetting_ray);
                        }
                        boolean[] who_can_see = this.whichSidesCanSeeUnit(this.current_unit);
                        this.sendEventToServer_ItemThrown(this.current_unit, (int)ang, (int)selected_dist_sq, who_can_see);
                        this.shot_line.removeFromParent();
                        this.shot_line = null;
                        MyPointF vdiff = targetting_ray.getDirection().multiply(selected_dist_px);
                        MyPointF end = targetting_ray.getOrigin().add(vdiff);
                        if (obj_thrown.equipment_type_id == 2) {
                            new Bullet(this, this.current_unit.model.getWorldCentre_CreatesNew(), end, false, true, "grenade", 1, Statics.BULLET_SIZE * 4.0f);
                        } else {
                            new Bullet(this, this.current_unit.model.getWorldCentre_CreatesNew(), end, false, true, "crate", 1, Statics.BULLET_SIZE * 2.0f);
                        }
                        this.updateMenu((byte)2);
                    } else {
                        this.addToHUD(act.getString("not_enough_aps"));
                    }
                } else {
                    this.addToHUD(act.getString("not_in_view"));
                    if (this.help_mode_on) {
                        this.addToHUD(act.getString("white_line_help"));
                    }
                }
            } else {
                this.addToHUD(act.getString("unit_carrying_nothing"));
            }
        }
    }

    private void objectThrownToTheFloor(EquipmentData obj_thrown, float selected_dist_px, Ray targetting_ray) {
        int y;
        int x;
        while (true) {
            MyPointF pos_diff = targetting_ray.getDirection().multiply(selected_dist_px);
            MyPointF end_pos = targetting_ray.getOrigin().add(pos_diff);
            x = (int)end_pos.x;
            y = (int)end_pos.y;
            MapSquare sq = this.mapdata.getSqFromPixels_MaybeNULL(x, y);
            if (sq != null && sq.major_type == 1 && (sq.door_type <= 0 || sq.door_open)) break;
            selected_dist_px -= Statics.SQ_SIZE * 0.5f;
        }
        this.putEquipmentOnFloor(obj_thrown, (byte)((float)x / Statics.SQ_SIZE), (byte)((float)y / Statics.SQ_SIZE));
    }

    private void putEquipmentOnFloor(EquipmentData obj_thrown, int mapx, int mapz) {
        this.mapdata.getSq_MaybeNULL(mapx, mapz).addEquipment(obj_thrown);
        obj_thrown.seen_by_side[this.current_unit.getSide()] = 1;
        this.updateEquipmentOnServer(obj_thrown, mapx, mapz);
        obj_thrown.model = EquipmentModel.Factory(this, obj_thrown, mapx, mapz);
        this.attachToRootNode(obj_thrown.model, true);
    }

    public void buildStructure(int tex_type) {
        AbstractActivity act = Statics.act;
        Point p = AbstractUnit.GetDirFromAngle(this.current_unit.getAngle());
        Point new_pos = new Point(this.current_unit.getMapX() + p.x, this.current_unit.getMapY() + p.y);
        MapSquare sq = this.mapdata.getSq_MaybeNULL(new_pos.x, new_pos.y);
        if (sq != null) {
            if (this.current_unit.unit_type == 1 || this.current_unit.model_type == 7) {
                UnitData opponent = this.getUnitAt(new_pos.x, new_pos.y);
                if (opponent == null) {
                    if (sq.major_type == 1 && sq.door_type <= 0) {
                        int test = SelectStructureToBuildModule.GetResPtsForDismantledStructure(sq);
                        if (test <= 1) {
                            int cost = SelectStructureToBuildModule.GetRPCostToBuildStructure(tex_type);
                            if (this.game_data.getResPointsForOurSide() >= cost) {
                                int build_aps = SelectStructureToBuildModule.GetAPCostToBuildStructure(tex_type);
                                if (this.current_unit.checkAndReduceAPs(this, build_aps)) {
                                    act.playSound("construction");
                                    this.updateUnitOnServer(this.current_unit);
                                    if (tex_type == 16) {
                                        sq.major_type = 3;
                                        int tc = this.mapdata.getAdjacentTexCode(sq, 3);
                                        if (tc <= 0) {
                                            tc = 16;
                                        }
                                        sq.texture_code = tc;
                                    } else {
                                        sq.major_type = 1;
                                        sq.texture_code = tex_type;
                                    }
                                    sq.owner_side = this.current_unit.getSide();
                                    sq.raised_texture_code = 0;
                                    sq.scenery_code = 0;
                                    sq.destroyed = 0;
                                    this.updateMapOnServer(sq, this.current_unit.getSide());
                                    this.createMapModel();
                                    this.sendEventToServer_MapSquareChanged(new_pos.x, new_pos.y, 1, sq.major_type, tex_type, this.current_unit.getSide());
                                    this.addToHUD(String.valueOf(SelectStructureToBuildModule.TexToString(tex_type)) + " built.");
                                    byte by = this.game_data.our_side;
                                    this.game_data.res_points[by] = this.game_data.res_points[by] - cost;
                                    this.setResPointsForSideOnServer(this.game_data.our_side, this.game_data.res_points[this.game_data.our_side]);
                                }
                            } else {
                                this.addToHUD("You don't have enough Resource Points (" + cost + " > " + this.game_data.getResPointsForOurSide() + ")");
                            }
                        } else {
                            this.addToHUD("There is already a structure there.");
                        }
                    } else {
                        this.addToHUD("You can only build on floor squares which do not have a door.");
                    }
                } else {
                    this.addToHUD("There is a unit in the way.");
                }
            } else {
                this.addToHUD("This unit is not an engineer.");
            }
        }
    }

    public void dismantleStructure() {
        AbstractActivity act = Statics.act;
        Point p = AbstractUnit.GetDirFromAngle(this.current_unit.getAngle());
        Point new_pos = new Point(this.current_unit.getMapX() + p.x, this.current_unit.getMapY() + p.y);
        MapSquare sq = this.mapdata.getSq_MaybeNULL(new_pos.x, new_pos.y);
        if (sq != null) {
            boolean engineer = this.current_unit.unit_type == 1;
            int value = SelectStructureToBuildModule.GetResPtsForDismantledStructure(sq);
            if (value > 0) {
                if (this.current_unit.checkAndReduceAPs(this, 15)) {
                    if (engineer) {
                        byte by = this.game_data.our_side;
                        this.game_data.res_points[by] = this.game_data.res_points[by] + value;
                        this.setResPointsForSideOnServer(this.game_data.our_side, this.game_data.res_points[this.game_data.our_side]);
                    }
                    act.playSound("dismantle");
                    this.updateUnitOnServer(this.current_unit);
                    int tc = this.mapdata.getAdjacentTexCode(sq, 1);
                    if (tc <= 0) {
                        tc = 3;
                    }
                    sq.texture_code = tc;
                    sq.major_type = 1;
                    sq.texture_code = tc;
                    sq.door_type = 0;
                    sq.door_open = false;
                    sq.raised_texture_code = 0;
                    sq.scenery_code = 0;
                    sq.destroyed = 1;
                    this.updateMapOnServer(sq, this.current_unit.getSide());
                    this.createMapModel();
                    this.sendEventToServer_MapSquareChanged(new_pos.x, new_pos.y, 3, sq.major_type, sq.texture_code, this.current_unit.getSide());
                    this.addToHUD("Installation dismantled.");
                    new CCExplosion(this, (float)sq.x * Statics.SQ_SIZE, (float)sq.y * Statics.SQ_SIZE);
                    this.recalcVisibleEnemiesAndOppFire(true, null);
                }
            } else {
                this.addToHUD("There is no structure there.");
            }
        }
    }

    public void primeGrenade(byte turns) {
        AbstractActivity act = Statics.act;
        EquipmentData eq = this.current_unit.current_item;
        if (!eq.primed) {
            if (this.current_unit.checkAndReduceAPs(this, 10)) {
                eq.primed = true;
                eq.explode_turns = turns;
                eq.primed_time = System.currentTimeMillis();
                eq.last_unit_to_touch = this.current_unit.unitid;
                this.updateEquipmentOnServer(eq, -1, -1);
                this.updateUnitOnServer(this.current_unit);
                this.addToHUD(act.getString("grenade_primed", "" + turns));
                boolean[] who_can_see = this.whichSidesCanSeeUnit(this.current_unit);
                this.sendEventToServer_GrenadePrimed(this.current_unit, turns, who_can_see);
            }
        } else {
            this.addToHUD(act.getString("already_primed"));
        }
        this.updateMenu((byte)2);
    }

    public void stopGameDueToError() {
        this.client_mode = (byte)9;
    }

    private void toggleGrid() {
        show_grid = !show_grid;
    }

    public void showEquipmentMenu() {
        this.updateMenu((byte)3);
    }

    public static int GetMaxRangeSq(GameModule game) {
        if (game.getCurrentUnit() != null) {
            int dist = game.getCurrentUnit().strength - game.getCurrentUnit().current_item.weight;
            if (dist < 3) {
                dist = 3;
            }
            return dist;
        }
        return 0;
    }

    private void startTutorial() {
        AbstractActivity act = Statics.act;
        boolean bl = this.show_tutorial = !this.show_tutorial;
        if (this.show_tutorial) {
            this.tutorial = new Tutorial(this);
            this.addToHUD(act.getString("tutorial_0"));
        }
        this.updateMenu();
    }

    public void nextTutorial() {
        this.addToHUD("---");
        this.addToHUD(this.tutorial.getText());
    }

    private void showGameLog() {
        AbstractActivity act = Statics.act;
        if (this.load_log != null) {
            if (!this.load_log.isAlive()) {
                if (this.load_log.cache == null) {
                    this.loadTheLog();
                    this.hud.appendText("Please wait, there was a problem loading the log...");
                } else {
                    this.game_log_module = new GameLogModule(act, this, this.load_log.cache);
                    this.getMainThread().setNextModule(this.game_log_module);
                }
            } else {
                this.hud.appendText("Please wait, log not loaded yet...");
            }
        }
    }

    private void showAdvancedScanner() {
        try {
            String url = String.valueOf(Statics.URL_FOR_CLIENT) + "/androidcomm/ViewScanner.cls?android_login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&android_pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD) + "&gameid=" + this.game_data.game_id;
            Browser.OpenBrowser(url);
        }
        catch (Exception ex) {
            AbstractActivity.HandleError(ex);
        }
    }

    private void showGameChat() {
        try {
            String url = String.valueOf(Statics.URL_FOR_CLIENT) + "/dsr/forums/ForumPostingsPage.cls?topic=" + this.game_data.forum_id + "&android_login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&android_pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD);
            Browser.OpenBrowser(url);
        }
        catch (Exception ex) {
            AbstractActivity.HandleError(ex);
        }
    }

    private void showMissionDesc() {
        try {
            String url = String.valueOf(Statics.URL_FOR_CLIENT) + "/dsr/missiondescriptions.cls?type=" + this.game_data.mission_type + "&android_login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&android_pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD);
            Browser.OpenBrowser(url);
        }
        catch (Exception ex) {
            AbstractActivity.HandleError(ex);
        }
    }

    public boolean menuPressed(Button b) {
        AbstractActivity act = Statics.act;
        this.submenu.instaHide();
        int cmd = NumberFunctions.ParseInt(b.getActionCommand());
        switch (cmd) {
            case 2: {
                this.showAdvancedScanner();
                return true;
            }
            case 3: {
                this.toggleGrid();
                return true;
            }
            case 4: {
                this.showGameLog();
                return true;
            }
            case 7: {
                this.showMissionDesc();
                return true;
            }
            case 5: {
                this.startTutorial();
                this.updateMenu();
                return true;
            }
            case 8: {
                this.showGameChat();
                return true;
            }
            case 9: {
                this.getMainThread().setNextModule(new AllUnitStatsModule(act, this, this.game_data, new ArrayList<UnitData>(Arrays.asList(this.units)), this.equipment));
                return true;
            }
            case 10: {
                this.getMainThread().setNextModule(new CurrentGameDetailsModule(act, this, this.game_data, true));
                return true;
            }
            case 11: {
                this.getMainThread().setNextModule(new SendMessageModule(act, this, this.game_data.getOpponentsName(), "Game " + this.game_data.game_id + ": " + this.game_data.mission_name + ", " + this.game_data.getPlayersNames(), ""));
                return true;
            }
            case 12: {
                this.getMainThread().setNextModule(new SendMessageModule(act, this, this.game_data.getComradesName(), "Game " + this.game_data.game_id + ": " + this.game_data.mission_name + ", " + this.game_data.getPlayersNames(), ""));
                return true;
            }
            case 13: {
                this.getMainThread().setNextModule(new InstructionsModule(act, this));
                return true;
            }
        }
        throw new RuntimeException("Unknown menu item: " + cmd);
    }

    @Override
    protected boolean returnTo() {
        AbstractActivity act = Statics.act;
        this.update_server_thread.stop_now = true;
        boolean autoselect = false;
        super.getMainThread().setNextModule(new GetGamesModule(act, autoselect));
        return true;
    }

    public void undoDeployment() {
        AbstractActivity act = Statics.act;
        boolean found = false;
        int i = this.units.length - 1;
        while (i >= 0) {
            if (this.units[i].getSide() == this.game_data.our_side && this.units[i].getStatus() == 2 && this.units_deployed.contains(i)) {
                this.next_to_deploy = i;
                found = true;
                break;
            }
            --i;
        }
        if (found) {
            UnitData unit = this.units[this.next_to_deploy];
            this.root_node.detachChild(unit.model);
            unit.setStatus((byte)1);
            this.updateUnitOnServer(unit);
            this.addToHUD(act.getString("unit_undeployed"));
            this.getNextUnitToDeploy();
            this.next_deploy_dir.add(unit.angle);
        } else {
            this.addToHUD("No unit can be undeployed");
        }
    }

    public MapSquare findEndStairsSquare(MapSquare sq_start) {
        double dist;
        MapSquare sq;
        int looking_for = 83;
        if (sq_start.texture_code == 83) {
            looking_for = 82;
        }
        double closest_dist = 9999.0;
        int closest_x = -1;
        int closest_y = -1;
        int x = sq_start.x;
        int y = 0;
        while (y < this.mapdata.getMapHeight()) {
            sq = this.mapdata.getSq_MaybeNULL(x, y);
            if (sq.texture_code == looking_for && (dist = GeometryFuncs.distance(sq_start.x, sq_start.y, sq.x, sq.y)) < closest_dist) {
                closest_dist = dist;
                closest_x = sq.x;
                closest_y = sq.y;
            }
            ++y;
        }
        y = sq_start.y;
        x = 0;
        while (x < this.mapdata.getMapWidth()) {
            sq = this.mapdata.getSq_MaybeNULL(x, y);
            if (sq.texture_code == looking_for && (dist = GeometryFuncs.distance(sq_start.x, sq_start.y, sq.x, sq.y)) < closest_dist) {
                closest_dist = dist;
                closest_x = sq.x;
                closest_y = sq.y;
            }
            ++x;
        }
        if (closest_x >= 0) {
            return this.mapdata.getSq_MaybeNULL(closest_x, closest_y);
        }
        return null;
    }

    public void showBuildStructureMenu() {
        AbstractActivity act = Statics.act;
        this.getMainThread().setNextModule(new SelectStructureToBuildModule(act, this));
    }

    public void layEgg() {
        this.buildStructure(93);
    }

    private boolean isThereAnAISide() {
        int i = 0;
        while (i < this.units.length) {
            if (this.units[i].hasAI()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void playAmbience() {
        AbstractActivity act = Statics.act;
        if (this.is_april_fools_day && NumberFunctions.rnd(1, 5) == 1) {
            act.playSound("fart");
        }
        if (this.game_data.mission_type == 1 || this.game_data.mission_type == 3 || this.game_data.mission_type == 21 || this.game_data.mission_type == 29 || this.game_data.mission_type == 39 || this.game_data.mission_type == 45 || this.game_data.mission_type == 46 || this.game_data.mission_type == 50 || this.game_data.mission_type == 61 || this.game_data.mission_type == 66 || this.game_data.mission_type == 84 || this.game_data.mission_type == 85 || this.game_data.mission_type == 90) {
            act.playSound("outside_ambience");
        } else if (this.game_data.mission_type == 2 || this.game_data.mission_type == 5 || this.game_data.mission_type == 12 || this.game_data.mission_type == 23 || this.game_data.mission_type == 30 || this.game_data.mission_type == 31 || this.game_data.mission_type == 40 || this.game_data.mission_type == 44 || this.game_data.mission_type == 51 || this.game_data.mission_type == 54 || this.game_data.mission_type == 65 || this.game_data.mission_type == 74 || this.game_data.mission_type == 80 || this.game_data.mission_type == 81) {
            act.playSound("computerambience");
        } else if (this.game_data.mission_type == 7 || this.game_data.mission_type == 18 || this.game_data.mission_type == 27 || this.game_data.mission_type == 43) {
            act.playSound("mines_ambience");
        } else if (this.game_data.mission_type == 82 || this.game_data.mission_type == 87) {
            act.playSound("reanim_ambience");
        } else if (this.game_data.mission_type == 6 || this.game_data.mission_type == 24 || this.game_data.mission_type == 32 || this.game_data.mission_type == 42 || this.game_data.mission_type == 47 || this.game_data.mission_type == 48 || this.game_data.mission_type == 52 || this.game_data.mission_type == 62 || this.game_data.mission_type == 73) {
            act.playSound("insectsambience");
        } else if (this.game_data.mission_type == 14 || this.game_data.mission_type == 60) {
            act.playSound("horrorambience");
        } else {
            act.playSound("space_ambience");
        }
    }

    @Override
    public boolean playMusic() {
        return false;
    }

    @Override
    public void rootCamMoved(float offx, float offy) {
        if (this.current_unit != null && Statics.USE_NEW_MOVEMENT_ICONS == 1) {
            float dist = GeometryFuncs.distance(this.current_unit.model.getWorldX(), this.current_unit.model.getWorldY(), this.root_cam.left + (float)(Statics.SCREEN_WIDTH / 2), this.root_cam.top + (float)(Statics.SCREEN_HEIGHT / 2));
            if (dist > Statics.SQ_SIZE * 2.0f) {
                this.hud.setMovementIconsVisible(false);
            } else {
                this.hud.setMovementIconsVisible(true);
            }
        }
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent msg) {
        Statics.act.playSound("type2");
        if (keyCode == 37) {
            this.root_cam.moveCam(-Statics.SQ_SIZE, 0.0f);
        } else if (keyCode == 39) {
            this.root_cam.moveCam(Statics.SQ_SIZE, 0.0f);
        } else if (keyCode == 38) {
            this.root_cam.moveCam(0.0f, -Statics.SQ_SIZE);
        } else if (keyCode == 40) {
            this.root_cam.moveCam(0.0f, Statics.SQ_SIZE);
        } else if (keyCode == 83) {
            this.toggleScanner();
        } else if (keyCode == 87) {
            if (this.current_unit != null) {
                this.current_unit.model.moveFwd();
            }
        } else if (keyCode == 88) {
            if (this.current_unit != null) {
                this.current_unit.model.moveBack();
            }
        } else if (keyCode == 81) {
            if (this.current_unit != null) {
                this.current_unit.model.turnBy(-45);
            }
        } else if (keyCode == 69) {
            if (this.current_unit != null) {
                this.current_unit.model.turnBy(45);
            }
        } else if (keyCode == 65) {
            if (this.current_unit != null) {
                this.current_unit.model.moveStrafeLeft();
            }
        } else if (keyCode == 68) {
            if (this.current_unit != null) {
                this.current_unit.model.moveStrafeRight();
            }
        } else if (keyCode >= 49 && keyCode <= 57) {
            int id = keyCode - 49;
            if (id < this.units.length) {
                int i = 0;
                while (i < this.units.length) {
                    if (this.units[i].getSide() == this.game_data.our_side && !this.units[i].hasAI() && this.units[i].getStatus() == 2) {
                        if (id <= 0) {
                            this.selectOurUnit(this.units[i], false);
                            return true;
                        }
                        --id;
                    }
                    ++i;
                }
            }
        } else if (keyCode == 78) {
            this.selectNextUnit();
        } else if (keyCode == 80) {
            this.selectPrevUnit();
        }
        return false;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent msg) {
        return false;
    }
}

