/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start;

import com.scs.stellarforces.Statics;
import dsr.data.GameData;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.AbstractModule;
import ssmith.android.framework.modules.SimpleScrollingAbstractModule;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Label;
import ssmith.android.lib2d.gui.MultiLineLabel;

public class CurrentGameDetailsModule
extends SimpleScrollingAbstractModule {
    private static Paint paint_large_text = new Paint();
    private static Paint paint_normal_text = new Paint();
    private GameData gamedata;

    static {
        paint_large_text.setARGB(255, 255, 255, 255);
        paint_large_text.setAntiAlias(true);
        paint_large_text.setTextSize(Statics.GetHeightScaled(0.09f));
        paint_normal_text.setARGB(255, 255, 255, 255);
        paint_normal_text.setAntiAlias(true);
        paint_normal_text.setTextSize(Statics.GetHeightScaled(0.05f));
    }

    public CurrentGameDetailsModule(AbstractActivity act, AbstractModule _return_to, GameData _gamedata, boolean take_turn_msg) {
        super(-1);
        paint_large_text.setTypeface(Statics.bigfnt);
        paint_normal_text.setTypeface(Statics.stdfnt);
        this.mod_return_to = _return_to;
        this.gamedata = _gamedata;
        this.setBackground("space1.jpg");
        Label l = new Label("Title", "Game " + this.gamedata.game_id + " Summary", 0.0f, 0.0f, null, paint_large_text, true);
        l.setCentre(Statics.SCREEN_WIDTH / 2, paint_large_text.getTextSize());
        this.root_node.attachChild(l);
        StringBuffer str = new StringBuffer();
        if (this.gamedata.max_turns > 0) {
            str.append("Turn: " + this.gamedata.turn_no + "/" + this.gamedata.max_turns + "\n");
            if (this.gamedata.turn_no >= this.gamedata.max_turns && this.gamedata.max_turns > 0) {
                str.append("THIS IS THE LAST TURN!\n");
            }
        } else {
            str.append("Turn: " + this.gamedata.turn_no + "\n");
        }
        str.append("Mission: " + this.gamedata.mission_name);
        if (!this.gamedata.isItOurTurn() && this.gamedata.days_waiting > 0) {
            str.append("\nYou have been waiting " + this.gamedata.days_waiting + " days for your opponent.");
        }
        if (this.gamedata.is_advanced == 1) {
            str.append("\nAdvanced Mode");
        }
        if (this.gamedata.is_practise == 1) {
            str.append("\nPractise Mode");
        }
        str.append("\n");
        str.append("\nVPs at end of last turn:\n");
        int s = 1;
        while (s <= this.gamedata.num_players) {
            if (this.gamedata.is_snafu == 0) {
                str.append(String.valueOf(this.gamedata.GetPlayersNameFromSide(s)) + " (" + this.gamedata.side_names[s] + "): " + this.gamedata.vps[s] + " VPs");
                if (this.gamedata.is_advanced == 0 || this.gamedata.areSidesFriends(s, this.gamedata.our_side)) {
                    str.append(", " + this.gamedata.units_remaining[s] + " units remaining");
                }
                str.append("\n");
            } else {
                str.append(String.valueOf(this.gamedata.GetPlayersNameFromSide(s)) + " (" + this.gamedata.side_names[s] + ")\n");
            }
            ++s;
        }
        if (this.gamedata.is_snafu != 0) {
            String sides = "";
            int s2 = 1;
            while (s2 <= this.gamedata.num_players) {
                if (this.gamedata.snafu_will_opp_fire_on_side[s2] == 1) {
                    sides = String.valueOf(sides) + s2 + ",";
                }
                ++s2;
            }
            sides = sides.length() > 0 ? "You will ONLY opp-fire at side(s) " + sides.substring(0, sides.length() - 1) + "." : "You will not opp-fire at any sides.  Use website to change this.";
            str.append("This is a SNAFU mission so VPs are hidden.  " + sides + "\n");
        }
        if (this.gamedata.can_build_and_dismantle == 1) {
            str.append("\nYou have " + this.gamedata.getResPointsForOurSide() + " Resource Points\n");
        }
        str.append("\nObjective:\n" + this.gamedata.mission1liner + "\n");
        if (take_turn_msg) {
            str.append("\nPress screen to continue!");
        } else {
            str.append("\nWaiting for opponent!");
        }
        MultiLineLabel label2 = new MultiLineLabel("credits", str.toString(), null, paint_normal_text, true, (float)Statics.SCREEN_WIDTH * 0.9f);
        label2.setLocation(10.0f, (float)Statics.SCREEN_HEIGHT * 0.15f);
        this.root_node.attachChild(label2);
        this.root_node.updateGeometricState();
    }

    @Override
    public void handleClick(AbstractComponent c) throws Exception {
    }

    @Override
    public void noComponentClicked() {
        this.returnTo();
    }
}

