/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.start.AboutModule;
import com.scs.stellarforces.start.LoginModule;
import com.scs.stellarforces.start.QuickstartModule;
import dsr.comms.AbstractCommFuncs;
import java.awt.event.WindowEvent;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.AbstractModule;
import ssmith.android.framework.modules.SimpleAbstractModule;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.gui.Label;
import ssmith.android.lib2d.layouts.GridLayout;
import ssmith.android.lib2d.shapes.BitmapRectangle;
import ssmith.util.Browser;

public final class StartupModule
extends SimpleAbstractModule {
    private static String QUICKSTART;
    private static String LOG_IN;
    private static String ABOUT;
    private static String REGISTER;
    private static String FEEDBACK;
    private static String VIEW_FULL_VERSION;
    private static final String MUTE = "Mute";
    private static final float ICON_WIDTH;
    private static final float ICON_HEIGHT;
    private static final float MUTE_SIZE;
    private Label website;
    private Button cmd_mute;
    public static Paint paint_menu_text;
    private static Paint paint_small_text;

    static {
        ICON_WIDTH = Statics.SCREEN_WIDTH / 3;
        ICON_HEIGHT = Statics.SCREEN_HEIGHT / 7;
        MUTE_SIZE = Statics.SCREEN_WIDTH / 10;
        paint_menu_text = new Paint();
        paint_small_text = new Paint();
        paint_menu_text.setARGB(255, 255, 255, 255);
        paint_menu_text.setAntiAlias(true);
        paint_small_text.setARGB(255, 255, 255, 255);
        paint_small_text.setAntiAlias(true);
    }

    public StartupModule(AbstractActivity act) {
        super(-1);
        paint_menu_text.setTypeface(Statics.stdfnt);
        paint_small_text.setTypeface(Statics.stdfnt);
        LOG_IN = act.getString("log_in");
        ABOUT = act.getString("about");
        QUICKSTART = "QUICKSTART";
        REGISTER = act.getString("register");
        FEEDBACK = act.getString("feedback");
        VIEW_FULL_VERSION = "Full Version";
        this.setBackground("space1.jpg");
        act.resumeMusic();
    }

    @Override
    public void started() {
        AbstractActivity act = Statics.act;
        super.started();
        this.stat_node.removeAllChildren();
        BitmapRectangle l_title = new BitmapRectangle("Title", Statics.img_cache.getImageByKey_HeightOnly("sf_logo2_small.png", (float)Statics.SCREEN_HEIGHT * 0.2f), 0.0f, 0.0f);
        l_title.setCentre(Statics.SCREEN_WIDTH / 2, l_title.getHeight() * 0.6f);
        this.stat_node.attachChild(l_title);
        GridLayout menu_node = new GridLayout("Menu", ICON_WIDTH, ICON_HEIGHT, Statics.GetButtonSpacing());
        menu_node.attachChild(new Button(LOG_IN, LOG_IN, null, paint_menu_text, Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT)), 0, 0);
        menu_node.attachChild(new Button(REGISTER, REGISTER, null, paint_menu_text, Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT)), 1, 0);
        menu_node.attachChild(new Button(QUICKSTART, QUICKSTART, null, paint_menu_text, Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT)), 0, 1);
        menu_node.attachChild(new Button(ABOUT, ABOUT, null, paint_menu_text, Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT)), 1, 1);
        menu_node.updateGeometricState();
        menu_node.setCentre(Statics.SCREEN_WIDTH / 2, Statics.SCREEN_HEIGHT / 2);
        this.stat_node.attachChild(menu_node);
        Label label2 = new Label("Version", String.valueOf(act.getString("version")) + " " + 1.4f, null, paint_small_text);
        label2.setLocation(5.0f, (float)Statics.SCREEN_HEIGHT - paint_small_text.getTextSize() * 2.0f);
        this.stat_node.attachChild(label2);
        this.website = new Label("Website", Statics.URL_FOR_CLIENT, null, paint_menu_text);
        this.website.setCentre(Statics.SCREEN_WIDTH / 2, (float)Statics.SCREEN_HEIGHT - paint_small_text.getTextSize() * 3.0f);
        this.website.collides = true;
        this.stat_node.attachChild(this.website);
        Label prog_by = new Label("Programmed by Steve Smith", "Programmed by Stephen Smith", null, paint_small_text);
        prog_by.setCentre(Statics.SCREEN_WIDTH / 2, (float)Statics.SCREEN_HEIGHT - paint_small_text.getTextSize());
        this.stat_node.attachChild(prog_by);
        this.showMuteIcon();
        this.stat_node.updateGeometricState();
        this.stat_cam.lookAt(Statics.SCREEN_WIDTH / 2, Statics.SCREEN_HEIGHT / 2, true);
        this.start();
    }

    @Override
    public void stopped() {
    }

    @Override
    public void handleClick(AbstractComponent b) throws Exception {
        AbstractActivity act = Statics.act;
        if (b == this.website) {
            String url = null;
            url = Statics.LAST_LOGIN.length() > 0 ? String.valueOf(Statics.URL_FOR_CLIENT) + "/dsr/LoginPage.cls?login=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_LOGIN) + "&pwd=" + AbstractCommFuncs.URLEncodeString(Statics.LAST_PWD) : Statics.URL_FOR_CLIENT;
            Browser.OpenBrowser(url);
        } else {
            String cmd = b.getActionCommand().toString();
            if (cmd.length() > 0) {
                if (cmd.equalsIgnoreCase(LOG_IN)) {
                    super.getMainThread().setNextModule(new LoginModule(act));
                } else if (cmd.equalsIgnoreCase(ABOUT)) {
                    super.getMainThread().setNextModule(new AboutModule(act, 0));
                } else if (cmd.equalsIgnoreCase(REGISTER)) {
                    super.getMainThread().setNextModule(Statics.GetModule(6));
                } else if (cmd.equalsIgnoreCase(QUICKSTART)) {
                    super.getMainThread().setNextModule(new QuickstartModule(act));
                } else if (cmd.equalsIgnoreCase(FEEDBACK)) {
                    StartupModule.SendFeedback(act, this);
                } else if (!cmd.equalsIgnoreCase(VIEW_FULL_VERSION)) {
                    if (cmd.equalsIgnoreCase(MUTE)) {
                        if (Statics.MUTE_MUSIC == 0) {
                            Statics.MUTE_MUSIC = 1;
                            Statics.MUTE_SFX = 1;
                            act.pauseMusic();
                        } else {
                            Statics.MUTE_MUSIC = 0;
                            Statics.MUTE_SFX = 0;
                            act.resumeMusic();
                        }
                        Statics.SavePrefs();
                        this.showMuteIcon();
                    } else {
                        throw new RuntimeException("Unknown command: '" + cmd + "'");
                    }
                }
            }
        }
    }

    public static void SendFeedback(AbstractActivity act, AbstractModule mod) {
    }

    @Override
    public boolean onBackPressed() {
        Statics.act.thread.window.dispatchEvent(new WindowEvent(Statics.act.thread.window, 201));
        return true;
    }

    private void showMuteIcon() {
        if (this.cmd_mute != null) {
            this.cmd_mute.removeFromParent();
        }
        this.cmd_mute = Statics.MUTE_MUSIC == 0 ? new Button(MUTE, "", null, null, Statics.img_cache.getImage("sound_on_icon", MUTE_SIZE, MUTE_SIZE)) : new Button(MUTE, "", null, null, Statics.img_cache.getImage("sound_off_icon", MUTE_SIZE, MUTE_SIZE));
        this.cmd_mute.setLocation((float)Statics.SCREEN_WIDTH - MUTE_SIZE, (float)Statics.SCREEN_HEIGHT - MUTE_SIZE);
        this.stat_node.attachChild(this.cmd_mute);
        this.stat_node.updateGeometricState();
    }
}

