/*
 * Decompiled with CFR 0.152.
 */
package dsr.data;

import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.graphics.GameObject;
import dsr.data.ClientMapData;
import dsr.data.MapSquare;
import dsr.data.UnitData;
import java.awt.Point;
import ssmith.util.PointByte;

public final class EquipmentData {
    public String equipcode;
    private String name;
    public String code;
    public int equip_id;
    public byte major_type;
    public byte weight;
    public byte range_sq;
    private int unitid;
    private byte ammo;
    public byte ammo_capacity;
    public int ammo_type_id;
    public int shot_damage;
    public int cc_damage;
    public byte cc_acc;
    public int explode_turns;
    public int explosion_rad;
    public int explosion_dam;
    public boolean primed;
    public boolean destroyed;
    public boolean explodes;
    public byte aimed_shot_acc;
    public byte aimed_shot_aps;
    public byte snap_shot_acc;
    public byte snap_shot_aps;
    public byte auto_shot_acc;
    public byte auto_shot_aps;
    public int reload_cost;
    public int last_unit_to_touch;
    public byte indestructable;
    public GameObject model;
    public byte[] seen_by_side = new byte[5];
    public byte new_item = 0;
    public int equipment_type_id;
    public long primed_time;

    public String toString() {
        return "Equipment: " + this.name + " (unit: " + this.unitid + ") " + (this.destroyed ? "D" : "-");
    }

    public static PointByte GetEquipmentMapSquare(ClientMapData map, EquipmentData eq) {
        int z = 0;
        while (z < map.getMapHeight()) {
            int x = 0;
            while (x < map.getMapWidth()) {
                MapSquare sq = map.getSq_MaybeNULL(x, z);
                if (sq.contains(eq)) {
                    return new PointByte(x, z);
                }
                ++x;
            }
            ++z;
        }
        return null;
    }

    public String getName(boolean detailed) {
        if (detailed) {
            if (this.major_type == 9 && this.primed) {
                return String.valueOf(this.name) + " (Prmd)";
            }
            if ((this.major_type == 2 || this.major_type == 21 || this.major_type == 22 || this.major_type == 34) && this.primed) {
                return String.valueOf(this.name) + " (Prmd:" + this.explode_turns + ")";
            }
            if (this.major_type == 1 || this.major_type == 5) {
                return String.valueOf(this.name) + " (" + this.ammo + "/" + this.ammo_capacity + ")";
            }
            return this.name;
        }
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public int getUnitID() {
        return this.unitid;
    }

    public void removeFromUnit() {
        this.unitid = -1;
    }

    public void setUnitID(int id) {
        this.unitid = id;
    }

    public static EquipmentData GetEquipmentData(EquipmentData[] equips, int equipid, String equipcode) {
        int i = 0;
        while (i < equips.length) {
            EquipmentData equip = equips[i];
            if (equip.equip_id == equipid && equip.equipcode.equalsIgnoreCase(equipcode)) {
                return equip;
            }
            ++i;
        }
        throw new RuntimeException("EquipmentData not found: " + equipid);
    }

    public byte getAmmo() {
        return this.ammo;
    }

    public byte getAmmoCapacity() {
        return this.ammo_capacity;
    }

    public void decAmmo() {
        this.ammo = (byte)(this.ammo - 1);
    }

    public void incAmmo() {
        this.ammo = (byte)(this.ammo + 1);
    }

    public void setAmmo(byte a) {
        this.ammo = a;
    }

    public void equipmentDestroyed(GameModule main) {
        if (this.indestructable == 0) {
            this.unitid = -1;
            this.destroyed = true;
            main.updateEquipmentOnServer(this, -1, -1);
            if (this.model != null) {
                this.model.removeFromParent();
            }
        }
    }

    public Point getMapLocation(UnitData[] units, ClientMapData mapdata) {
        int mapz;
        int mapx;
        if (this.getUnitID() > 0) {
            UnitData unit = UnitData.GetUnitDataFromID(units, this.getUnitID());
            mapx = unit.getMapX();
            mapz = unit.getMapY();
        } else {
            PointByte p = EquipmentData.GetEquipmentMapSquare(mapdata, this);
            if (p == null) {
                return null;
            }
            mapx = p.x;
            mapz = p.y;
        }
        return new Point(mapx, mapz);
    }
}

