/*
 * Decompiled with CFR 0.152.
 */
package ssmith.android.framework.modules;

import com.scs.stellarforces.Statics;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import ssmith.android.compatibility.Paint;
import ssmith.android.compatibility.PointF;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.MyEvent;
import ssmith.android.framework.modules.AbstractModule;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Label;
import ssmith.android.lib2d.gui.MultiLineButton;
import ssmith.android.lib2d.layouts.VerticalFlowLayout;
import ssmith.android.lib2d.shapes.Geometry;
import ssmith.lang.GeometryFuncs;

public abstract class AbstractMultilineOptionsModule2
extends AbstractModule {
    private static final float MIN_DRAG_DIST = (float)Statics.SCREEN_HEIGHT / 46.0f;
    private static Paint paint_title = new Paint();
    private ArrayList<String> al_button_texts;
    private ArrayList<String> al_action_cmd_texts;
    private PointF last_down_screen = new PointF();
    private boolean is_dragging = false;
    private Paint paint_paper;
    private Paint paint_ink;
    private boolean can_drag;
    private boolean auto_select;
    private boolean remember_position;
    protected int show;
    protected Label lbl_title;
    private float width;

    static {
        paint_title.setARGB(200, 130, 130, 130);
        paint_title.setAntiAlias(true);
    }

    public AbstractMultilineOptionsModule2(AbstractActivity act, int _return_to, Paint _paint_paper, Paint _paint_ink, int _show, boolean _auto_select, String title, float _width, boolean _remember_position) {
        super(_return_to);
        this.paint_ink = _paint_ink;
        this.paint_paper = _paint_paper;
        this.show = _show;
        this.auto_select = _auto_select;
        this.width = _width;
        this.remember_position = _remember_position;
        this.lbl_title = new Label("title", "                                               ", null, paint_title, false);
        this.lbl_title.setLocation((float)Statics.SCREEN_WIDTH * 0.05f, (float)Statics.SCREEN_HEIGHT * 0.05f);
        this.lbl_title.updateGeometricState();
        this.stat_node.attachChild(this.lbl_title);
        this.stat_node.updateGeometricState();
        this.setTitle(title);
        this.stat_cam.lookAt(Statics.SCREEN_WIDTH / 2, Statics.SCREEN_HEIGHT / 2, true);
    }

    protected void setTitle(String title) {
        this.lbl_title.setText(title);
        this.lbl_title.updateGeometricState();
    }

    public abstract void getOptions();

    public abstract void optionSelected(int var1);

    protected void setOptions() {
        this.al_button_texts = new ArrayList();
        this.al_action_cmd_texts = new ArrayList();
        this.getOptions();
        this.root_node.removeAllChildren();
        if (this.al_button_texts.size() > 0) {
            VerticalFlowLayout menu_node = new VerticalFlowLayout("Menu", (float)Statics.SCREEN_HEIGHT * 0.02f);
            int i = 0;
            while (i < this.al_button_texts.size()) {
                String action_cmd = this.al_action_cmd_texts.get(i);
                if (action_cmd.length() == 0) {
                    action_cmd = String.valueOf(i) + "_" + this.al_button_texts.get(i);
                    this.al_action_cmd_texts.remove(i);
                    this.al_action_cmd_texts.add(i, action_cmd);
                }
                String button_text = this.al_button_texts.get(i);
                MultiLineButton b = new MultiLineButton("mlb", action_cmd, button_text, this.paint_paper, this.paint_ink, true, this.width, true);
                b.setCollides(true);
                menu_node.attachChild(b);
                ++i;
            }
            this.root_node.attachChild(menu_node);
            this.root_node.updateGeometricState();
            boolean bl = this.can_drag = menu_node.getHeight() > (float)Statics.SCREEN_HEIGHT;
            if (this.can_drag) {
                if (this.show == 1) {
                    this.root_cam.lookAt(menu_node.getWorldCentreX(), menu_node.getHeight(), true);
                } else if (this.show == -1) {
                    this.root_cam.lookAt(menu_node.getWorldCentreX(), menu_node.getWorldY() + (float)(Statics.SCREEN_HEIGHT / 2), true);
                } else if (this.show == 0) {
                    this.root_cam.lookAt(menu_node, true);
                }
            } else {
                this.root_cam.lookAt(menu_node, true);
            }
            if (this.remember_position) {
                this.show = 999;
            }
        }
    }

    @Override
    public boolean processEvent(MyEvent ev) throws Exception {
        if (ev.getAction() == 502) {
            float y;
            float x;
            ArrayList<Geometry> colls;
            this.last_down_screen.y = ev.getY();
            if (!this.is_dragging && (colls = this.root_node.getCollidersAt(x = ev.getX() + this.root_cam.left, y = ev.getY() + this.root_cam.top)).size() > 0) {
                for (Geometry g : colls) {
                    AbstractComponent b;
                    String selected_cmd;
                    if (!(g instanceof AbstractComponent) || (selected_cmd = (b = (AbstractComponent)g).getActionCommand()).length() <= 0) continue;
                    this.selectOption(this.al_action_cmd_texts.indexOf(selected_cmd));
                    return true;
                }
            }
            this.is_dragging = false;
        } else if (ev.getAction() == 506) {
            float offy = this.last_down_screen.y - ev.getY();
            double dist = GeometryFuncs.distance(0.0f, 0.0f, 0.0f, offy);
            if (dist > (double)MIN_DRAG_DIST || this.is_dragging) {
                if (this.can_drag) {
                    this.drag(offy);
                }
                this.is_dragging = true;
            }
            this.last_down_screen.y = ev.getY();
        } else if (ev.getAction() == 501) {
            this.last_down_screen.y = ev.getY();
        }
        return false;
    }

    private void selectOption(int idx) {
        this.optionSelected(idx);
    }

    @Override
    public void updateGame(long interpol) {
        if (this.al_button_texts == null) {
            this.setOptions();
            if (this.auto_select && this.al_button_texts != null && this.al_button_texts.size() == 1) {
                this.selectOption(0);
            }
        }
    }

    @Override
    public boolean onBackPressed() {
        this.returnTo();
        return true;
    }

    protected void addOption(String s) {
        this.addOption(s, "" + this.al_action_cmd_texts.size());
    }

    protected void addOption(String text, String cmd) {
        this.addOption(this.al_action_cmd_texts.size(), text, cmd);
    }

    protected void addOption(int pos, String text, String cmd) {
        this.al_button_texts.add(pos, text);
        this.al_action_cmd_texts.add(pos, cmd);
    }

    protected void addOption(String text, int cmd) {
        this.al_button_texts.add(text);
        this.al_action_cmd_texts.add("" + cmd);
    }

    public int getNumOfOptions() {
        return this.al_button_texts.size();
    }

    public boolean areThereAnyOptions() {
        return this.al_button_texts.size() > 0;
    }

    public String getButtonText(int idx) {
        return this.al_button_texts.get(idx);
    }

    public String getActionCommand(int idx) {
        return this.al_action_cmd_texts.get(idx);
    }

    public void removeOption(int idx) {
        this.al_button_texts.remove(idx);
        this.al_action_cmd_texts.remove(idx);
    }

    private void drag(float offy) {
        this.root_cam.moveCam(0.0f, offy);
        if (this.root_node.getHeight() > (float)Statics.SCREEN_HEIGHT) {
            if (this.root_cam.top < this.root_node.getWorldY()) {
                this.root_cam.moveCam(0.0f, this.root_node.getWorldY() - this.root_cam.top);
            } else if (this.root_cam.bottom > this.root_node.getWorldBounds().bottom) {
                this.root_cam.moveCam(0.0f, this.root_node.getWorldBounds().bottom - this.root_cam.bottom);
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        this.drag(mwe.getWheelRotation() * 30);
    }
}

