/*
 * Decompiled with CFR 0.152.
 */
package ssmith.android.framework.modules;

import com.scs.stellarforces.Statics;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import ssmith.android.compatibility.Paint;
import ssmith.android.compatibility.PointF;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.MyEvent;
import ssmith.android.framework.modules.AbstractModule;
import ssmith.android.lib2d.Spatial;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.gui.Label;
import ssmith.android.lib2d.layouts.GridLayout;
import ssmith.android.lib2d.shapes.Geometry;
import ssmith.lang.GeometryFuncs;

public abstract class AbstractOptionsModule2
extends AbstractModule {
    private static final float MIN_DRAG_DIST = (float)Statics.SCREEN_HEIGHT / 46.0f;
    private static Paint paint_title = new Paint();
    private ArrayList<String> al_button_texts;
    private ArrayList<String> al_action_cmd_texts;
    private PointF last_down_screen = new PointF();
    private boolean is_dragging = false;
    private int cols;
    private BufferedImage bmp;
    private Paint paint_ink;
    protected boolean can_drag;
    protected boolean auto_select;
    protected boolean trunc_names;
    protected int show;
    private Label lbl_title;

    static {
        paint_title.setARGB(155, 200, 200, 200);
        paint_title.setAntiAlias(true);
        paint_title.setTypeface(Statics.bigfnt);
    }

    public AbstractOptionsModule2(AbstractActivity act, int _return_to, int _cols, Paint _paint_ink, String buttonFilename, int _show, boolean _auto_select, String title, boolean _trunc_names) {
        super(_return_to);
        this.cols = _cols;
        this.paint_ink = _paint_ink;
        this.bmp = Statics.img_cache.getImage(buttonFilename, (float)Statics.SCREEN_WIDTH * 0.85f / (float)this.cols, (float)(Statics.SCREEN_HEIGHT / 18));
        this.show = _show;
        this.auto_select = _auto_select;
        this.trunc_names = _trunc_names;
        this.lbl_title = new Label("title", "", null, paint_title, false);
        this.lbl_title.setLocation((float)Statics.SCREEN_WIDTH * 0.05f, (float)Statics.SCREEN_HEIGHT * 0.05f);
        this.lbl_title.updateGeometricState();
        this.stat_node.attachChild(this.lbl_title);
        this.stat_node.updateGeometricState();
        this.setTitle(title);
        this.stat_cam.lookAt(Statics.SCREEN_WIDTH / 2, Statics.SCREEN_HEIGHT / 2, true);
    }

    protected void setTitle(String title) {
        this.lbl_title.setText(title);
    }

    public abstract void getOptions();

    public abstract void optionSelected(int var1);

    protected void setOptions() {
        this.al_button_texts = new ArrayList();
        this.al_action_cmd_texts = new ArrayList();
        this.getOptions();
        if (this.auto_select && this.al_button_texts != null && this.al_button_texts.size() == 1) {
            this.selectOption(0);
            return;
        }
        this.root_node.removeAllChildren();
        if (this.al_button_texts.size() > 0) {
            int curr_col = 1;
            int curr_row = 1;
            String longest = "";
            GridLayout menu_node = new GridLayout("Menu", this.bmp.getWidth(), this.bmp.getHeight(), Statics.GetButtonSpacing());
            int i = 0;
            while (i < this.al_button_texts.size()) {
                String action_cmd = this.al_action_cmd_texts.get(i);
                if (action_cmd.length() == 0) {
                    action_cmd = String.valueOf(i) + "_" + this.al_button_texts.get(i);
                    this.al_action_cmd_texts.remove(i);
                    this.al_action_cmd_texts.add(i, action_cmd);
                }
                Button b = new Button(action_cmd, this.al_button_texts.get(i), null, this.paint_ink, this.bmp);
                menu_node.attachChild(b, curr_col, curr_row);
                if (++curr_col > this.cols) {
                    curr_col = 1;
                    ++curr_row;
                }
                if (this.al_button_texts.get(i).length() > longest.length()) {
                    longest = this.al_button_texts.get(i);
                }
                ++i;
            }
            int maxl = this.bmp.getWidth() / 10;
            if (longest.length() > maxl) {
                longest = longest.substring(0, maxl - 1);
            }
            for (Spatial g : menu_node.getChildren()) {
                if (!(g instanceof Button)) continue;
                Button b = (Button)g;
                b.calcTextOffset();
                if (!this.trunc_names) continue;
                String s = b.getText();
                while (this.paint_ink.measureText(s) >= b.getWidth() * 0.95f) {
                    String s_new;
                    int middle = s.length() / 2;
                    s = s_new = String.valueOf(s.substring(0, middle - 2).trim()) + "..." + s.substring(middle + 2).trim();
                }
                b.setText(s);
            }
            this.root_node.attachChild(menu_node);
            this.root_node.updateGeometricState();
            boolean bl = this.can_drag = menu_node.getHeight() > (float)Statics.SCREEN_HEIGHT;
            if (this.can_drag) {
                if (this.show == 1) {
                    this.root_cam.lookAt(menu_node.getWorldCentreX(), menu_node.getHeight(), true);
                } else if (this.show == -1) {
                    this.root_cam.lookAt(menu_node.getWorldCentreX(), menu_node.getWorldY() + (float)(Statics.SCREEN_HEIGHT / 2), true);
                } else if (this.show == 0) {
                    this.root_cam.lookAt(menu_node, true);
                }
            } else {
                this.root_cam.lookAt(menu_node, true);
            }
            this.show = 999;
        }
    }

    @Override
    public boolean processEvent(MyEvent ev) throws Exception {
        if (ev.getAction() == 502) {
            float y;
            float x;
            ArrayList<Geometry> colls;
            this.last_down_screen.y = ev.getY();
            if (!this.is_dragging && (colls = this.root_node.getCollidersAt(x = ev.getX() + this.root_cam.left, y = ev.getY() + this.root_cam.top)).size() > 0) {
                for (Geometry g : colls) {
                    AbstractComponent b;
                    String selected_cmd;
                    if (!(g instanceof AbstractComponent) || (selected_cmd = (b = (AbstractComponent)g).getActionCommand()).length() <= 0) continue;
                    this.selectOption(this.al_action_cmd_texts.indexOf(selected_cmd));
                    return true;
                }
            }
            this.is_dragging = false;
        } else if (ev.getAction() == 506) {
            float offy = this.last_down_screen.y - ev.getY();
            double dist = GeometryFuncs.distance(0.0f, 0.0f, 0.0f, offy);
            if (dist > (double)MIN_DRAG_DIST || this.is_dragging) {
                if (this.can_drag) {
                    this.drag(offy);
                }
                this.is_dragging = true;
            }
            this.last_down_screen.y = ev.getY();
        } else if (ev.getAction() == 501) {
            this.last_down_screen.y = ev.getY();
        }
        return false;
    }

    private void drag(float offy) {
        this.root_cam.moveCam(0.0f, offy);
        if (this.root_node.getHeight() > (float)Statics.SCREEN_HEIGHT) {
            if (this.root_cam.top < this.root_node.getWorldY()) {
                this.root_cam.moveCam(0.0f, this.root_node.getWorldY() - this.root_cam.top);
            } else if (this.root_cam.bottom > this.root_node.getWorldBounds().bottom) {
                this.root_cam.moveCam(0.0f, this.root_node.getWorldBounds().bottom - this.root_cam.bottom);
            }
        }
    }

    private void selectOption(int idx) {
        Statics.act.playSound("type2");
        this.optionSelected(idx);
    }

    @Override
    public void updateGame(long interpol) {
        if (this.al_button_texts == null) {
            this.setOptions();
        }
    }

    @Override
    public boolean onBackPressed() {
        this.returnTo();
        return true;
    }

    protected void addOption(String s) {
        this.addOption(s, s);
    }

    protected void addOption(String text, String cmd) {
        this.al_button_texts.add(text);
        this.al_action_cmd_texts.add(cmd);
    }

    protected void addOption(String text, int cmd) {
        this.al_button_texts.add(text);
        this.al_action_cmd_texts.add("" + cmd);
    }

    public int getNumOfOptions() {
        return this.al_button_texts.size();
    }

    public boolean areThereAnyOptions() {
        return this.al_button_texts.size() > 0;
    }

    public String getButtonText(int idx) {
        return this.al_button_texts.get(idx);
    }

    public String getActionCommand(int idx) {
        return this.al_action_cmd_texts.get(idx);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        this.drag(mwe.getWheelRotation() * 30);
    }
}

