/*
 * Decompiled with CFR 0.152.
 */
package ssmith.android.lib2d;

import com.scs.stellarforces.graphics.GameObject;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import ssmith.android.compatibility.Canvas;
import ssmith.android.compatibility.PointF;
import ssmith.android.compatibility.RectF;
import ssmith.android.lib2d.Camera;
import ssmith.android.lib2d.Lib2DStatics;
import ssmith.android.lib2d.MyPickResults;
import ssmith.android.lib2d.MyPointF;
import ssmith.android.lib2d.PickData;
import ssmith.android.lib2d.Ray;
import ssmith.android.lib2d.Spatial;
import ssmith.android.lib2d.shapes.Geometry;
import ssmith.android.lib2d.shapes.Line;
import ssmith.android.lib2d.shapes.Rectangle;
import ssmith.lang.GeometryFuncs;
import ssmith.lang.GeometryFunctions2;

public class Node
extends Spatial {
    private PointF local_coords = new MyPointF();
    protected PointF world_coords = new MyPointF();
    protected RectF local_bounds = new RectF();
    private ArrayList<Spatial> children = new ArrayList();

    public Node(String name) {
        this(name, 0.0f, 0.0f);
    }

    public Node(String name, float x, float y) {
        super(name);
        this.local_coords.x = x;
        this.local_coords.y = y;
    }

    public int getNumChildren() {
        return this.children.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Spatial> getChildren() {
        ArrayList<Spatial> arrayList = this.children;
        synchronized (arrayList) {
            return this.children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachChild(Spatial s) {
        ArrayList<Spatial> arrayList = this.children;
        synchronized (arrayList) {
            this.attachChild(this.getNumChildren(), s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachChild(int pos, Spatial s) {
        ArrayList<Spatial> arrayList = this.children;
        synchronized (arrayList) {
            if (s.getParent() != null) {
                throw new RuntimeException(s + " already has a parent!");
            }
            if (s == this) {
                throw new RuntimeException("Cannot attach node to itself!");
            }
            this.children.add(pos, s);
            s.setParent(this);
            s.needs_updating = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachChild(Spatial s) {
        ArrayList<Spatial> arrayList = this.children;
        synchronized (arrayList) {
            s.removeFromParent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachAllChildren() {
        ArrayList<Spatial> arrayList = this.children;
        synchronized (arrayList) {
            while (this.children.size() > 0) {
                Spatial s = this.children.get(0);
                s.removeFromParent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateGeometricState() {
        super.getParentWorldCoords();
        this.world_coords.x = this.parent_world_coords.x + this.local_coords.x;
        this.world_coords.y = this.parent_world_coords.y + this.local_coords.y;
        if (this.children.size() > 0) {
            this.local_bounds.left = Float.MAX_VALUE;
            this.local_bounds.top = Float.MAX_VALUE;
            this.local_bounds.right = -3.4028235E38f;
            this.local_bounds.bottom = -3.4028235E38f;
            ArrayList<Spatial> arrayList = this.children;
            synchronized (arrayList) {
                for (Spatial child : this.children) {
                    child.updateGeometricState();
                    this.local_bounds.left = Math.min(this.local_bounds.left, child.world_bounds.left);
                    this.local_bounds.top = Math.min(this.local_bounds.top, child.world_bounds.top);
                    this.local_bounds.right = Math.max(this.local_bounds.right, child.world_bounds.right);
                    this.local_bounds.bottom = Math.max(this.local_bounds.bottom, child.world_bounds.bottom);
                }
            }
        } else {
            this.local_bounds.left = 0.0f;
            this.local_bounds.top = 0.0f;
            this.local_bounds.right = 0.0f;
            this.local_bounds.bottom = 0.0f;
        }
        this.world_bounds.left = this.local_bounds.left;
        this.world_bounds.top = this.local_bounds.top;
        this.world_bounds.right = this.local_bounds.right;
        this.world_bounds.bottom = this.local_bounds.bottom;
        this.needs_updating = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDraw(Canvas g, Camera cam, long interpol) {
        if (this.visible) {
            if (Lib2DStatics.DEBUG_GFX) {
                RectF temp_rect = new RectF(this.world_bounds.left - cam.left - 2.0f, this.world_bounds.top - cam.top - 2.0f, this.world_bounds.right - cam.left + 2.0f, this.world_bounds.bottom - cam.top + 2.0f);
                g.drawRect(temp_rect, Lib2DStatics.paint_red_line);
            }
            ArrayList<Spatial> arrayList = this.children;
            synchronized (arrayList) {
                try {
                    for (Spatial child : this.children) {
                        if (!child.visible || !RectF.intersects(child.getWorldBounds(), cam)) continue;
                        child.doDraw(g, cam, interpol);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean intersects(Spatial s) {
        if (s instanceof Node || s instanceof Rectangle) {
            return RectF.intersects(this.world_bounds, s.getWorldBounds());
        }
        if (s instanceof Line) {
            Line l2 = (Line)s;
            return GeometryFunctions2.isLineIntersectingRectangle(l2.world_bounds.left, l2.world_bounds.top, l2.world_bounds.right, l2.world_bounds.bottom, this.world_bounds.left, this.world_bounds.top, this.world_bounds.right, this.world_bounds.bottom);
        }
        throw new RuntimeException("intersects() not implemented in Node for " + s);
    }

    @Override
    public boolean contains(float x, float y) {
        return this.world_bounds.contains(x, y);
    }

    public void removeAllChildren() {
        this.detachAllChildren();
    }

    @Override
    public void setLocation(float x, float y) {
        this.local_coords.x = x;
        this.local_coords.y = y;
    }

    @Override
    public void setSize(float w, float h) {
        throw new RuntimeException("Cannot directly set size of a node!");
    }

    public PointF getLocation() {
        return this.local_coords;
    }

    @Override
    public float getHeight() {
        return this.local_bounds.bottom - this.local_bounds.top;
    }

    @Override
    public float getWidth() {
        return this.local_bounds.right - this.local_bounds.left;
    }

    public void setCentre(float x, float y) {
        if (this.getWidth() == 0.0f || this.getHeight() == 0.0f) {
            throw new RuntimeException(String.valueOf(this.name) + " has no dimensions yet.  Try calling UpdateGeometricState().");
        }
        float x2 = x - this.getWidth() / 2.0f;
        float y2 = y - this.getHeight() / 2.0f;
        this.setLocation(x2, y2);
    }

    public void findPick(Ray ray, MyPickResults results) {
        float size = Math.max(this.getWidth(), this.getHeight());
        Line l = new Line("LOS", ray.getOrigin(), ray.getOrigin().add(ray.getDirection().multiply(size)), null);
        this.attachChild(l);
        l.updateGeometricState();
        ArrayList<Geometry> colls = l.getColliders(this);
        l.removeFromParent();
        for (Geometry g : colls) {
            if (!(g instanceof GameObject)) continue;
            GameObject o = (GameObject)g;
            float dist = GeometryFuncs.distance(ray.origin.x, ray.origin.y, g.getWorldCentreX(), g.getWorldCentreY());
            PickData p = new PickData(o, dist);
            results.add(p);
        }
        results.sort();
    }

    public ArrayList<Geometry> getCollidersAt(float x, float y) {
        ArrayList<Geometry> list = new ArrayList<Geometry>();
        this.getCollidersAt(x, y, list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getCollidersAt(float x, float y, ArrayList<Geometry> list_of_colliders) {
        if (this.collides && this.contains(x, y)) {
            ArrayList<Spatial> arrayList = this.children;
            synchronized (arrayList) {
                for (Spatial child : this.children) {
                    if (!child.collides || !child.contains(x, y)) continue;
                    if (child instanceof Node) {
                        Node ch = (Node)child;
                        ch.getCollidersAt(x, y, list_of_colliders);
                        continue;
                    }
                    list_of_colliders.add((Geometry)child);
                }
            }
        }
    }

    public void setCollides(boolean b) {
        this.collides = true;
        for (Spatial s : this.getChildren()) {
            s.collides = b;
        }
    }
}

