/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.game.ai;

import com.scs.stellarforces.game.GameModule;
import dsr.data.UnitData;
import ssmith.android.lib2d.Ray;

public abstract class AbstractAI {
    public static final int AI_ROTATE = 1;
    public static final int AI_DESTROY_COMPUTERS = 2;
    protected UnitData unit;

    public AbstractAI(UnitData _unit) {
        this.unit = _unit;
    }

    public abstract boolean process(GameModule var1);

    public void shootAtEnemyEnemies(GameModule game) {
        UnitData enemy = this.getSeenEnemy(game);
        if (enemy != null) {
            boolean can_target_see = game.canUnitSeeUnit(enemy, this.unit, true);
            Ray targetting_ray = new Ray();
            targetting_ray.origin = this.unit.model.getWorldCentre_CreatesNew();
            targetting_ray.direction = enemy.model.getWorldCentre_CreatesNew().copy().subtract(this.unit.model.getWorldCentre_CreatesNew()).normalize();
            game.shoot(this.unit, GameModule.GetAimedShotAccuracy(this.unit), this.getShotAPs(), can_target_see, targetting_ray);
        }
    }

    public UnitData getSeenEnemy(GameModule game) {
        int i_enemy = 0;
        while (i_enemy < game.units.length) {
            if (!game.game_data.areSidesFriends(game.units[i_enemy].getSide(), this.unit.getSide()) && game.units[i_enemy].getStatus() == 2 && game.canUnitSeeUnit(this.unit, game.units[i_enemy], true)) {
                return game.units[i_enemy];
            }
            ++i_enemy;
        }
        return null;
    }

    protected int getShotAPs() {
        if (this.unit.current_item != null) {
            return this.unit.current_item.aimed_shot_aps;
        }
        return 999;
    }
}

