/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.graphics;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.game.IProcessable;
import com.scs.stellarforces.graphics.GameObject;
import java.awt.image.BufferedImage;
import ssmith.android.compatibility.Canvas;
import ssmith.android.lib2d.Camera;
import ssmith.android.lib2d.MyPointF;

public abstract class AbstractAreaEffectGun
extends GameObject
implements IProcessable {
    private MyPointF move_dir;
    private MyPointF pixel_end;
    private float max_dist;
    private float dist_so_far = 0.0f;
    private BufferedImage bmp;

    public AbstractAreaEffectGun(GameModule _game, String name, String r, MyPointF pxl_start, MyPointF _pixel_end) {
        super(_game, name, false, pxl_start.x, pxl_start.y, Statics.SQ_SIZE, Statics.SQ_SIZE, false, false);
        this.pixel_end = _pixel_end;
        this.bmp = Statics.img_cache.getImage(r, Statics.SQ_SIZE, Statics.SQ_SIZE);
        this.move_dir = this.pixel_end.subtract(pxl_start).normalize().multiply(Statics.BULLET_MOVE_DIST);
        this.max_dist = this.pixel_end.subtract(pxl_start).length();
        this.game.attachToRootNode_Top(this, true);
        this.game.addToProcess(this);
    }

    @Override
    public void process(long interpol) {
        if (this.move_dir.length() == 0.0f) {
            this.remove();
        } else {
            MyPointF act_dir = this.move_dir.multiply(interpol);
            this.adjustLocation(act_dir);
            this.dist_so_far += act_dir.length();
            this.updateGeometricState();
            if (this.dist_so_far > this.max_dist) {
                this.remove();
            } else {
                this.checkSquares();
            }
        }
    }

    protected abstract void checkSquares();

    private void remove() {
        this.game.removeFromProcess(this);
        this.removeFromParent();
    }

    @Override
    public void doDraw(Canvas g, Camera cam, long interpol) {
        if (this.visible) {
            g.drawImage(this.bmp, this.world_bounds.left - cam.left, this.world_bounds.top - cam.top, this.paint);
        }
    }
}

