/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.graphics;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.game.TextureStateCache;
import com.scs.stellarforces.graphics.MapSquareImage;
import dsr.data.MapSquare;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import ssmith.android.lib2d.layouts.EfficientGridLayout;
import ssmith.awt.ImageFunctions;

public class MapNode
extends EfficientGridLayout {
    private static final String RAISED_TEX = "RAISED_TEX_";
    private static final String WALL_3D = "WALL3D_";
    private static final String SCENERY = "SCENERY_";
    private GameModule game;
    private static Hashtable<String, BufferedImage> bmp_cache = new Hashtable();

    public MapNode(GameModule _game) {
        super(_game.mapdata.getMapWidth(), _game.mapdata.getMapHeight(), Statics.SQ_SIZE);
        this.game = _game;
        this.createMapModel();
    }

    private void createMapModel() {
        int y = 0;
        while (y < this.game.mapdata.getMapHeight()) {
            int x = 0;
            while (x < this.game.mapdata.getMapWidth()) {
                MapSquare sq = this.game.mapdata.getSq_MaybeNULL(x, y);
                String key = "" + sq.texture_code;
                BufferedImage bmp = null;
                if ((sq.escape_hatch_side == this.game.game_data.our_side || sq.escape_hatch_side > 4) && this.game.game_data.our_side > 0) {
                    bmp = GameModule.ImgCache.getImage("escape_hatch.jpg", Statics.SQ_SIZE_INT, Statics.SQ_SIZE_INT);
                    key = String.valueOf(key) + "_escapehatch";
                } else if (sq.deploy_sq_side > 0 && sq.major_type == 1 && this.game.game_data.areSidesFriends(sq.deploy_sq_side, this.game.game_data.our_side) && this.game.game_data.game_status == 20) {
                    bmp = GameModule.ImgCache.getImage("deploy_sq", Statics.SQ_SIZE_INT, Statics.SQ_SIZE_INT);
                    key = String.valueOf(key) + "_deploy" + sq.deploy_sq_side;
                } else if (sq.deploy_sq_side > 0 && sq.major_type == 1 && !this.game.game_data.areSidesFriends(sq.deploy_sq_side, this.game.game_data.our_side) && this.game.game_data.game_status == 20) {
                    bmp = GameModule.ImgCache.getImage("deploy_sq_opponent", Statics.SQ_SIZE_INT, Statics.SQ_SIZE_INT);
                    key = String.valueOf(key) + "_deploy" + sq.deploy_sq_side;
                } else {
                    bmp = GameModule.ImgCache.getImage(TextureStateCache.GetTexResourceID(sq.texture_code), Statics.SQ_SIZE_INT, Statics.SQ_SIZE_INT);
                    if (bmp == null) {
                        bmp = GameModule.ImgCache.getImage(String.valueOf(TextureStateCache.GetTexResourceID(sq.texture_code)) + ".jpg", Statics.SQ_SIZE_INT, Statics.SQ_SIZE_INT);
                    }
                }
                if (bmp == null) {
                    throw new RuntimeException("No image for tex code " + sq.texture_code);
                }
                if (sq.raised_texture_code > 0) {
                    if (bmp_cache.containsKey(key = String.valueOf(key) + "_" + RAISED_TEX + sq.raised_texture_code)) {
                        bmp = bmp_cache.get(key);
                    } else {
                        BufferedImage raised_bmp = GameModule.ImgCache.getImage(TextureStateCache.GetTexResourceID(sq.raised_texture_code), Statics.SQ_SIZE_INT, Statics.SQ_SIZE_INT);
                        bmp = ImageFunctions.CombineBitmaps(bmp, raised_bmp);
                        bmp_cache.put(key, bmp);
                    }
                }
                if (sq.scenery_code > 0 && TextureStateCache.GetSceneryResourceID(sq.scenery_code).length() > 0) {
                    if (bmp_cache.containsKey(key = String.valueOf(key) + "_" + SCENERY + sq.scenery_code)) {
                        bmp = bmp_cache.get(key);
                    } else {
                        BufferedImage scenery_bmp = GameModule.ImgCache.getImage(TextureStateCache.GetSceneryResourceID(sq.scenery_code), Statics.SQ_SIZE_INT, Statics.SQ_SIZE_INT);
                        bmp = ImageFunctions.CombineBitmaps(bmp, scenery_bmp);
                        bmp_cache.put(key, bmp);
                    }
                }
                if (sq.major_type == 3) {
                    boolean change = false;
                    if (y < this.game.mapdata.getMapHeight() - 1) {
                        MapSquare sq_down = this.game.mapdata.getSq_MaybeNULL(x, y + 1);
                        if (sq_down.major_type != 3 && sq_down.door_type <= 0) {
                            change = true;
                        }
                    } else {
                        change = true;
                    }
                    if (change) {
                        if (bmp_cache.containsKey(key = String.valueOf(key) + "_" + WALL_3D + sq.texture_code)) {
                            bmp = bmp_cache.get(key);
                        } else {
                            BufferedImage bmp2 = ImageFunctions.Clone(bmp);
                            if (bmp2 != null) {
                                bmp = bmp2;
                                int by = (int)((float)bmp.getHeight() * 0.4f);
                                while (by < bmp.getHeight()) {
                                    int bx = 0;
                                    while (bx < bmp.getWidth()) {
                                        int pixel = bmp.getRGB(bx, by);
                                        Color c = new Color(pixel);
                                        c = c.darker();
                                        bmp.setRGB(bx, by, c.getRGB());
                                        ++bx;
                                    }
                                    ++by;
                                }
                            }
                            bmp_cache.put(key, bmp);
                        }
                    }
                }
                MapSquareImage bc = new MapSquareImage(this.game, "Map_Sq", sq, bmp, (byte)x, (byte)y);
                super.setRectAtMap(bc, x, y);
                if (sq.major_type == 1) {
                    boolean wall_left = false;
                    boolean wall_left_bottom = false;
                    boolean wall_bottom = false;
                    if (x > 0) {
                        wall_left = this.game.mapdata.getSq_MaybeNULL(x - 1, y).castsShadow();
                    }
                    if (x > 0 && y < this.game.mapdata.getMapHeight() - 1) {
                        wall_left_bottom = this.game.mapdata.getSq_MaybeNULL(x - 1, y + 1).castsShadow();
                    }
                    if (y < this.game.mapdata.getMapHeight() - 1) {
                        wall_bottom = this.game.mapdata.getSq_MaybeNULL(x, y + 1).castsShadow();
                    }
                    int checksum = 0;
                    checksum += wall_left ? 1 : 0;
                    checksum += wall_left_bottom ? 2 : 0;
                    if ((checksum += wall_bottom ? 4 : 0) == 1) {
                        bc.bmp_shad = GameModule.ImgCache.getImage(TextureStateCache.GetTexResourceID(95), Statics.SQ_SIZE / 2.0f, Statics.SQ_SIZE);
                    } else if (checksum == 2) {
                        bc.bmp_shad = GameModule.ImgCache.getImage(TextureStateCache.GetTexResourceID(96), Statics.SQ_SIZE / 2.0f, Statics.SQ_SIZE / 2.0f);
                        bc.shad_offset_y = Statics.SQ_SIZE / 2.0f;
                    } else if (checksum == 4) {
                        bc.bmp_shad = GameModule.ImgCache.getImage(TextureStateCache.GetTexResourceID(97), Statics.SQ_SIZE, Statics.SQ_SIZE / 2.0f);
                        bc.shad_offset_y = Statics.SQ_SIZE / 2.0f;
                    } else if (checksum == 3) {
                        bc.bmp_shad = GameModule.ImgCache.getImage(TextureStateCache.GetTexResourceID(96), Statics.SQ_SIZE / 2.0f, Statics.SQ_SIZE);
                    } else if (checksum == 5 || checksum == 7) {
                        bc.bmp_shad = GameModule.ImgCache.getImage(TextureStateCache.GetTexResourceID(94), Statics.SQ_SIZE, Statics.SQ_SIZE);
                    } else if (checksum == 6) {
                        bc.bmp_shad = GameModule.ImgCache.getImage(TextureStateCache.GetTexResourceID(96), Statics.SQ_SIZE, Statics.SQ_SIZE / 2.0f);
                        bc.shad_offset_y = Statics.SQ_SIZE / 2.0f;
                    }
                }
                ++x;
            }
            ++y;
        }
        this.game.root_node.updateGeometricState();
    }
}

