/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.graphics;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.game.IProcessable;
import com.scs.stellarforces.graphics.GameObject;
import java.awt.image.BufferedImage;
import ssmith.android.compatibility.Canvas;
import ssmith.android.lib2d.Camera;

public class Sparks
extends GameObject
implements IProcessable {
    private static final float SIZE = (float)Statics.SCREEN_WIDTH * 0.015f;
    private static final float MAX_SIZE = Statics.SQ_SIZE;
    private static final float SPEED = Statics.SQ_SIZE / 10.0f;
    private BufferedImage bmp = GameModule.ImgCache.getImage("explosion1", SIZE, SIZE);
    private float dist = 0.0f;

    public Sparks(GameModule game, float pxl_centre_x, float pxl_centre_y) {
        super(game, "Sparks", false, pxl_centre_x, pxl_centre_y, 0.0f, 0.0f, false, false);
        game.attachToRootNode_Top(this, true);
        this.updateGeometricState();
        game.addToProcess(this);
    }

    @Override
    public void doDraw(Canvas g, Camera cam, long interpol) {
        g.drawImage(this.bmp, this.world_bounds.left - cam.left - this.dist, this.world_bounds.top - cam.top - this.dist, this.paint);
        g.drawImage(this.bmp, this.world_bounds.left - cam.left + this.dist, this.world_bounds.top - cam.top - this.dist, this.paint);
        g.drawImage(this.bmp, this.world_bounds.left - cam.left - this.dist, this.world_bounds.top - cam.top + this.dist, this.paint);
        g.drawImage(this.bmp, this.world_bounds.left - cam.left + this.dist, this.world_bounds.top - cam.top + this.dist, this.paint);
    }

    @Override
    public void process(long interpol) {
        this.dist += SPEED;
        if (this.dist > MAX_SIZE) {
            this.removeFromParent();
            this.game.removeFromProcess(this);
        }
    }
}

