/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.start.ErrorModule;
import com.scs.stellarforces.start.ListGamesModule;
import dsr.comms.PlayersGamesComms;
import dsr.comms.WGet_SF;
import dsr.data.GameData;
import java.io.IOException;
import java.util.ArrayList;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.AbstractPleaseWaitModule;

public final class GetGamesModule
extends AbstractPleaseWaitModule {
    private boolean auto_select;

    public GetGamesModule(AbstractActivity _act, boolean _auto_select) {
        super(_act, 4);
        this.auto_select = _auto_select;
        this.setBackground("space1.jpg");
    }

    @Override
    public void started() {
        AbstractActivity act = Statics.act;
        this.start();
        act.resumeMusic();
        if (GameModule.ImgCache != null) {
            GameModule.ImgCache.clear();
        }
    }

    @Override
    public void run() {
        AbstractActivity act = Statics.act;
        try {
            String s = PlayersGamesComms.GetPlayersGamesRequest(Statics.LAST_LOGIN, Statics.LAST_PWD);
            WGet_SF wget = new WGet_SF(act, this, s);
            if (wget.getResponseCode() == 200 || wget.getResponseCode() == -1) {
                String response = wget.getResponse();
                ArrayList<GameData> games = PlayersGamesComms.DecodeGameDataResponse(response);
                super.getMainThread().setNextModule(new ListGamesModule(act, games, this.auto_select));
            } else {
                super.getMainThread().setNextModule(new ErrorModule(act, 4, "Error Getting Games", "Apologies, there was an error getting your current games."));
            }
        }
        catch (IOException ex) {
            AbstractActivity.HandleError(ex);
        }
    }
}

