/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start;

import com.scs.stellarforces.Statics;
import java.awt.image.BufferedImage;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.framework.modules.SimpleScrollingAbstractModule;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.gui.CheckBox;
import ssmith.android.lib2d.gui.GUIFunctions;
import ssmith.android.lib2d.layouts.HorizontalFlowGridLayout;
import ssmith.android.lib2d.layouts.VerticalFlowLayout;

public class OptionsModule
extends SimpleScrollingAbstractModule {
    private static final float ICON_WIDTH = (float)Statics.SCREEN_WIDTH * 0.6f;
    private static final float ICON_HEIGHT = Statics.SCREEN_WIDTH / 10;
    private CheckBox cb_mute_sfx;
    private CheckBox cb_mute_music;
    private CheckBox cb_new_movement_icons;
    private Button save;
    private Button cancel;
    private static Paint paint_normal_text = new Paint();

    static {
        paint_normal_text.setARGB(255, 255, 255, 255);
        paint_normal_text.setAntiAlias(true);
        paint_normal_text.setTextSize(GUIFunctions.GetTextSizeToFit("Use buttons for movemement", ICON_WIDTH, ICON_HEIGHT));
    }

    public OptionsModule(AbstractActivity act) {
        super(13);
        this.setBackground("space1.jpg");
        BufferedImage bmp_mf_yellow = Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH, ICON_HEIGHT);
        BufferedImage bmp_mf_blue = Statics.img_cache.getImage("lumin_green_button2", ICON_WIDTH / 2.0f, ICON_HEIGHT);
        VerticalFlowLayout vfl = new VerticalFlowLayout("vfl", 5.0f);
        boolean mute_sfx = Statics.MUTE_SFX == 1;
        this.cb_mute_sfx = new CheckBox("Mute SFX", null, paint_normal_text, bmp_mf_yellow, mute_sfx);
        vfl.attachChild(this.cb_mute_sfx);
        boolean mute_music = Statics.MUTE_MUSIC == 1;
        this.cb_mute_music = new CheckBox("Mute Music", null, paint_normal_text, bmp_mf_yellow, mute_music);
        vfl.attachChild(this.cb_mute_music);
        boolean new_movement_icons = Statics.USE_NEW_MOVEMENT_ICONS == 1;
        this.cb_new_movement_icons = new CheckBox("New Movement Icons", null, paint_normal_text, bmp_mf_yellow, new_movement_icons);
        vfl.attachChild(this.cb_new_movement_icons);
        HorizontalFlowGridLayout hfl = new HorizontalFlowGridLayout("hfl", 5.0f);
        this.save = new Button("Save Settings", null, paint_normal_text, bmp_mf_blue);
        hfl.attachChild(this.save);
        this.cancel = new Button("Cancel", null, paint_normal_text, bmp_mf_blue);
        hfl.attachChild(this.cancel);
        vfl.attachChild(hfl);
        this.root_node.attachChild(vfl);
        this.root_node.updateGeometricState();
        this.root_cam.lookAt(this.root_node, true);
    }

    @Override
    public void handleClick(AbstractComponent c) throws Exception {
        if (c instanceof CheckBox) {
            CheckBox cb = (CheckBox)c;
            cb.toggle();
        } else if (c == this.cancel) {
            this.returnTo();
        } else if (c == this.save) {
            this.saveSettings();
            this.returnTo();
        }
    }

    private void saveSettings() {
        AbstractActivity act = Statics.act;
        if (this.cb_mute_music.isChecked()) {
            Statics.MUTE_MUSIC = 1;
            act.pauseMusic();
        } else {
            Statics.MUTE_MUSIC = 0;
            act.resumeMusic();
        }
        Statics.MUTE_SFX = this.cb_mute_sfx.isChecked() ? 1 : 0;
        Statics.USE_NEW_MOVEMENT_ICONS = this.cb_new_movement_icons.isChecked() ? 1 : 0;
        Statics.SavePrefs();
    }
}

