/*
 * Decompiled with CFR 0.152.
 */
package com.scs.stellarforces.start.equip;

import com.scs.stellarforces.Statics;
import com.scs.stellarforces.start.equip.EquipUnitsModule3;
import com.scs.stellarforces.start.equip.SelectArmourModule;
import dsr.data.EquipmentData;
import dsr.data.GameData;
import dsr.data.UnitData;
import ssmith.android.compatibility.Canvas;
import ssmith.android.compatibility.Paint;
import ssmith.android.compatibility.Typeface;
import ssmith.android.lib2d.Camera;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.Button;
import ssmith.android.lib2d.gui.MultiLineLabel;
import ssmith.android.lib2d.layouts.GridLayout;
import ssmith.android.lib2d.layouts.VerticalFlowLayout;

public class EquipUnitControl
extends VerticalFlowLayout {
    private static final float WIDTH = (float)Statics.SCREEN_WIDTH * 0.24f;
    private static final float HEIGHT = (float)Statics.SCREEN_HEIGHT * 0.13f;
    private EquipUnitsModule3 parent;
    private UnitData unit;
    private MultiLineLabel bought_items;
    private Button buy;
    private Button remove_item;
    private static Paint paint_unit_name = new Paint();
    private static Paint paint_normal_text = new Paint();

    static {
        paint_unit_name.setARGB(255, 255, 255, 255);
        paint_unit_name.setAntiAlias(true);
        paint_unit_name.setTextSize(Statics.GetHeightScaled(0.06f));
        paint_unit_name.setStrokeWidth((float)Statics.SCREEN_WIDTH / 250.0f);
        paint_normal_text.setARGB(255, 255, 255, 255);
        paint_normal_text.setAntiAlias(true);
        paint_normal_text.setTextSize(Statics.GetHeightScaled(0.04f));
    }

    public EquipUnitControl(EquipUnitsModule3 _parent, UnitData _unit, float GAP, GameData game_data, Typeface tf) {
        super("EquipUnitControl", GAP);
        paint_unit_name.setTypeface(tf);
        paint_normal_text.setTypeface(tf);
        this.parent = _parent;
        this.unit = _unit;
        GridLayout hfgl1 = new GridLayout("hfgl1", WIDTH, HEIGHT, GAP);
        this.bought_items = new MultiLineLabel("bought_items", "", null, paint_normal_text, true, WIDTH * 2.0f);
        hfgl1.attachChild(this.bought_items, 0, 0);
        this.buy = new Button("Buy Item", null, paint_normal_text, Statics.img_cache.getImage("button_green", WIDTH, HEIGHT));
        hfgl1.attachChild(this.buy, 2, 0);
        this.remove_item = new Button("Remove Item", null, paint_normal_text, Statics.img_cache.getImage("button_blue", WIDTH, HEIGHT));
        hfgl1.attachChild(this.remove_item, 3, 0);
        this.attachChild(hfgl1);
        this.updateItemList();
    }

    public void updateItemList() {
        StringBuffer str = new StringBuffer(String.valueOf(this.unit.name) + "\n");
        boolean any = false;
        EquipmentData[] equipmentDataArray = SelectArmourModule.bought_equipment;
        int n = SelectArmourModule.bought_equipment.length;
        int n2 = 0;
        while (n2 < n) {
            EquipmentData eq = equipmentDataArray[n2];
            if (!eq.destroyed && eq.getUnitID() == this.unit.unitid) {
                str.append(String.valueOf(eq.getName(false)) + ", ");
                any = true;
            }
            ++n2;
        }
        if (any) {
            str.delete(str.length() - 2, str.length());
        } else {
            str.append("*No Equipment Selected*");
        }
        this.bought_items.setText(str.toString());
    }

    public void handleClick(AbstractComponent c) throws Exception {
        if (c == this.buy) {
            this.parent.buyItem(this.unit);
            this.updateItemList();
        } else if (c == this.remove_item) {
            this.parent.removeItem(this.unit, this);
        }
    }

    @Override
    public void doDraw(Canvas g, Camera cam, long interpol) {
        g.drawImage(Statics.img_cache.getImage("button_blue_darker", this.getWidth(), this.getHeight()), this.getScreenX(cam), this.getScreenY(cam), null);
        super.doDraw(g, cam, interpol);
    }
}

