/*
 * Decompiled with CFR 0.152.
 */
package dsr.comms;

import com.scs.stellarforces.Statics;
import dsr.data.ClientMapData;
import dsr.data.MapSquare;
import ssmith.lang.NumberFunctions;

public final class MapDataComms {
    public static String GetMapDataRequest(int gameid) {
        return "cmd=mapdata&version=" + Statics.COMMS_VERSION + "&getput=" + "get" + "&gid=" + gameid;
    }

    public static ClientMapData DecodeMapDataResponse(String response) {
        response = response.replaceAll("\r\n", "");
        String[] data = response.split("\\|", -1);
        int w = -1;
        int pos = 0;
        MapSquare[][] mapdata = null;
        do {
            if (data[pos].equalsIgnoreCase("width")) {
                w = NumberFunctions.ParseInt(data[pos + 1]);
                pos += 2;
                continue;
            }
            if (data[pos].equalsIgnoreCase("height")) {
                int h = NumberFunctions.ParseInt(data[pos + 1]);
                mapdata = new MapSquare[w][h];
                pos += 2;
                continue;
            }
            if (data[pos].equalsIgnoreCase("ms")) {
                int id = NumberFunctions.ParseInt(data[pos + 1]);
                byte x = NumberFunctions.ParseByte(data[pos + 2]);
                byte z = NumberFunctions.ParseByte(data[pos + 3]);
                byte type = NumberFunctions.ParseByte(data[pos + 4]);
                byte door = NumberFunctions.ParseByte(data[pos + 5]);
                byte deploy_sq_side = NumberFunctions.ParseByte(data[pos + 6]);
                byte escape_hatch_side = NumberFunctions.ParseByte(data[pos + 7]);
                short floor_tex = NumberFunctions.ParseShort(data[pos + 8]);
                byte destroyed = NumberFunctions.ParseByte(data[pos + 9]);
                byte door_open = 0;
                short scenery_code = 0;
                byte scenery_direction = 0;
                short raised_floor_tex = 0;
                byte smoke_type = -1;
                int smoke_caused_by = -1;
                byte owner_side = 0;
                try {
                    door_open = NumberFunctions.ParseByte(data[pos + 10]);
                    scenery_code = NumberFunctions.ParseShort(data[pos + 11]);
                    scenery_direction = NumberFunctions.ParseByte(data[pos + 12]);
                    raised_floor_tex = NumberFunctions.ParseShort(data[pos + 13]);
                    smoke_type = NumberFunctions.ParseByte(data[pos + 14]);
                    smoke_caused_by = NumberFunctions.ParseInt(data[pos + 15]);
                    owner_side = NumberFunctions.ParseByte(data[pos + 16]);
                    pos += 17;
                }
                catch (Exception ex) {
                    pos += 10;
                }
                MapSquare ms = new MapSquare(id, type, x, z, deploy_sq_side, escape_hatch_side, floor_tex, destroyed, door_open, raised_floor_tex, smoke_type, smoke_caused_by, owner_side);
                ms.door_type = door;
                ms.scenery_code = scenery_code;
                mapdata[x][z] = ms;
                continue;
            }
            ++pos;
        } while (pos < data.length);
        if (mapdata == null) {
            throw new RuntimeException("Error decoding map data");
        }
        return new ClientMapData(mapdata);
    }

    public static String GetMapDataUpdateRequest(int gameid, String gamecode, MapSquare sq, int caused_by_side) {
        StringBuffer str = new StringBuffer();
        str.append(String.valueOf(gameid) + "|");
        str.append(String.valueOf(gamecode) + "|");
        str.append(String.valueOf(sq.x) + "|");
        str.append(String.valueOf(sq.y) + "|");
        str.append(String.valueOf(sq.major_type) + "|");
        str.append(String.valueOf(sq.destroyed) + "|");
        str.append(String.valueOf(sq.texture_code) + "|");
        str.append(String.valueOf(sq.door_type) + "|");
        str.append(String.valueOf(sq.door_open ? 1 : 0) + "|");
        str.append(String.valueOf(caused_by_side) + "|");
        str.append(String.valueOf(sq.smoke_type) + "|");
        str.append(String.valueOf(sq.smoke_caused_by) + "|");
        str.append(String.valueOf(System.currentTimeMillis()) + "|");
        str.append(String.valueOf(sq.owner_side) + "|");
        str.append(String.valueOf(sq.raised_texture_code) + "|");
        str.append(String.valueOf(sq.scenery_code) + "|");
        return "cmd=mapdata&version=" + Statics.COMMS_VERSION + "&getput=" + "put" + "&data=" + str.toString();
    }
}

