/*
 * Decompiled with CFR 0.152.
 */
package dsr.data;

import com.scs.stellarforces.SoundSelector;
import com.scs.stellarforces.Statics;
import com.scs.stellarforces.game.GameModule;
import com.scs.stellarforces.game.ai.AbstractAI;
import com.scs.stellarforces.game.ai.SimpleRotateAI;
import com.scs.stellarforces.graphics.AbstractCorpse;
import com.scs.stellarforces.graphics.ExpandingTextLabel;
import com.scs.stellarforces.graphics.Ghost;
import com.scs.stellarforces.graphics.icons.AbstractIcon;
import com.scs.stellarforces.graphics.units.AbstractUnit;
import com.scs.stellarforces.graphics.units.Blob;
import dsr.data.EquipmentData;
import dsr.data.MapSquare;
import dsrwebserver.tables.EquipmentTypesTable;
import java.util.ArrayList;
import ssmith.android.framework.AbstractActivity;
import ssmith.lang.GeometryFuncs;
import ssmith.lang.NumberFunctions;

public final class UnitData
implements Cloneable {
    public int num;
    public int unitid;
    public int order_by;
    public byte model_type;
    public byte unit_type;
    public byte on_fire;
    private byte side;
    private byte status;
    public String name;
    public String unitcode;
    public int map_x;
    public int map_y;
    public int angle;
    public int aps;
    public int max_aps;
    public int opp_fire_aps_req;
    public int protection;
    public int armour_type_id;
    public byte can_deploy;
    public byte can_equip;
    public byte opp_fire_01;
    public int max_health;
    public int shot_skill;
    public int combat_skill;
    public int strength;
    public int skillid;
    private int health;
    public ArrayList<EquipmentData> items = new ArrayList();
    public EquipmentData current_item;
    public int current_item_id_TMP;
    public boolean has_been_seen = false;
    public boolean can_use_equipment;
    public AbstractUnit model;
    public AbstractIcon icon;
    public ArrayList<UnitData> can_see_at_start = new ArrayList();
    private ArrayList<UnitData> can_see = new ArrayList();
    public int curr_morale;
    public int curr_energy;
    public byte panicked;
    public AbstractAI ai;
    public int uni_unitid;

    public UnitData(int n) {
        this.num = n;
    }

    public UnitData(int _uni_unitid, String _name) {
        this.uni_unitid = _uni_unitid;
        this.name = _name;
    }

    public UnitData clone() {
        try {
            return (UnitData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte getSide() {
        return this.side;
    }

    public void setSide(byte b) {
        this.side = b;
    }

    public String toString() {
        return "Unit: " + this.name + " (S:" + this.side + " ID:" + this.unitid + ")";
    }

    public void clearSeenUnits() {
        this.can_see.clear();
    }

    public void setCanSee(UnitData unit) {
        this.can_see.add(unit);
    }

    public boolean canUnitSee(UnitData unit) {
        if (this.on_fire == 1) {
            return false;
        }
        return this.can_see.contains(unit);
    }

    public UnitData getFirstVisibileEnemy() {
        if (this.can_see.size() > 0) {
            return this.can_see.get(0);
        }
        return null;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(byte i) {
        this.status = i;
    }

    public static UnitData GetUnitDataFromID(UnitData[] units, int unitid) {
        int i = 0;
        while (i < units.length) {
            UnitData unit = units[i];
            if (unit.unitid == unitid) {
                return unit;
            }
            ++i;
        }
        throw new RuntimeException("UnitData '" + unitid + "' not found");
    }

    public static UnitData GetUnitDataFromID(ArrayList<UnitData> units, int unitid) {
        int i = 0;
        while (i < units.size()) {
            UnitData unit = units.get(i);
            if (unit.unitid == unitid) {
                return unit;
            }
            ++i;
        }
        throw new RuntimeException("UnitData '" + unitid + "' not found");
    }

    public static UnitData GetUnitDataFromMapSq(UnitData[] units, int mx, int my, byte side, boolean error) {
        int i = 0;
        while (i < units.length) {
            UnitData unit = units[i];
            if (unit.map_x == mx && unit.map_y == my && (side <= 0 || unit.side == side)) {
                return unit;
            }
            ++i;
        }
        if (error) {
            throw new RuntimeException("UnitData not found at " + mx + ", " + my);
        }
        return null;
    }

    public void damage(GameModule game, int amt, UnitData by_unit, int form_of_attack) {
        AbstractActivity act = Statics.act;
        if (form_of_attack == 5) {
            if (this.model_type == 3 || this.model_type == 7 || this.model_type == 14) {
                return;
            }
            SoundSelector.PlayCoughSound(act);
        }
        if (this.isAlive()) {
            int by_side = -1;
            int by_unitid = -1;
            String by_name = "fate";
            if (by_unit != null) {
                by_side = by_unit.side;
                by_unitid = by_unit.unitid;
                by_name = by_unit.name;
            }
            boolean[] who_can_see = game.whichSidesCanSeeUnit(this);
            boolean can_we_see = who_can_see[game.game_data.our_side];
            if (amt > 0) {
                this.incHealth(-amt);
                if (this.health > 0) {
                    if (can_we_see && form_of_attack != 6) {
                        game.root_node.attachChild(new ExpandingTextLabel(this.model, "" + amt));
                        game.root_node.updateGeometricState();
                    }
                    game.sendEventToServer_UnitWounded(this, by_side, by_unitid, form_of_attack, amt, who_can_see);
                    if (can_we_see) {
                        if (this.model_type == 3 || this.model_type == 7) {
                            act.playSound("alienhit1.wav");
                        } else if (this.model_type == 8) {
                            act.playSound("blobmove");
                        } else {
                            act.playSound("hit1.wav");
                        }
                    }
                } else {
                    byte by = this.side;
                    game.game_data.units_remaining[by] = (byte)(game.game_data.units_remaining[by] - 1);
                    if (can_we_see && form_of_attack != 6) {
                        game.root_node.attachChild(new ExpandingTextLabel(this.model, "DEAD"));
                        game.root_node.updateGeometricState();
                        new Ghost(game, this.model.getWorldCentreX(), this.model.getWorldCentreY(), Statics.SQ_SIZE);
                    }
                    if (this.status != 3 && this.status != 5) {
                        this.status = form_of_attack == 6 ? (byte)5 : (byte)3;
                        game.sendEventToServer_UnitKilled(this, by_side, by_unitid, form_of_attack, amt, who_can_see);
                        game.checkForDeathGrenadesOrAlienExplode(this);
                        game.unitKilled(this);
                        this.health = 0;
                        if (can_we_see) {
                            if (this.model_type == 3 || this.model_type == 7) {
                                act.playSound("aliendeath4");
                            } else {
                                act.playSound("deathscream1.wav");
                            }
                        }
                        this.model.removeFromParent();
                        this.model = null;
                        AbstractCorpse c = AbstractCorpse.CorpseFactory(game, this);
                        if (c != null) {
                            game.attachToRootNode(1, c, true);
                        }
                        if (this.model_type != 8) {
                            EquipmentData tmp = new EquipmentData();
                            tmp.seen_by_side[1] = 1;
                            tmp.seen_by_side[2] = 1;
                            tmp.seen_by_side[3] = 1;
                            tmp.seen_by_side[4] = 1;
                            tmp.model = c;
                            tmp.setName("Corpse");
                            tmp.major_type = (byte)((Integer)EquipmentTypesTable.CORPSES.get(0)).intValue();
                            game.mapdata.getSq_MaybeNULL(this.map_x, this.map_y).addEquipment(tmp);
                        }
                        game.recalcVisibleEnemiesAndOppFire(false, null);
                        game.updateMenu();
                    }
                }
                if (can_we_see) {
                    if (form_of_attack == 3) {
                        game.addToHUD(String.valueOf(this.name) + " " + act.getString("wounded") + " " + amt + " " + act.getString("by") + " " + act.getString("explosion"));
                    } else if (form_of_attack == 5) {
                        game.addToHUD(String.valueOf(this.name) + " " + act.getString("wounded") + " " + amt + " " + act.getString("by") + " " + act.getString("nerve_gas"));
                    } else if (form_of_attack == 7) {
                        game.addToHUD(String.valueOf(this.name) + " " + act.getString("wounded") + " " + amt + " " + act.getString("by") + " fire");
                    } else if (form_of_attack != 6) {
                        game.addToHUD(String.valueOf(this.name) + " " + act.getString("wounded") + " " + amt + " " + act.getString("by") + " " + by_name);
                    }
                }
                game.updateUnitOnServer(this);
                if (can_we_see && this.health <= 0) {
                    if (form_of_attack == 6) {
                        game.addToHUD(String.valueOf(this.name) + " " + act.getString("absorbed"));
                    } else {
                        game.addToHUD(String.valueOf(this.name) + " " + act.getString("killed"));
                    }
                }
            } else {
                if (can_we_see) {
                    if (form_of_attack == 3) {
                        game.addToHUD(String.valueOf(this.name) + " " + act.getString("not_harmed") + " " + act.getString("explosion"));
                    } else if (form_of_attack == 5) {
                        game.addToHUD(String.valueOf(this.name) + " " + act.getString("not_harmed") + " " + act.getString("nerve_gas"));
                    } else if (form_of_attack == 7) {
                        game.addToHUD(String.valueOf(this.name) + " " + act.getString("not_harmed") + " by fire");
                    } else {
                        game.addToHUD(String.valueOf(this.name) + " " + act.getString("not_harmed") + " " + by_name);
                    }
                }
                game.sendEventToServer_UnitWounded(this, by_side, by_unitid, form_of_attack, 0, who_can_see);
            }
        }
    }

    public void escaped(GameModule main) {
        main.unitEscaped(this);
        this.status = (byte)4;
        this.model.removeFromParent();
        this.model = null;
        main.updateUnitOnServer(this);
        boolean[] seen_by_side = main.whichSidesCanSeeUnit(this);
        main.sendEventToServer_UnitEscaped(this, seen_by_side);
    }

    public boolean isAlive() {
        return this.status != 3 && this.status != 5;
    }

    public void setTargetMapLocation(GameModule game, int _mapx, int _mapz, MapSquare sq) {
        AbstractActivity act = Statics.act;
        this.map_x = _mapx;
        this.map_y = _mapz;
        if (this.model != null) {
            if (this.status == 1) {
                this.updateModelFromUnitData();
            } else {
                game.addToProcess(this.model);
                this.model.anim_walk();
            }
        }
        if (sq != null && sq.door_type > 0 && !sq.door_open) {
            act.playSound("door");
            if (sq.door != null) {
                sq.door.startOpening();
                sq.door.opposite.startOpening();
            }
            sq.door_open = true;
            game.updateMapOnServer(sq, -1);
        }
    }

    public void turnBy(int a) {
        this.angle += a;
        this.setAngle(this.angle);
    }

    public void setAngle(int a) {
        this.angle = a;
        this.angle = GeometryFuncs.NormalizeAngle(this.angle);
        if (this.model != null) {
            this.updateModelFromUnitData();
        }
    }

    public int getMapX() {
        return this.map_x;
    }

    public int getMapY() {
        return this.map_y;
    }

    public int getAngle() {
        return this.angle;
    }

    public void updateModelFromUnitData() {
        this.model.setLocation((float)this.map_x * Statics.SQ_SIZE, (float)this.map_y * Statics.SQ_SIZE);
        this.updateAngleFromUnitData();
        this.model.updateGeometricState();
    }

    public void updateAngleFromUnitData() {
        this.model.current_bmp = this.model.bmps[this.angle / 45];
    }

    public int getHealth() {
        return this.health;
    }

    public int getMaxHealth() {
        return this.max_health;
    }

    public void setHealth(int h) {
        this.health = h;
        if (this.model instanceof Blob) {
            Blob blob = (Blob)this.model;
        }
    }

    public boolean checkAndReduceAPs(GameModule game, int amt) {
        AbstractActivity act = Statics.act;
        if (this.model_type == 14 && game.canAnyOtherSideSeeUnit(this)) {
            game.addToHUD("You can be seen, so you cannot move!");
            return false;
        }
        if (this.aps >= amt) {
            if (this == game.getCurrentUnit() && game.help_mode_on && this.aps >= this.opp_fire_aps_req && this.aps - amt < this.opp_fire_aps_req) {
                if (game.ap_lock) {
                    act.playSound("aps_out");
                    game.addToHUD("AP Lock On - Turn off to perform action!");
                    return false;
                }
                game.addToHUD(act.getString("no_longer_opp_fire"));
            }
            this.aps -= amt;
            this.checkForNerveGasAndFire(game, amt);
            game.hud.updateStatusBar();
            if (this.getHealth() > 0) {
                return true;
            }
            game.addToHUD("Unit has died.");
            return false;
        }
        if (this == game.getCurrentUnit()) {
            act.playSound("aps_out");
            game.addToHUD(String.valueOf(act.getString("not_enough_aps")) + " (" + amt + ")");
        }
        return false;
    }

    public void checkForNerveGasAndFire(GameModule game, int amt) {
        MapSquare sq = game.mapdata.getSq_MaybeNULL(this.getMapX(), this.getMapY());
        if (sq != null) {
            UnitData unit_causer = null;
            if (sq.smoke_caused_by > 0) {
                unit_causer = UnitData.GetUnitDataFromID(game.units, sq.smoke_caused_by);
            }
            if (sq.smoke_type == 22) {
                this.damage(game, (short)amt, unit_causer, 5);
            } else if (sq.smoke_type == 34) {
                short fire_amt;
                if (this.model_type != 14) {
                    this.on_fire = 1;
                }
                if ((fire_amt = (short)(amt / 2)) < 1) {
                    fire_amt = 1;
                }
                this.damage(game, fire_amt, unit_causer, 7);
            }
        }
        if (this.on_fire == 0) {
            if (this.model_type != 14) {
                int y = this.getMapY() - 1;
                while (y <= this.getMapY() + 1) {
                    int x = this.getMapX() - 1;
                    while (x <= this.getMapX() + 1) {
                        if ((x == this.getMapX() || y == this.getMapY()) && (sq = game.mapdata.getSq_MaybeNULL(x, y)) != null && sq.smoke_type == 34 && NumberFunctions.rnd(1, 2) == 1) {
                            this.on_fire = 1;
                            game.addToHUD("Unit has caught fire!");
                            break;
                        }
                        ++x;
                    }
                    ++y;
                }
            }
        } else {
            short fire_amt = (short)(amt / 2);
            if (fire_amt < 1) {
                fire_amt = 1;
            }
            this.damage(game, fire_amt, this, 7);
        }
    }

    public int getAPs() {
        return this.aps;
    }

    public void setAPs(int a) {
        this.aps = a;
    }

    public void incAPs(int a) {
        this.aps += a;
    }

    public void removeCurrentItem(GameModule main) {
        this.removeItem(main, this.current_item, true);
    }

    public void incHealth(int amt) {
        this.incHealth(amt, false);
    }

    public void incHealth(int amt, boolean override_max) {
        this.health += amt;
        if (this.health > this.max_health) {
            if (override_max) {
                this.max_health = this.health;
            } else {
                this.health = this.max_health;
            }
        }
    }

    public void setMaxHealth(int amt) {
        this.max_health = amt;
    }

    public void removeItem(GameModule main, EquipmentData eq, boolean update_server) {
        this.items.remove(eq);
        if (this.current_item == eq) {
            this.current_item = null;
            if (update_server) {
                main.updateUnitOnServer(this);
            }
        }
        eq.removeFromUnit();
    }

    public int getBlobExplodeDamage() {
        return this.strength * 2;
    }

    public int getBlobExplodeRad() {
        return this.strength / 10;
    }

    public boolean processAI(GameModule game) {
        return this.ai.process(game);
    }

    public boolean hasAI() {
        return this.ai != null;
    }

    public void setAIType(int type) {
        if (type > 0) {
            switch (type) {
                case 1: {
                    this.ai = new SimpleRotateAI(this);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown AI type: " + type);
                }
            }
        }
    }

    public float getDistanceTo(UnitData other) {
        return (float)GeometryFuncs.distance(this.map_x, this.map_y, other.map_x, other.map_y);
    }
}

