/*
 * Decompiled with CFR 0.152.
 */
package ssmith.android.framework;

import com.scs.stellarforces.MainThread;
import com.scs.stellarforces.PortLock;
import com.scs.stellarforces.Statics;
import com.scs.stellarforces.XMLHelper;
import javax.swing.JOptionPane;
import ssmith.audio.MP3Player;
import ssmith.audio.SoundCacheThread;

public abstract class AbstractActivity {
    public static final int RESULT_OK = 1;
    public MainThread thread;
    private MP3Player mp3Music;
    private SoundCacheThread sfx;
    private XMLHelper xml;

    public void onCreate() {
        Statics.init(this);
        if (!PortLock.IsFirstInstance()) {
            JOptionPane.showMessageDialog(null, "There seems to be an instance of this program already running.  Multiple copies cannot be run concurrently.", "Already Running", 1);
            return;
        }
        this.sfx = new SoundCacheThread("sfx/");
        this.sfx.start();
        this.xml = new XMLHelper();
        this.mp3Music = new MP3Player("sfx/laser_squad_mission_recalled_oc_remix.mp3", true);
        if (Statics.MUTE_MUSIC == 1) {
            this.mp3Music.paused = true;
        }
        this.mp3Music.start();
        this.thread = new MainThread();
        this.thread.start();
    }

    public static void HandleError(Throwable ex) {
        ex.printStackTrace();
    }

    public void playSound(String id) {
        if (!id.contains(".")) {
            id = String.valueOf(id) + ".mp3";
        }
        this.sfx.playSound(id);
    }

    public void pauseMusic() {
        this.mp3Music.paused = true;
    }

    public void resumeMusic() {
        if (Statics.MUTE_MUSIC == 0) {
            this.mp3Music.paused = false;
        }
    }

    public static void Log(String s) {
        System.out.println(s);
    }

    public String getString(String id) {
        return this.xml.getString(id);
    }

    public String getString(String id, String s) {
        String newstr = this.xml.getString(id);
        newstr = newstr.replaceAll("%", s);
        return newstr;
    }
}

