/*
 * Decompiled with CFR 0.152.
 */
package ssmith.android.framework.modules;

import com.scs.stellarforces.MainThread;
import com.scs.stellarforces.Statics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import ssmith.android.compatibility.Canvas;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.MyEvent;
import ssmith.android.framework.modules.PleaseWaitDialog;
import ssmith.android.lib2d.Camera;
import ssmith.android.lib2d.Node;
import ssmith.android.lib2d.gui.AbstractComponent;
import ssmith.android.lib2d.gui.AbstractTextComponent;
import ssmith.android.lib2d.shapes.Geometry;
import ssmith.lang.Functions;

public abstract class AbstractModule
extends Thread {
    public Camera root_cam;
    public Node root_node = new Node("root_node");
    public Node stat_node = new Node("stat_node");
    protected Camera stat_cam;
    private BufferedImage background;
    protected int i_return_to;
    public AbstractModule mod_return_to;
    private PleaseWaitDialog please_wait_dialog;
    public static String debug_text = "";
    private static Paint paint_small_text = new Paint();
    public static AbstractTextComponent inputComponent;

    static {
        paint_small_text.setARGB(255, 255, 255, 255);
        paint_small_text.setAntiAlias(true);
    }

    public AbstractModule(int _return_to) {
        super("AbstractModule_Thread");
        this.i_return_to = _return_to;
        this.root_cam = new Camera();
        this.root_cam.lookAt(Statics.SCREEN_WIDTH / 2, Statics.SCREEN_HEIGHT / 2, true);
        this.stat_cam = new Camera();
        this.stat_cam.lookAt(Statics.SCREEN_WIDTH / 2, Statics.SCREEN_HEIGHT / 2, true);
    }

    public MainThread getMainThread() {
        return Statics.act.thread;
    }

    public abstract boolean processEvent(MyEvent var1) throws Exception;

    public void started() {
    }

    public void stopped() {
    }

    public void setBackground(String key) {
        this.background = Statics.img_cache.getImage(key, Statics.SCREEN_WIDTH, Statics.SCREEN_HEIGHT);
    }

    public void doDraw(Canvas c, long interpol) {
        if (this.background != null) {
            c.drawImage(this.background, 0.0f, 0.0f, null);
        }
        this.root_cam.update(interpol);
        this.root_node.doDraw(c, this.root_cam, interpol);
        this.stat_cam.update(interpol);
        this.stat_node.doDraw(c, this.stat_cam, interpol);
    }

    public abstract void updateGame(long var1);

    public AbstractComponent GetComponentAt(Node node, float x, float y) {
        ArrayList<Geometry> colls = node.getCollidersAt(x, y);
        if (colls.size() > 0) {
            for (Geometry g : colls) {
                if (!(g instanceof AbstractComponent)) continue;
                AbstractComponent b = (AbstractComponent)g;
                return b;
            }
        }
        return null;
    }

    public boolean onKeyDown(int keyCode, KeyEvent msg) {
        if (inputComponent != null) {
            Statics.act.playSound("type");
            if (msg.getKeyCode() == 127 || msg.getKeyCode() == 8) {
                if (inputComponent.getText().length() > 0) {
                    inputComponent.setText(inputComponent.getText().substring(0, inputComponent.getText().length() - 1));
                }
            } else if (msg.getKeyCode() >= 32) {
                inputComponent.append("" + msg.getKeyChar());
            }
        }
        return false;
    }

    public boolean onKeyUp(int keyCode, KeyEvent msg) {
        return false;
    }

    public boolean onBackPressed() {
        Statics.act.playSound("type2");
        return this.returnTo();
    }

    protected boolean returnTo() {
        if (this.mod_return_to != null) {
            this.getMainThread().setNextModule(this.mod_return_to);
            return true;
        }
        if (this.i_return_to >= 0) {
            AbstractModule m = Statics.GetModule(this.i_return_to);
            this.getMainThread().setNextModule(m);
            return true;
        }
        return false;
    }

    public void showPleaseWait(String msg) {
        this.dismissPleaseWait();
        if (this.please_wait_dialog == null) {
            this.please_wait_dialog = new PleaseWaitDialog(msg, Statics.bigfnt);
            this.stat_node.attachChild(this.please_wait_dialog);
            this.stat_node.updateGeometricState();
            this.getMainThread().doDrawing();
        }
    }

    public void dismissPleaseWait() {
        if (this.please_wait_dialog != null) {
            this.please_wait_dialog.removeFromParent();
            this.please_wait_dialog = null;
            this.stat_node.updateGeometricState();
            this.getMainThread().doDrawing();
        }
    }

    public void showToast(String s) {
        this.showPleaseWait(s);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Functions.delay(2000);
                AbstractModule.this.dismissPleaseWait();
            }
        };
        Thread t = new Thread(r);
        t.setName("ShowToastThread");
        t.start();
    }

    public void onActivityResult(int requestCode, int resultCode) {
    }

    public boolean playMusic() {
        return true;
    }

    public void mouseWheelMoved(MouseWheelEvent mwe) {
    }
}

