/*
 * Decompiled with CFR 0.152.
 */
package ssmith.android.lib2d.gui;

import com.scs.stellarforces.Statics;
import java.awt.image.BufferedImage;
import ssmith.android.compatibility.Canvas;
import ssmith.android.compatibility.Paint;
import ssmith.android.framework.modules.AbstractModule;
import ssmith.android.lib2d.Camera;
import ssmith.android.lib2d.gui.AbstractComponent;

public abstract class AbstractTextComponent
extends AbstractComponent {
    private int max_length;
    protected StringBuffer str;
    protected Paint ink;
    protected float[] x_offset;
    protected float y_offset;
    private boolean centre;
    protected String[] lines;

    public AbstractTextComponent(String name, String cmd, String _text, float x, float y, float w, float h, Paint paint, Paint _ink, BufferedImage bmp, boolean _centre) {
        this(name, cmd, _text, x, y, w, h, paint, _ink, -1, bmp, _centre);
    }

    public AbstractTextComponent(String name, String cmd, String _text, float x, float y, float w, float h, Paint paint, Paint _ink, int maxlen, BufferedImage bmp, boolean _centre) {
        super(name, cmd, x, y, w, h, paint, bmp);
        this.ink = _ink;
        this.str = new StringBuffer(_text);
        this.max_length = maxlen;
        this.centre = _centre;
        if (this.ink == null && _text.length() > 0) {
            throw new RuntimeException("Null ink for Button " + name);
        }
        this.checkText();
    }

    public void setInkRGB(int r, int g, int b) {
        this.ink.setARGB(this.ink.getAlpha(), r, g, b);
    }

    public void calcTextOffset() {
        if (this.ink != null) {
            String longest = "";
            if (this.lines != null) {
                int i = 0;
                while (i < this.lines.length) {
                    if (this.lines[i].length() > longest.length()) {
                        longest = this.lines[i];
                    }
                    float len = this.ink.measureText(this.lines[i]);
                    this.x_offset[i] = this.centre && this.lines[i].length() > 0 ? (this.getWidth() - len) / 2.0f : (len >= (float)Statics.SCREEN_WIDTH ? (float)Statics.SCREEN_WIDTH - len : 10.0f);
                    if (this.x_offset[i] < 10.0f) {
                        this.x_offset[i] = 10.0f;
                    }
                    ++i;
                }
                this.y_offset = this.getHeight() / (float)(this.lines.length + 1) + this.ink.getTextSize() * 0.35f;
            }
        }
    }

    @Override
    public void setSize(float w, float h) {
        super.setSize(w, h);
        this.calcTextOffset();
    }

    @Override
    public void doDraw(Canvas g, Camera cam, long interpol) {
        super.doDraw(g, cam, interpol);
        this.drawText(g, cam);
    }

    protected void drawText(Canvas g, Camera cam) {
        if (this.visible) {
            boolean drawCaret;
            boolean bl = drawCaret = this == AbstractModule.inputComponent;
            if (this.str.length() > 0) {
                float tmp_offset = this.y_offset;
                String caret = "";
                int i = 0;
                while (i < this.lines.length) {
                    if (drawCaret && i == this.lines.length - 1) {
                        caret = "_";
                    }
                    g.drawText(String.valueOf(this.lines[i]) + caret, super.getScreenX(cam) + this.x_offset[i], super.getScreenY(cam) + tmp_offset, this.ink);
                    tmp_offset += this.ink.getTextSize() * 1.2f;
                    ++i;
                }
            } else if (drawCaret) {
                g.drawText("_", super.getScreenX(cam) + 10.0f, super.getScreenY(cam) + this.y_offset, this.ink);
            }
        }
    }

    public void appendText(String s) {
        this.str.append(s);
        this.checkText();
    }

    public void append(String s) {
        this.appendText(s);
    }

    public void setText(int i) {
        this.setText("" + i);
    }

    public void setText(String s) {
        this.str = new StringBuffer(s);
        this.checkText();
    }

    public void setActionCommand(String s) {
        this.action_command = s;
    }

    protected void checkText() {
        if (this.max_length >= 0 && this.str.length() > this.max_length) {
            this.str.delete(this.max_length, this.str.length());
        }
        this.lines = this.str.toString().split("\n");
        this.x_offset = new float[this.lines.length];
        this.calcTextOffset();
    }

    public String getText() {
        return this.str.toString();
    }

    public void updateWidth() {
        this.local_rect.right = this.local_rect.left + this.ink.measureText(String.valueOf(this.str.toString()) + " ");
        this.updateGeometricState();
    }
}

