/*
 * Decompiled with CFR 0.152.
 */
package ssmith.android.lib2d.gui;

import java.util.ArrayList;
import ssmith.android.compatibility.Paint;
import ssmith.android.lib2d.Node;
import ssmith.android.lib2d.gui.Label;

public class MultiLineLabel
extends Node {
    private Paint paint;
    private Paint ink;
    private boolean word_wrap;
    private float wrap_width;
    protected StringBuffer str;

    public MultiLineLabel(String name, String text, Paint _paint, Paint _ink, boolean _word_wrap, float _wrap_width) {
        super(name);
        this.paint = _paint;
        this.ink = _ink;
        this.word_wrap = _word_wrap;
        this.wrap_width = _wrap_width;
        this.str = new StringBuffer(text);
        this.showText();
    }

    protected void showText() {
        this.detachAllChildren();
        String text = this.str.toString().trim();
        if (this.word_wrap) {
            ArrayList<String> al_lines = new ArrayList<String>();
            while (true) {
                int space_pos;
                int chars_to_show = this.ink.breakText(text, this.wrap_width);
                int cr_pos = text.indexOf("\n");
                if (cr_pos >= 0 && cr_pos < chars_to_show) {
                    chars_to_show = cr_pos;
                }
                if (chars_to_show >= text.length()) {
                    if (text.length() <= 0) break;
                    al_lines.add(text.substring(0, text.length()));
                    break;
                }
                if (!text.substring(chars_to_show, chars_to_show + 1).equalsIgnoreCase("\n") && (space_pos = text.substring(0, chars_to_show).lastIndexOf(" ")) >= 0) {
                    chars_to_show = space_pos;
                }
                al_lines.add(text.substring(0, chars_to_show));
                text = text.substring(chars_to_show + 1).trim();
            }
            this.showLines(al_lines);
        } else {
            String[] lines = text.split("\\n");
            ArrayList<String> al_lines = new ArrayList<String>();
            int i = 0;
            while (i < lines.length) {
                al_lines.add(lines[i]);
                ++i;
            }
            this.showLines(al_lines);
        }
    }

    private void showLines(ArrayList<String> lines) {
        this.removeAllChildren();
        int y = 0;
        for (String s : lines) {
            Label l = new Label(String.valueOf(this.name) + "_sublabel", s, 0.0f, (float)y, this.wrap_width, this.paint, this.ink, false);
            this.attachChild(l);
            l.updateGeometricState();
            y = (int)((float)y + this.ink.getTextSize() * 1.2f);
        }
        this.updateGeometricState();
    }

    public void appendText(String s) {
        this.str.append(s);
        this.showText();
    }

    public void setText(String s) {
        this.str = new StringBuffer(s);
        this.showText();
    }

    public String getText() {
        return this.str.toString();
    }

    public void delete(int start, int end) {
        this.str.delete(start, end);
        this.showText();
    }
}

