/*
 * Decompiled with CFR 0.152.
 */
package ssmith.android.lib2d.layouts;

import com.scs.stellarforces.Statics;
import java.util.ArrayList;
import ssmith.android.compatibility.Canvas;
import ssmith.android.compatibility.Paint;
import ssmith.android.compatibility.RectF;
import ssmith.android.framework.AbstractActivity;
import ssmith.android.lib2d.Camera;
import ssmith.android.lib2d.Node;
import ssmith.android.lib2d.shapes.AbstractRectangle;
import ssmith.android.lib2d.shapes.Geometry;

public class EfficientGridLayout
extends Node {
    private static Paint default_paint = new Paint();
    protected AbstractRectangle[][] blocks;
    private float tile_size;
    private int draw_width;
    private int draw_height;
    private int blocks_width;
    private int blocks_height;

    static {
        default_paint.setARGB(255, 255, 255, 255);
    }

    public EfficientGridLayout(int w, int h, float _tile_size) {
        super("EfficientGridLayout");
        this.blocks_width = w;
        this.blocks_height = h;
        this.blocks = new AbstractRectangle[w][h];
        this.tile_size = _tile_size;
        this.local_bounds = new RectF(0.0f, 0.0f, (float)this.blocks_width * this.tile_size, (float)this.blocks_height * this.tile_size);
    }

    public void setRectAtMap(AbstractRectangle b, int x, int y) {
        this.blocks[x][y] = b;
        if (b != null) {
            b.setByLTRB((float)x * this.tile_size, (float)y * this.tile_size, (float)(x + 1) * this.tile_size - 1.0f, (float)(y + 1) * this.tile_size - 1.0f);
            b.updateGeometricState();
        }
    }

    public void removeRectAtMap(int x, int y) {
        this.blocks[x][y] = null;
    }

    public AbstractRectangle getRectAtPixel(float x, float y) {
        int x2 = (int)(x / Statics.SQ_SIZE);
        int y2 = (int)(y / Statics.SQ_SIZE);
        if (x2 >= 0 && y2 >= 0 && x2 < this.blocks.length && y2 < this.blocks[0].length) {
            return this.blocks[x2][y2];
        }
        return null;
    }

    public AbstractRectangle getBlockAtMap_MaybeNull(int x, int y) {
        try {
            return this.blocks[x][y];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    protected void getCollidersAt(float x, float y, ArrayList<Geometry> list_of_colliders) {
        ArrayList<Geometry> colls = this.getCollidersAt(x, y);
        list_of_colliders.addAll(colls);
    }

    @Override
    public ArrayList<Geometry> getCollidersAt(float x, float y) {
        return this.getColliders(new RectF(x, y, x + 1.0f, y + 1.0f));
    }

    public ArrayList<Geometry> getColliders(RectF rect) {
        int s_y;
        ArrayList<Geometry> colls = new ArrayList<Geometry>();
        this.draw_width = (int)((rect.right - rect.left) / this.tile_size);
        this.draw_height = (int)((rect.bottom - rect.top) / this.tile_size);
        int s_x = (int)(rect.left / this.tile_size);
        int y = s_y = (int)(rect.top / this.tile_size);
        while (y <= s_y + this.draw_height + 1) {
            if (y < this.blocks[0].length) {
                int x = s_x;
                while (x <= s_x + this.draw_width + 1) {
                    AbstractRectangle block;
                    if (x >= 0 && y >= 0 && x < this.blocks.length && this.blocks[x][y] != null && RectF.intersects(rect, (block = this.blocks[x][y]).getWorldBounds())) {
                        colls.add(block);
                    }
                    ++x;
                }
            }
            ++y;
        }
        return colls;
    }

    @Override
    public void doDraw(Canvas g, Camera cam, long interpol) {
        int s_y;
        this.draw_width = (int)((cam.right - cam.left) / this.tile_size);
        this.draw_height = (int)((cam.bottom - cam.top) / this.tile_size);
        int s_x = (int)(cam.left / this.tile_size);
        int y = s_y = (int)(cam.top / this.tile_size);
        while (y <= s_y + this.draw_height + 1) {
            if (y >= 0 && y < this.blocks[0].length) {
                int x = s_x;
                while (x <= s_x + this.draw_width + 1) {
                    if (x >= 0 && x < this.blocks.length) {
                        try {
                            if (this.blocks[x][y] != null) {
                                AbstractRectangle block = this.blocks[x][y];
                                block.doDraw(g, cam, interpol);
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            AbstractActivity.HandleError(ex);
                        }
                    }
                    ++x;
                }
            }
            ++y;
        }
    }

    public int getBlocksWidth() {
        return this.blocks_width;
    }

    public int getBlocksHeight() {
        return this.blocks_height;
    }

    @Override
    public void updateGeometricState() {
        this.world_bounds.left = this.local_bounds.left + this.parent_world_coords.x;
        this.world_bounds.top = this.local_bounds.top + this.parent_world_coords.y;
        this.world_bounds.right = this.local_bounds.right + this.parent_world_coords.x;
        this.world_bounds.bottom = this.local_bounds.bottom + this.parent_world_coords.y;
        this.needs_updating = false;
    }
}

