#ifndef lib_fmod
#define lib_fmod

void InitialiseSound();
void RemoveSound();

//stuff to play from file without loading into memory, i.e. one of tunes, etc.
FSOUND_STREAM* PlaySampleFromStream(const char* filename, int& channel,int volume=-1, long length=0, long additionalmode=0);
void StopStream(FSOUND_STREAM* fs);
void AdjustMusicVolume(FMUSIC_MODULE *music,int volume);

//tracker stuff
FMUSIC_MODULE* PlayTrackerSongFromDAT(const char* data, int volume, int length, bool loop, int startpoint);
FMUSIC_MODULE* PlayTrackerSongFromFile(const char* filename, int volume, bool loop, int startpoint);
void StopTrackerSong();

//sound
void PlayExclusiveSFX(FSOUND_SAMPLE *snd);
void LoadSamples();
FSOUND_SAMPLE* LoadSample(int item);

void StopSFX(int channel);
int PlaySFX(FSOUND_SAMPLE *snd,int loop=FSOUND_LOOP_OFF,bool forceRestart=false,bool onlyifnotplaying=true,int channel=-1);
void AdjustFrequencySFX(int channel,int rate);
void AdjustVolumeSFX(int channel,int volume);


#endif

