//Tranz-Am
#include "game_transam.h"

static bool initialised=false;
static texture_struct demo_texture;

//funky font
static std::string filename;
static font_struct FunkyFont;
static prop_text_struct FunkyText;
static BITMAP* temp=NULL;
static std::string highScoreList="";
static BITMAP* checker=NULL;
static int channel=-1;
//static FSOUND_STREAM* hsstream=NULL;

//high score structure with name and score
static struct Scores
{
	int score;
	std::string name;
	Scores(const std::string& hsname,int hsscore)
	{
	    name=hsname;
	    score=hsscore;
	}
	Scores(){score=0; name="";};

} HighScoreList;
//operator so that sorting works
bool operator<(const Scores& x, const Scores& y)
{
	return x.score<y.score;
}
//vector of arrays
static std::vector<Scores> highScores;

bool HighScoreLogic()
{
	static double cycle=0.0;
	static float loopcount=0.0;

	if(!initialised)
	{
		channel=-1;
		cycle=0.0;
		HighScoreInitialise();
		initialised=true;
		//hsstream=PlaySampleFromStream((const char*)(GameDAT[MUSIC_MP3_HS].dat),channel,0,GameDAT[MUSIC_MP3_HS].size,FSOUND_LOADMEMORY | FSOUND_LOOP_NORMAL);
		loopcount=0;
	}

	/*if(initialised && hsstream && channel>=0 && loopcount<=GameConfiguration->CapsSound.MusicVolume)
	{
		loopcount+=0.4;
		FSOUND_SetVolume(channel,loopcount);
	}*/

	//wait three seconds before allow exit. just to stop keypresses from interfering
	if(key[KEY_ESC] || key[KEY_D] || (cycle>3.0 && (keypressed() || GameFramework->JoypadAnythingPressed())))
	{
		if(keypressed() && (readkey() >> 8)==KEY_D)
		{
			std::string error;
			std::vector<HighScoreEntry> scores=GetHighScores("tranzam",10,-1,0,0,0,error,GameConfiguration->GetCustom("rootsite","http://retrospec.sgn.net"),GameConfiguration->GetCustom("proxy",""));
			blit(GameFramework->DrawingSurface,MemoryBuffer,0,0,0,0,MemoryBuffer->w,MemoryBuffer->h);
			if(error!="")
			{
				std::ostringstream ss;
				ss << "The following error occurred downloading from website:%nothing[]"<<error<<"%nothing[]%buttonrow[OK]";
				adime_lowlevel_dialogf(
					"Failed to download",
					ADIME_ALIGN_CENTRE,ADIME_ALIGN_CENTRE,300,
					ss.str().c_str(),
					tranzam_adime_callback_close
					);
			}
			else if(scores.size()==0)
			{
				adime_lowlevel_dialogf(
					"No Scores",
					ADIME_ALIGN_CENTRE,ADIME_ALIGN_CENTRE,300,
					"There are no scores at the website%nothing[]%buttonrow[OK]",
					tranzam_adime_callback_close
					);
			}
			else
			{
				highScores.clear();
				for(unsigned int i=0;i<scores.size();i++)
					AddHighScore(scores[i].score1,scores[i].name,false);

				if(scores.size()<9)
					for(unsigned int i=scores.size();i<10;i++)
						AddHighScore(9*60*60+(59*60),"Retrospec",false);

				initialised=false;
			}
		}
		else
		{
			HighScoreDestroy();
			GameFramework->SetAutoGameLoop(
						TransAmMenuLogic,TransAmMenuDrawing
						);
		}
		return false;
	}
	else
		clear_keybuf();

	PFONT_posset_reset ( &FunkyText );
	PFONT_texset_basic_spread ( &FunkyText , 1 , 1 , (float)cycle*16 , (float)cycle*16 , true );

	//slide in out
	PFONT_posmod_scale ( &FunkyText , 0.5 , 0.5 , 1.1+(sin (cycle)/10) , 1+(cos (cycle)/10) );

	PFONT_texmod_selection ( &FunkyText, 0.5 + ( (float)(sin (cycle/2)) / 2) ,  0.5 + ( (float)(cos (cycle/2)) / 2) , (int)( float(cos (cycle/6)) * 192.0f) , 0 , 128 , 1 , 0 );

	//move round a little
	//PFONT_posmod_add_noise ( &FunkyText , 0 , 40 );
	PFONT_posmod_inverse_damp_point ( &FunkyText , (int (cycle*15) % 1000)-15 , 150 , 1 );
	PFONT_posmod_bow_in ( &FunkyText , 0.5 , 0.5 , cos (cycle/2) * 16.0 , sin (cycle) * 16.0 );
	//sine wave
	//PFONT_posmod_sine_out_phase ( &FunkyText , 0.02 , 0.02 , -20 , -20 , cycle , cycle );
	//PFONT_posmod_damp_point ( &FunkyText , (int (cycle*2) % 1500)-300 , 300 , 0 );
	cycle+=0.02;
	return false;
}

bool HighScoreDrawing()
{

	//clear_to_color(GameFramework->DrawingSurface,makecol(229,227,92));
	blit(checker,GameFramework->DrawingSurface,0,0,0,0,checker->w,checker->h);

	//text
	int starty=32;
	int height_mf=10;;
	int startx=SCREEN_W/2;
	if(SCREEN_H>480)
		starty=64;

	textout_centre_ex(GameFramework->DrawingSurface,LargeFont2,"High Scores",startx,starty,-1,-1);

	PFONT_draw_frame_list_texture(&FunkyText ,
		1000 , startx,
		starty+76+(2*height_mf)-15, 0.5 , 0.0 , GameFramework->DrawingSurface,&demo_texture );

	textout_centre_ex(GameFramework->DrawingSurface,SmallFont,"Press D to download new scores from Internet",startx,SCREEN_H-32,-1,-1);

		return false;
}

void HighScoreInitialise()
{
	HighScoreDestroy();
	highScoreList="";
	InitialiseHighScores();
	temp=create_bitmap(SCREEN_W,SCREEN_H);
	checker=GenerateChecker();

	std::string currentName;
	int currentScore;
	std::ostringstream ss;
	unsigned int index;
	for(int i=0;i<10;i++)
	{
		currentName=highScores[i].name;
		currentScore=highScores[i].score;
		//ensure not too long
		if(currentName.length()>15)
			currentName=currentName.substr(0,15);
		//remove | symbol as that is used for carriage returns
		index=currentName.find("|");
		if(index!=std::string::npos)
			currentName.replace(index,1,"-");

		ss.str("");

		ss << std::left << std::setw(18) << currentName << std::right << std::setw(26) << TimeFromSeconds(currentScore);
		if(i<9)
			ss << "|";
		highScoreList+=ss.str();
	}

	/*sprintf(filechar,"%s","gfx\\font_messages_funky.bmp");
	filename=fix_filename_slashes( filechar );
	if(!exists(filename.c_str()))
		GameFramework->AbortSystem("Cannot find "+filename);
	PFONT_load_font (&FunkyFont, filename.c_str(), 16,32);*/
	PFONT_load_font_from_bitmap(&FunkyFont, (BITMAP*)GameDAT[FONTFUNKYMESSAGE].dat, 16, 32);

	/*sprintf(filechar,"%s","gfx\\font_texture.bmp");
	filename=fix_filename_slashes( filechar );
	if(!exists(filename.c_str()))
		GameFramework->AbortSystem("Cannot find "+filename);
	PFONT_load_texture (&demo_texture , filename.c_str() , 16 , 16 );*/
	PFONT_load_texture_from_bitmap(&demo_texture , (BITMAP*)GameDAT[FONTFUNKYTEXTURE].dat , 16 , 16 );

	//highScoreList="neil walker";
	PFONT_create_frame_list (&FunkyText , &FunkyFont ,
		highScoreList.c_str(),
		640, PFONT_ALIGN_CENTER , 1, -6 , false, false );

}

void InitialiseHighScores(bool configread)
{
	//read high-scores - always have 10
	if(configread)
	{
		//empty high-score - done via stack/copy so no need for pointer work
		highScores.clear();
		highScores.push_back(Scores(GameConfiguration->GetCustom("highscore1person","Neil"),GameConfiguration->GetCustom("highscore1score",1001)));
		highScores.push_back(Scores(GameConfiguration->GetCustom("highscore2person","Andy"),GameConfiguration->GetCustom("highscore2score",1102)));
		highScores.push_back(Scores(GameConfiguration->GetCustom("highscore3person","Graham"),GameConfiguration->GetCustom("highscore3score",1203)));
		highScores.push_back(Scores(GameConfiguration->GetCustom("highscore4person","Ignacio"),GameConfiguration->GetCustom("highscore4score",1304)));
		highScores.push_back(Scores(GameConfiguration->GetCustom("highscore5person","Pierre"),GameConfiguration->GetCustom("highscore5score",1405)));
		highScores.push_back(Scores(GameConfiguration->GetCustom("highscore6person","Rich"),GameConfiguration->GetCustom("highscore6score",1506)));
		highScores.push_back(Scores(GameConfiguration->GetCustom("highscore7person","Pete"),GameConfiguration->GetCustom("highscore7score",1607)));
		highScores.push_back(Scores(GameConfiguration->GetCustom("highscore8person","Matt"),GameConfiguration->GetCustom("highscore8score",1708)));
		highScores.push_back(Scores(GameConfiguration->GetCustom("highscore9person","Dan"),GameConfiguration->GetCustom("highscore9score",1809)));
		highScores.push_back(Scores(GameConfiguration->GetCustom("highscore10person","Jeff"),GameConfiguration->GetCustom("highscore10score",1910)));

		//sort list
		std::sort(highScores.begin(),highScores.end());
	}
}

void HighScoreDestroy()
{
	initialised=false;
    //StopStream(hsstream);
	if(checker) destroy_bitmap(checker);
	if(temp) destroy_bitmap(temp);
	temp=checker=NULL;

	PFONT_free_font (&FunkyFont);
	PFONT_free_texture (&demo_texture);
}


//called by end game (main game) to check/add name to list
int AddHighScore(int score,const std::string& name,bool reread)
{
	//basically there are 10 high-scores so add this entry to the list
	//sort it and write back the first 10
	//if the score is in the 10 then it's position is returned, otherwise -1 will show caller it didn't make it

	InitialiseHighScores(reread);	//table is cleared
	highScores.push_back(Scores(name,score));
	std::sort(highScores.begin(),highScores.end());
	std::vector<Scores>::iterator i;

	std::ostringstream ss;
	int found=-1;
	for(unsigned int i=0;i<highScores.size();i++)
	{
		if(highScores[i].score==score && highScores[i].name==name)
			found=(int)i;

		//update custom area ready for saving
		//dont update if no name set - this is done by game over check
		if(name!="")
		{
			ss.str("");
			ss << "highscore" << i+1 << "person";
			GameConfiguration->SetCustom(ss.str(),highScores[i].name);
			ss.str("");
			ss << "highscore" << i+1 << "score";
			GameConfiguration->SetCustom(ss.str(),highScores[i].score);
			GameConfiguration->FlushCustom();
		}
	}

	//if in range then return the position
	if(found>=0 && found<10)
		return found+1;
	else
		return 0;

}

