#ifndef tranzam_levels
#define tranzam_levels

struct Level
{
	int id;				//unique game id
	long highScore;
	long currentTime;
	long currentMiles;
	int endState;		//1 win, 2 draw, 3 lost (0 in game)
	GameType gameMode;
	std::string name;
	std::string filename;
	int positionX;			//0 for middle, -1 for random, anything else for that position
	int positionY;			//as above
	int enemies;
	int countdown;			//if non-zero then game is timed and player has to finish before the end
	float enemyvel;			//multiplier factor
	int flag;	//used for any purpose. used by quiz to determine quiz type 1 or 2
				// main game 0 for easy, 1 for normal, 2 for hard
	Level();
};

class Levels
{
public:
	static void NewMapsCheck();
	Levels(void);
	~Levels(void);
	Level* GetLevel(const unsigned int item);
	Level* GetLevel(const unsigned int item,GameType gt);
	int Count();
	int Count(GameType gt);
	void Add(Level* l);
	void SetHighScore(Level* level);
private:
	bool ReadLevels();
	std::vector<Level*> levels;
};

#endif
