#include "stringtokeniser.h"
#include "retrospec_highscore.h"
//#define RETRO_DEBUG_HS

struct MemoryStruct
{
	char *memory;
	size_t size;
	MemoryStruct() { size=0;memory=NULL;}
};

static void *myrealloc(void *ptr, size_t size)
{
	if(ptr)
		return realloc(ptr, size);
	else
		return malloc(size);
}

static size_t WriteMemoryCallback(void *ptr, size_t size, size_t nmemb, void *data)
{
	size_t realsize = size * nmemb;
	struct MemoryStruct *mem = (struct MemoryStruct *)data;

	mem->memory = (char *)myrealloc(mem->memory, mem->size + realsize + 1);
	if (mem->memory)
	{
		memcpy(&(mem->memory[mem->size]), ptr, realsize);
		mem->size += realsize;
		mem->memory[mem->size] = 0;
	}
	return realsize;
}

std::string GetURLData(const std::string& url, const std::string& proxy,std::string& errorcode)
{
	//url is url, e.g. 'http://www.bob.com/file.txt'
	//proxy is proxy/port if used, e.g. 'proxy:8080', leave blank for none
	//code is return value:
	//		0 ok
	//		5 bad proxy
	//		6 url not found
	//		7 couldn't connect
	//		28 timed out (busy)
	//		any other non-zero is some other error

	std::string returnval;

	MemoryStruct chunk;
	chunk.size=0;
	chunk.memory=NULL;
	CURL* curl;
	CURLcode res;
	curl_global_init(CURL_GLOBAL_ALL);
	curl=curl_easy_init();
	if(curl)
	{
		curl_easy_setopt(curl,CURLOPT_URL,url.c_str());
		curl_easy_setopt(curl,CURLOPT_NOPROGRESS,1);
		curl_easy_setopt(curl,CURLOPT_CONNECTTIMEOUT,15);
		curl_easy_setopt(curl,CURLOPT_TIMEOUT,10);
		curl_easy_setopt(curl,CURLOPT_PROXY,proxy.c_str());
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteMemoryCallback);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, (void *)&chunk);
 		res=curl_easy_perform(curl);

		returnval="";
		errorcode="";
		if(res)
			errorcode=curl_easy_strerror(res);

		if(chunk.memory)
		{
			returnval=(std::string)chunk.memory;
			free(chunk.memory);
			chunk.size=0;
			chunk.memory=NULL;
		}
	}

	curl_easy_cleanup(curl);
	curl_global_cleanup();
	return returnval;
}

static std::string GetSort(const std::string& stringv, int sort)
{
	if(sort==0) return stringv+"=0";
	if(sort==1) return stringv+"=1";
	if(sort==2) return stringv+"=-1";

	return "";
}

std::vector<HighScoreEntry> GetHighScores(const std::string& gameid,int numentries,int sortScore1, int sortScore2, int sortScore3, int sortScore4,std::string& errorcode,const std::string& baseurl,const std::string& proxy)
{
	//gameid is id of game, e.g. 'jj'
	//numentries is number of rows to return
	//errorstring is string passed in and is populated on return if there was an error
	//baseurl is the url to use in case the website changes (leave out last /), e.g. 'http://retrospec.sgn.net'
	//proxy is in case going behind a proxy server (e.g. 'myproxy:8080' would be proxy called myproxy on port 8080)
	//sortScorex is whether to sort the highscore. 0 is no sort, 1 is ascending, 2 is descending
	//
	// returns a vector of highscore structs
	std::string error;
	std::string codes;
	std::vector<HighScoreEntry> scores;
	std::vector<std::string> temp;
	std::ostringstream ss;
	ss << numentries;
	std::string sorting="";

	sorting =GetSort("score1",sortScore1)+"&";
	sorting+=GetSort("score2",sortScore2)+"&";
	sorting+=GetSort("score3",sortScore3)+"&";
	sorting+=GetSort("score4",sortScore4);

#ifndef RETRO_DEBUG_HS
	std::string data=GetURLData(baseurl+"/game-highscorecsv-any.php?link="+gameid+"&items="+ss.str()+"&"+sorting,proxy,errorcode);
#else
	std::string data=GetURLData("file://g:/hs-get.txt","",errorcode);
#endif

	//proper scores begin with # and continue
	//or have message followed by #
	if(errorcode=="" && data.length()>0)
	{
		int pos=data.find_first_of("#");
		if(pos!=0)
			errorcode=data.substr(0,pos);
		else
		{
			//valid entry
			ss.str("");
			for(unsigned int i=1;i<data.length();i++)
			{
				//looping from first character to last
				if(data[i]<32)
				{
					//white space - valid for ascii/utf8
					if(ss.str()!="")
					{
						//white space reached and we haven't found any already so this is a full line
						temp.push_back(ss.str());
						ss.str("");
					}
				}
				else
					ss << data[i];
			}
				//last one
			if(ss.str()!="")
				temp.push_back(ss.str());
		}
	}

	//always name,score1,2,3,4,date
	std::vector<std::string>::iterator i;
	HighScoreEntry hs;
	for(i=temp.begin();i<temp.end();i++)
	{
		StringTokenizer token(*i,",");
		if(token.countTokens()==6)
		{
			hs.name=token.nextToken();
			hs.score1=token.nextIntToken();
			hs.score2=token.nextIntToken();
			hs.score3=token.nextIntToken();
			hs.score4=token.nextIntToken();
			hs.date=token.nextToken();
			scores.push_back(hs);
		}
	}

	temp.clear();

	return scores;
}


void uuencode_generic (char *dest, int game_number, int num_scores, int *scores, int *sizes)
{
    //sorry you cannot see this code
}

// Remove the added 'A' chars at the end ... otherwise it will just terminate the string
dest[pos_dest-added_bytes] = 0;
}
#ifdef MAC_VERSION
char* strupr(char* s) {
  char* pc=s;
  if (s)
    {
      while (*pc)
 {
   *pc=toupper(*pc);
   ++pc;
 }
    }
  return s;
}
#else
#endif

//create scorecode
//numberofScores is how many scores are used in the hs table at the website, 1,2,3,4
//datasizeinbytes is an array passed in with as many elements as numberofscores and contains how many bytes are used for each score. Usually for long/integer this should be 4
std::string CreateHighScoreCode(int gameCodeID, const HighScoreEntry& highscore,int numberOfScores, int* dataSizesInBytes)
{
	//create a new template on the server to take a game code and return
	//the code number, number of fields and size of fields from the table
	//then generate the code
	char code[255];
	int scores[4];
	if(1<=numberOfScores) scores[0]=highscore.score1;
	if(2<=numberOfScores) scores[1]=highscore.score2;
	if(3<=numberOfScores) scores[2]=highscore.score3;
	if(4<=numberOfScores) scores[3]=highscore.score4;

	uuencode_generic(code,gameCodeID,numberOfScores,scores,dataSizesInBytes);

	std::string returnCode=code;
	return returnCode;
}


//submit a score using high-score details - see other submithighscore for parameters, except...
//returnedHSCode is populated with the generated encryption code which might be useful for displaying on screen
//date is not required for creating a highscore
long SubmitHighScore(int gameCodeID, int numberOfScores, int* dataSizesInBytes,const HighScoreEntry& highscore,std::string& errorcode,std::string& returnedHSCode,const std::string& baseurl,const std::string& proxy)
{
	returnedHSCode=CreateHighScoreCode(gameCodeID,highscore,numberOfScores,dataSizesInBytes);
	if(returnedHSCode=="")
	{
		if(errorcode=="") errorcode="No high-score encryption generated! seek help!";
		return 0;
	}
	else
		return SubmitHighScore(returnedHSCode,highscore.name,errorcode,baseurl,proxy);
}

long SubmitHighScore(const std::string& code,const std::string& username,std::string& errorcode,const std::string& baseurl,const std::string& proxy)
{
//code is the generated encryption code to use, e.g. created by using CreateHighScoreCode()
// use 'y0yruch8ing' for a cheat (eg found a memory trainer hack)
//alternative is to use the other submit which takes in the scores and codes separately
//username is the name to use in the highscore
//errorstring is string passed in and is populated on return if there was an error
//returnedHSCode is populated with the generated encryption code which might be useful for displaying on screen
//baseurl is the url to use in case the website changes (leave out last /), e.g. 'http://retrospec.sgn.net'
//proxy is in case going behind a proxy server (e.g. 'myproxy:8080' would be proxy called myproxy on port 8080)
//
// returns position (1 onwards)
	std::string error;
	std::string codes;
	long position=0;
	std::string encryption=code;
	std::string formattedname=username;

	unsigned int findPos;
	while((findPos=encryption.find("+"))!=std::string::npos)
		encryption.replace(findPos,1,"%2B");

	while((findPos=formattedname.find("+"))!=std::string::npos)
		formattedname.replace(findPos,1,"%2B");
	while((findPos=formattedname.find(" "))!=std::string::npos)
		formattedname.replace(findPos,1,"%20");
	while((findPos=formattedname.find("&"))!=std::string::npos)
		formattedname.replace(findPos,1,"%26");

#ifndef RETRO_DEBUG_HS
	std::string data=GetURLData(baseurl+"/highscore.php?positiononly&code="+encryption+"&yourname="+formattedname+"&ordering=ASC",proxy,errorcode);
#else
	std::string data=GetURLData("file://g:/hs-submit.txt","",errorcode);
#endif
	if(errorcode=="")
	{
		//invalid is MSG:message
		//	error message
		//  MSG0:message (other message)
		//	MSG1:message (failed checksum)
		//	MSG2:message (game not found)
		//	MSG3:message (duplicate)
		//	MSG5:message (invalid game id)
		//	MSG7:message (invalid code length)
		//	a number - position ok
		StringTokenizer token(data,":");
		if(token.countTokens()>1)
		{
			token.nextToken();
			errorcode=token.remainingString();
		}
		else
		{
			position=token.nextIntToken();
			if(position==0)
				//must be an error without a MSG:
				errorcode=data;
		}
	}

	return position;	//0 for error - see error code
}
