#include "game_transam.h"

ScrollingText::ScrollingText(int width, int height, float incrementPerFrame,FONT* font)
{
	this->width=width;
	this->height=height;
	tape=GameFramework->CreateBitmap(width,height);
	currentPosition=0.0;
	this->incrementPerFrame=incrementPerFrame;
	totalWidth=0;
	this->font=font;
	ended=false;
	content="";
}

ScrollingText::~ScrollingText(void)
{
	if(tape)
		destroy_bitmap(tape);
}

void ScrollingText::SetNewContent(const std::string& content)
{
	ended=false;
	this->content=content+". If you live here let us know to get your details listed";
	totalWidth=text_length(this->font,content.c_str());
	currentPosition=0.0;
}

void ScrollingText::FrameUpdate()
{
	//scrolling to the left
	if(ended) return;
	currentPosition-=incrementPerFrame;
	if(currentPosition<(-(SCREEN_W+totalWidth*2)))
	{
		//currentPosition=-totalWidth;
		ended=true;
	}
}

BITMAP* ScrollingText::FrameDraw()
{
	if(!tape) return NULL;

	clear_to_color(tape,makecol(255,0,255));
	if(!ended)
		textout_ex(tape,this->font,content.c_str(),(int)(currentPosition+tape->w),0,-1,-1);

	return tape;
}
