#include "game_transam.h"
//layer 0 and 1 must always exist

//layer 0 is always the main game level that you see
//layer 1 is always the layer to hold the magic blocks for guiding enemy cars in the game
//layer 2 is the state in the main/quiz game, start/end blocks in race, 
//layer 3 is way-points in race

//layer 1 use block 57 to place where enemy might want to avoid. remember though
//	that the system auto places these around tiles. place them where you definitely want them
//	e.g. around mountains, solid blocks, edges to stop the car as auto-placed are random %

// layer 2: main game/quiz: use block 1 for state 1, block 2 for state 2, etc. as per the states[] array
//			race: place blocks 1 to 11 for players 1 to 11, and the cup tile (21) for the end line

// layer 3:  use block 1 for the first way-point, block 2 for the second, etc. keep within 40 blocks

/* map data

	unused1    (bit) : petrol
	unused2    (bit) : increased top speed
	unused3    (bit) : cup
	topleft	   (bit) : bounce and damage
	topright   (bit) : can place player/car here
	bottomleft (bit) : die
	bottomright(bit) : can place cup here

	userdata4 (short): US state number. lookup in main header file for name<->number
	userdata5  (char): topspeed restriction (decreased top speed) as percentage of maxspeed
    userdata6  (char): bounce and damage car, 1 for damage.
	userdata7  (char): non-entry block for car but not a collision

*/

void waitKey(bool wait)
{
	if(keypressed())
		while(keypressed()) readkey();

	if(wait) readkey();
}

void Levels::NewMapsCheck()
{
	waitKey(false);
	std::string url=GameConfiguration->GetCustom("rootsite","http://retrospec.sgn.net");
	std::string proxy=GameConfiguration->GetCustom("proxy","");
	std::string error="";
	std::string newData=GetURLData(url+"/users/nwalker/tranzam/newmaps.txt",proxy,error);
	std::string oldData=GameConfiguration->GetCustom("downloadmaps","");

	//if not found then returns html garbage
	if(newData.substr(0,1)!="#")
		newData="";
	else
		newData=newData.substr(1);

	int windowWidth=300;
	int windowHeight=100;
	bool newFound=false;
	fblend_rect_trans(GameFramework->DrawingSurface,SCREEN_W/2-windowWidth,SCREEN_H/2-windowHeight,windowWidth*2,windowHeight*2,makecol(239, 119, 32),246);

	if(error=="")
	{
		if(oldData==newData || newData=="")
			newData="No updates. Why not create some for download!";
		else
		{
			newFound=true;
			GameConfiguration->SetCustom("downloadmaps",newData);
		}

		textout_centre_ex(GameFramework->DrawingSurface,MainFont2,"Updates...",SCREEN_W/2,SCREEN_H/2-60,0,-1);
		textout_centre_ex(GameFramework->DrawingSurface,SmallFont,newData.c_str(),SCREEN_W/2,SCREEN_H/2,-30,-1);
		if(newFound)
		{
			std::ostringstream ss;
			ss << "Visit " << url << " for the maps";
			textout_centre_ex(GameFramework->DrawingSurface,SmallFont,ss.str().c_str(),SCREEN_W/2,SCREEN_H/2+20,0,-1);
		}
	}
	else
	{
		textout_centre_ex(GameFramework->DrawingSurface,MainFont2,"Error...",SCREEN_W/2,SCREEN_H/2-60,0,-1);
		textout_centre_ex(GameFramework->DrawingSurface,SmallFont,error.c_str(),SCREEN_W/2,SCREEN_H/2+20,0,-1);
	}

	textout_centre_ex(GameFramework->DrawingSurface,SmallFont,"Press Any Key",SCREEN_W/2,SCREEN_H/2+50,0,-1);
	GameFramework->ManualDraw();
	readkey();	
}

Level::Level()
{
	//default is the main game
	id=-1;
	highScore=0;
	currentTime=0;
	currentMiles=0;
	endState=0;
	enemyvel=0.7;
	this->enemies=20;
	this->gameMode=GT_NORMAL;
	this->name="";
	this->positionX=0;
	this->positionY=0;
	this->filename="transam.fmp";
	this->flag=0;
	this->countdown=0;
}

Levels::Levels(void)
{
	//default level
	Level* l=new Level();
	Add(l);

	ReadLevels();
}

void Levels::Add(Level* l)
{
	levels.push_back(l);
}

int Levels::Count(GameType gt)
{
	int count=0;
	std::vector<Level*>::iterator i;
	for(i=levels.begin();i!=levels.end();i++)
		if((*i)->gameMode==gt)
			count++;
	return count;
}

int Levels::Count()
{
	return levels.size();
}

//this is always used as the main game
Level* Levels::GetLevel(const unsigned int item)
{
	if(levels.size()<(item+1))
		return NULL;
	else
	{
		levels[item]->currentMiles=0;
		levels[item]->currentTime=levels[item]->countdown;
		levels[item]->endState=0;
		return levels[item];
	}
}

Level* Levels::GetLevel(const unsigned int item,GameType gt)
{
	if(levels.size()<(item+1))
		return NULL;
	else
	{
		unsigned int count=0;
		std::vector<Level*>::iterator i;
		for(i=levels.begin();i!=levels.end();i++)
			if((*i)->gameMode==gt)
			{
				if(count==item)
				{
					(*i)->currentMiles=0;
					(*i)->currentTime=(*i)->countdown;
					(*i)->endState=0;
					return *i;
				}
				count++;
			}
		return NULL;
	}
}

bool Levels::ReadLevels()
{
	Level* l;
	TiXmlDocument doc;
	if(!doc.LoadFile("levels.xml"))
	{
		return false;
	}

	//games
	TiXmlElement* games=doc.RootElement();
	TiXmlNode* nodule;
	TiXmlElement* node;
	TiXmlNode* nodeitem;
	int id;

	for( nodule= games->FirstChild( "level" );
		nodule;
		nodule = nodule->NextSibling( "level" ) )
	{
		l=new Level();
		node=nodule->ToElement();

		if(node->QueryIntAttribute("id",&id)!=TIXML_SUCCESS)
			id=-1;
		l->id=id;

		nodeitem=node->FirstChild("name");
		if(nodeitem) l->name=nodeitem->ToElement()->GetText();

		nodeitem=node->FirstChild("file");
		if(nodeitem) l->filename=nodeitem->ToElement()->GetText();

		nodeitem=node->FirstChild("mode");
		if(nodeitem) l->gameMode=(GameType)atoi(nodeitem->ToElement()->GetText());

		nodeitem=node->FirstChild("startx");
		if(nodeitem) l->positionX=atoi(nodeitem->ToElement()->GetText());

		nodeitem=node->FirstChild("starty");
		if(nodeitem) l->positionY=atoi(nodeitem->ToElement()->GetText());

		nodeitem=node->FirstChild("countdown");
		if(nodeitem) l->countdown=atoi(nodeitem->ToElement()->GetText());

		nodeitem=node->FirstChild("enemyvel");
		if(nodeitem) 
		{
			l->enemyvel=atoi(nodeitem->ToElement()->GetText());
			l->enemyvel=(l->enemyvel/10);
			if(l->enemyvel<0) l->enemyvel=0.0;
			if(l->enemyvel>20) l->enemyvel=20.0;
		}

		nodeitem=node->FirstChild("enemies");
		if(nodeitem) l->enemies=atoi(nodeitem->ToElement()->GetText());

		nodeitem=node->FirstChild("highscore");
		if(nodeitem) l->highScore=atoi(nodeitem->ToElement()->GetText());

		nodeitem=node->FirstChild("flags");	//so far either quiz type or number of cups in cup hunt
		if(nodeitem) l->flag=atoi(nodeitem->ToElement()->GetText());

		if(l->enemies<0) l->enemies=0;
		if(l->enemies>200) l->enemies=200;	//arbitrary

		if(l->name!="" && l->filename!="" && l->gameMode>=GT_NORMAL && l->gameMode<=GT_RACE)
		{
			Configuration::LogEntry("added level: " + l->name +" ("+l->filename+")");
			Add(l);
		}
		else
			Configuration::LogEntry("did not add level: " + l->name +" ("+l->filename+") as some entries were invalid.");

	}

	return true;
}

Levels::~Levels(void)
{
	std::vector<Level*>::iterator i;
	for(i=levels.begin();i!=levels.end();i++)
		delete(*i);

	levels.empty();
}
void Levels::SetHighScore(Level* level)
{
	if(!level)
		return;

	TiXmlDocument doc;
	if(!doc.LoadFile("levels.xml"))
		return;

	TiXmlElement* games=doc.RootElement();
	TiXmlNode* nodule;
	TiXmlElement* node;
	TiXmlElement* hs=NULL;
	std::ostringstream ss;
	ss << level->highScore;
	TiXmlElement newscore("highscore");

    TiXmlText t(ss.str());
	newscore.InsertEndChild(t);
	int id;

	for( nodule= games->FirstChild( "level" );
		nodule;
		nodule = nodule->NextSibling( "level" ) )
	{
		node=nodule->ToElement();
		if(node->QueryIntAttribute("id",&id)==TIXML_SUCCESS)
		{
			if(id==level->id)
			{
				//write the entry
				TiXmlNode* temp=node->FirstChild("highscore");
				if(temp)
					hs=temp->ToElement();
				if(hs)
					node->RemoveChild(hs);

				node->InsertEndChild(newscore);

				doc.SaveFile();
				break;
			}
		}
	}
}
